/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.billtype;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.util.CollectionUtils;

public class BillTypeOperationPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billformid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        AddCheckRefentityidsValidator validator = new AddCheckRefentityidsValidator();
        validator.setSeq(-100);
        e.addValidator((AbstractValidator)validator);
        super.onAddValidators(e);
    }

    private static class AddCheckRefentityidsValidator
    extends AbstractValidator {
        private AddCheckRefentityidsValidator() {
        }

        public void validate() {
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            if (dataEntities == null) {
                return;
            }
            ArrayList<String> billformids = new ArrayList<String>(dataEntities.length);
            for (ExtendedDataEntity dataEntity : dataEntities) {
                String billformid;
                Object object = dataEntity.getValue("billformid");
                if (!(object instanceof DynamicObject) || (billformid = ((DynamicObject)object).getString("number")) == null) continue;
                billformids.add(billformid);
            }
            if (CollectionUtils.isNotEmpty(billformids)) {
                this.getOption().setVariableValue("checkrefentityids", StringUtils.join((Object[])billformids.toArray(), (String)","));
            }
        }
    }
}

