/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.billtype;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IMobileBillView;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityObjectReader;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IMobileView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.formop.Refresh;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.AdminAppResult;
import kd.bos.servicehelper.BillTypeDifferentialHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.billtype.BillTypeServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.smc.ManageServiceHelper;
import kd.bos.util.CollectionUtils;

public class BillTypeTreeListEdit
extends StandardTreeListPlugin
implements ItemClickListener {
    private static Log log = LogFactory.getLog(BillTypeTreeListEdit.class);
    private static final String PREFIX_APP = "app_";
    private static final String PREFIX_CLOUD = "cloud_";
    private static final String KEY_BILLFORMID = "billformid";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DELETE = "btndel";
    private static final String BTN_PRINT = "printsetting";
    private static final String BTN_DEFAULT = "setdefault";
    private static final String BILLLISTAP = "billlistap";
    private static final String APP_ID = "billformid.bizappid.id";

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_NEW, BTN_EDIT, BTN_DELETE});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (BTN_PRINT.equals(itemKey)) {
            this.printSet();
        } else if (BTN_DEFAULT.equals(itemKey)) {
            Object hasRight = this.getView().getFormShowParameter().getCustomParam("hasRight");
            if (Boolean.FALSE.equals(hasRight)) {
                return;
            }
            this.setDefaultTpl();
            this.refreshList();
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter param = e.getParameter();
        String currentNodeId = this.getTreeModel().getCurrentNodeId().toString();
        String rootId = this.getTreeModel().getRoot().getId();
        if (currentNodeId.contains(PREFIX_CLOUD) || currentNodeId.contains(PREFIX_APP) || rootId.equals(currentNodeId)) {
            return;
        }
        param.setCustomParam("tree_parent_id", null);
        param.setCustomParam(KEY_BILLFORMID, (Object)currentNodeId);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String opk = evt.getOperateKey();
        if (BTN_DEFAULT.equals(opk) && !evt.getOperationResult().isSuccess()) {
            this.getView().getFormShowParameter().setCustomParam("hasRight", (Object)false);
            return;
        }
        if (("audit".equals(opk) || "delete".equals(opk)) && evt.getOperationResult().isSuccess()) {
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            List successPkIds = evt.getOperationResult().getSuccessPkIds();
            if (successPkIds.isEmpty()) {
                return;
            }
            Map datas = BusinessDataServiceHelper.loadFromCache((Object[])successPkIds.toArray(), (String)"bos_billtype");
            for (ListSelectedRow listSelectedRow : selectedRows) {
                Long billtypeId = (Long)listSelectedRow.getPrimaryKeyValue();
                if ("audit".equals(evt.getOperateKey())) {
                    DynamicObject billtypeObj = (DynamicObject)datas.get(billtypeId);
                    DynamicObject bizObj = (DynamicObject)billtypeObj.get(KEY_BILLFORMID);
                    String billNumber = bizObj.getPkValue().toString();
                    List differentialControlInfos = BillTypeDifferentialHelper.getDifferentialControlInfos((String)billNumber, (long)billtypeId);
                    BillTypeDifferentialHelper.storeDifferentialControlInfos((String)billNumber, (Long)billtypeId, (List)differentialControlInfos);
                    continue;
                }
                BillTypeDifferentialHelper.deleteBillTypeRuntime((Long)billtypeId);
            }
        }
    }

    public void initializeTree(EventObject e) {
        this.initTree();
    }

    public void refreshNode(RefreshNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        List<TreeNode> childNodes = this.getChildNodes(nodeId);
        e.setChildNodes(childNodes);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String nodeId = e.getNodeId().toString();
        QFilter[] billFilters = new QFilter[]{new QFilter("modeltype", "=", (Object)"BillFormModel"), new QFilter("billtype", "=", (Object)Boolean.TRUE)};
        Object[] billFormIds = null;
        if (this.isTopNodeId(nodeId)) {
            return;
        }
        if (nodeId.contains(PREFIX_CLOUD)) {
            String cloudId = StringUtils.substringAfter((String)nodeId, (String)"_");
            billFormIds = EntityObjectReader.loadEntityNumbersInCloud((String)cloudId, (QFilter[])billFilters);
        } else if (nodeId.contains(PREFIX_APP)) {
            String appId = StringUtils.substringAfter((String)nodeId, (String)"_");
            billFormIds = EntityObjectReader.loadEntityNumbersInApp((String)appId, (QFilter[])billFilters);
            List<TreeNode> nodes = this.getChildNodes(nodeId);
            TreeView tView = this.getTreeListView().getTreeView();
            tView.addNodes(nodes);
        } else {
            billFormIds = new Object[]{nodeId};
        }
        if (billFormIds != null) {
            QFilter filter = null;
            filter = billFormIds.length == 1 ? new QFilter(KEY_BILLFORMID, "=", billFormIds[0]) : new QFilter(KEY_BILLFORMID, "in", (Object)billFormIds);
            e.addQFilter(filter);
        }
        e.setCancel(true);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        if (evt.getSource() instanceof Refresh && StringUtils.equals((CharSequence)"refresh", (CharSequence)((Refresh)((Object)evt.getSource())).getOperateKey())) {
            String focusId = this.getTreeListView().getTreeView().getTreeState().getFocusNodeId();
            this.getTreeModel().refreshNode((Object)"-1");
            TreeNode root = this.getTreeModel().getRoot();
            this.getTreeListView().getTreeView().deleteAllNodes();
            this.getTreeListView().getTreeView().addNode(root);
            TreeNode focusNode = root.getTreeNode(focusId, 20);
            if (focusNode == null) {
                focusNode = root;
            }
            focusNode.setExpend(true);
            this.getTreeListView().getTreeView().focusNode(focusNode);
            this.getTreeListView().refreshTreeNode(focusNode.getId(), true);
            evt.setCancel(true);
        }
    }

    public void setFilter(SetFilterEvent e) {
        AdminAppResult adminAppResult = PermissionServiceHelper.getAdminApps((Long)RequestContext.get().getCurrUserId(), (boolean)true);
        if (adminAppResult.needAdminAppRange()) {
            List adminAppIds = adminAppResult.getAppIds();
            if (!CollectionUtils.isEmpty((Collection)adminAppIds)) {
                Set<String> extendAppIds = this.getExtendAppIds();
                if (!extendAppIds.isEmpty()) {
                    adminAppIds.removeAll(extendAppIds);
                }
                QFilter adminAppFilter = new QFilter(APP_ID, "in", (Object)adminAppIds);
                e.addCustomQFilter(adminAppFilter);
            } else {
                QFilter adminFilter = new QFilter(APP_ID, "in", Collections.emptyList());
                e.addCustomQFilter(adminFilter);
            }
        } else {
            Set<String> disableObjIds = this.getDisabledAppIds();
            QFilter filter = new QFilter(APP_ID, "not in", disableObjIds);
            e.addCustomQFilter(filter);
        }
    }

    private Set<String> getExtendAppIds() {
        Set disabledAppIds = ManageServiceHelper.getDisabledAppIds();
        return this.getExtendAppIds(disabledAppIds);
    }

    private Set<String> getDisabledAppIds() {
        Set disabledAppIds = ManageServiceHelper.getDisabledAppIds();
        Set<String> extendAppIds = this.getExtendAppIds(disabledAppIds);
        disabledAppIds.addAll(extendAppIds);
        return disabledAppIds;
    }

    private Set<String> getExtendAppIds(Set<String> bizAppId) {
        String selectFields = "id";
        QFilter[] filters = new QFilter[]{new QFilter("masterid", "in", bizAppId)};
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)selectFields, (QFilter[])filters);
        HashSet<String> extendAppIds = new HashSet<String>();
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String id = dynamicObject.getString("id");
                if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                extendAppIds.add(id);
            }
        }
        return extendAppIds;
    }

    private void initTree() {
        TreeNode root = new TreeNode();
        root.setId("-1");
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"BillTypeTreeListEdit_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        root.addChildren(this.getCloudNodes());
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.setBarItemEnable(false, true);
    }

    private List<TreeNode> getCloudNodes() {
        TreeNode root = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree(null, null, null, (String)"app");
        List clouds = null;
        if (root != null) {
            clouds = root.getChildren();
        }
        if (clouds == null) {
            return new ArrayList<TreeNode>(0);
        }
        Set disabledCloudIds = ManageServiceHelper.getDisabledCloudIds();
        Set<String> disabledAppIds = this.getDisabledAppIds();
        AdminAppResult adminAppResult = PermissionServiceHelper.getAdminApps((Long)RequestContext.get().getCurrUserId(), (boolean)true);
        log.info("Cloud is diabled : {}, Appid is diabled : {}, needAdminAppRange : {}, rangeApp size : {}", new Object[]{disabledCloudIds, disabledAppIds, adminAppResult.needAdminAppRange(), adminAppResult.getAppIds() == null ? "null" : Integer.valueOf(adminAppResult.getAppIds().size())});
        Iterator cloudIterator = clouds.iterator();
        while (cloudIterator.hasNext()) {
            TreeNode cloud = (TreeNode)cloudIterator.next();
            String cloudId = cloud.getId();
            String cloudNodeId = PREFIX_CLOUD + cloudId;
            cloud.setId(cloudNodeId);
            cloud.setData((Object)"cloud");
            List apps = cloud.getChildren();
            if (apps == null || disabledCloudIds.contains(cloudId)) {
                cloudIterator.remove();
                continue;
            }
            Iterator appIterator = apps.iterator();
            while (appIterator.hasNext()) {
                boolean adminNotCharge;
                TreeNode app = (TreeNode)appIterator.next();
                String appId = app.getId();
                String appNodeId = PREFIX_APP + appId;
                app.setId(appNodeId);
                app.setParentid(cloudNodeId);
                app.setData((Object)"app");
                boolean bl = adminNotCharge = adminAppResult.needAdminAppRange() && (adminAppResult.getAppIds() == null || !adminAppResult.getAppIds().contains(appId));
                if (disabledAppIds.contains(appId) || adminNotCharge) {
                    appIterator.remove();
                    continue;
                }
                app.setChildren(new ArrayList(0));
            }
            if (!apps.isEmpty()) continue;
            cloudIterator.remove();
        }
        return clouds;
    }

    private List<TreeNode> getChildNodes(String parentId) {
        List<TreeNode> cloudNodes = null;
        if (this.getTreeModel().getRoot().getId().equals(parentId)) {
            cloudNodes = this.getCloudNodes();
        } else {
            if (parentId.startsWith(PREFIX_APP)) {
                List<TreeNode> billNodes = this.buildBillNodesInApp(parentId.substring(PREFIX_APP.length()));
                if (billNodes == null || billNodes.isEmpty()) {
                    return null;
                }
                return billNodes;
            }
            TreeNode node = this.getTreeModel().getRoot().getTreeNode(parentId, 20);
            if (node != null) {
                return node.getChildren();
            }
        }
        return cloudNodes;
    }

    private List<TreeNode> buildBillNodesInApp(String appId) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            return new ArrayList<TreeNode>(0);
        }
        QFilter[] filters = new QFilter[]{new QFilter("modeltype", "=", (Object)"BillFormModel"), new QFilter("billtype", "=", (Object)Boolean.TRUE)};
        List billNodes = EntityObjectReader.buildBillNodesInApp((String)appId, (QFilter[])filters);
        if (billNodes == null || billNodes.isEmpty()) {
            return billNodes;
        }
        for (TreeNode bill : billNodes) {
            String parentId = PREFIX_APP + appId;
            bill.setParentid(parentId);
        }
        return billNodes;
    }

    private void setBarItemEnable(boolean enable, boolean isSetAll) {
        if (isSetAll) {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{BTN_NEW, BTN_EDIT, BTN_DELETE});
        } else {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{BTN_NEW});
            this.getView().setEnable(Boolean.valueOf(!enable), new String[]{BTN_EDIT, BTN_DELETE});
        }
    }

    private boolean isTopNodeId(String currNodeId) {
        return currNodeId.equals(this.getTreeModel().getRoot().getId());
    }

    private void refreshList() {
        ListView view = (ListView)this.getView();
        view.refresh();
    }

    private void setDefaultTpl() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.isEmpty()) {
            return;
        }
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"BillTypeTreeListEdit_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        ListSelectedRow listSelectedRow = selectedRows.get(0);
        Long billTypeId = (Long)listSelectedRow.getPrimaryKeyValue();
        BillTypeServiceHelper.setDefaultBillType((Long)billTypeId);
    }

    private void printSet() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"BillTypeTreeListEdit_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        ListSelectedRow listSelectedRow = selectedRows.get(0);
        Long billTypeID = (Long)listSelectedRow.getPrimaryKeyValue();
        Map cacheObjs = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{billTypeID}, (String)"bos_billtype");
        DynamicObject billTypeObj = (DynamicObject)cacheObjs.get(billTypeID);
        if (billTypeObj == null) {
            return;
        }
        String formId = billTypeObj.getString("billformId_id");
        if (this.getView() instanceof IMobileBillView || this.getView() instanceof IMobileView) {
            MobileBillShowParameter mo = (MobileBillShowParameter)this.getView().getFormShowParameter();
            String entityId = mo.getFormConfig().getEntityTypeId();
            MobileFormShowParameter param = new MobileFormShowParameter();
            param.getOpenStyle().setShowType(ShowType.NonModal);
            param.setFormId("bos_mobileprintsetting");
            param.setCustomParam("formid", (Object)formId);
            param.setCustomParam("entityid", (Object)entityId);
            this.getView().showForm((FormShowParameter)param);
        } else {
            FormShowParameter param = new FormShowParameter();
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setFormId("bos_printsetting");
            param.setCustomParam("formid", (Object)formId);
            param.setCustomParam("isFromBilltypeListPage", (Object)"true");
            this.getView().showForm(param);
        }
    }
}

