/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.debug.Impl;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.plugin.debug.Impl.BusinessDataReaderDebug;
import kd.bos.form.plugin.debug.Impl.CacheKeyUtilDebug;
import kd.bos.form.plugin.debug.Impl.ControlDebug;
import kd.bos.form.plugin.debug.Impl.DataEntityPropertyDebug;
import kd.bos.form.plugin.debug.Impl.DynamicObjectTypeDebug;
import kd.bos.form.plugin.debug.Impl.FormDataModelDebug;
import kd.bos.form.plugin.debug.Impl.FormViewDebug;
import kd.bos.form.plugin.debug.Impl.PageCacheDebug;
import kd.bos.form.plugin.debug.Impl.SessionManagerDebug;
import kd.bos.form.plugin.debug.Impl.StaticMethodDebug;
import kd.bos.form.plugin.debug.executor.DMethodParam;
import kd.bos.mvc.form.FormView;

public class ManagePlugInDebug {
    Map<String, Method> accessMethodMap;
    Map<String, Field> accessFieldMap;

    protected String[] getAccessMethodNames() {
        return new String[0];
    }

    protected String[] getAccessfieldNames() {
        return new String[0];
    }

    protected Class<?> getClassType() {
        return FormView.class;
    }

    public Object getInstance() {
        return null;
    }

    public AccessibleObject getAction(String actionName) {
        return this.getAction(actionName, null);
    }

    public AccessibleObject getAction(String actionName, List<DMethodParam> params) {
        Method m = this.getMethod(actionName, params);
        if (m != null) {
            return m;
        }
        Field f = this.getField(actionName);
        if (f == null) {
            throw new KDException(BosErrorCode.bOS, new Object[]{String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u5b58\u5728\u65b9\u6cd5\u6216\u5c5e\u6027%2$s\uff01", (String)"ManagePlugInDebug_0", (String)"bos-form-business", (Object[])new Object[0]), this.getClassType().getName(), actionName)});
        }
        return f;
    }

    public Method getMethod(String actionName, List<DMethodParam> params) {
        return this.getAccessMethods(params).get(actionName);
    }

    public Field getField(String actionName) {
        return this.getAccessFields().get(actionName);
    }

    private Map<String, Method> getAccessMethods(List<DMethodParam> params) {
        if (this.accessMethodMap == null) {
            HashMap<String, Method> methodMap = new HashMap<String, Method>();
            block0: for (Method method : this.getClassType().getMethods()) {
                String[] ms;
                for (String mn : ms = this.getAccessMethodNames()) {
                    if (!method.getName().equals(mn) || (params != null || method.getParameters().length != 0) && (params == null || method.getParameters().length != params.size())) continue;
                    boolean isDiff = false;
                    if (params != null) {
                        for (int i = 0; i < params.size(); ++i) {
                            Parameter c1 = method.getParameters()[i];
                            if (c1.getType().isAssignableFrom(params.get(i).getClassType())) continue;
                            isDiff = true;
                            break;
                        }
                    }
                    if (isDiff) continue block0;
                    methodMap.put(mn, method);
                    continue block0;
                }
            }
            this.accessMethodMap = methodMap;
        }
        return this.accessMethodMap;
    }

    protected Map<String, Field> getAccessFields() {
        if (this.accessFieldMap == null) {
            HashMap<String, Field> fieldMap = new HashMap<String, Field>(16);
            for (String fieldName : this.getAccessfieldNames()) {
                Field field = this.getField(this.getClassType(), fieldName);
                if (field == null) {
                    // empty if block
                }
                fieldMap.put(fieldName, field);
            }
            this.accessFieldMap = fieldMap;
        }
        return this.accessFieldMap;
    }

    public static ManagePlugInDebug getType(String classType) {
        if ("kd.bos.mvc.form.FormView".equals(classType)) {
            return new FormViewDebug();
        }
        if ("kd.bos.mvc.bill.BillModel".equals(classType)) {
            return new FormDataModelDebug();
        }
        if ("kd.bos.entity.datamodel.IDataModel".equals(classType)) {
            return new FormDataModelDebug();
        }
        if ("kd.bos.mvc.form.FormDataModel".equals(classType)) {
            return new FormDataModelDebug();
        }
        if ("kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType".equals(classType)) {
            return new DynamicObjectTypeDebug();
        }
        if ("kd.bos.dataentity.metadata.IDataEntityProperty".equals(classType)) {
            return new DataEntityPropertyDebug();
        }
        if ("kd.bos.mvc.SessionManager".equals(classType)) {
            return new SessionManagerDebug();
        }
        if ("kd.bos.form.control.Control".equals(classType)) {
            return new ControlDebug();
        }
        if ("kd.bos.mvc.cache.PageCache".equals(classType)) {
            return new PageCacheDebug();
        }
        if ("kd.bos.data.BusinessDataReader".equals(classType)) {
            return new BusinessDataReaderDebug();
        }
        if ("kd.bos.entity.cache.CacheKeyUtil".equals(classType)) {
            return new CacheKeyUtilDebug();
        }
        if ("BusinessDataReader".equals(classType)) {
            return new BusinessDataReaderDebug();
        }
        if ("CacheKeyUtil".equals(classType)) {
            return new CacheKeyUtilDebug();
        }
        return ManagePlugInDebug.getStaticMethodDebug(classType);
    }

    private static ManagePlugInDebug getStaticMethodDebug(String classType) {
        StaticMethodDebug staticMethod = new StaticMethodDebug(classType);
        return staticMethod.getManageDebug();
    }

    private Field getField(Class<?> classType, String fieldName) {
        Field field;
        try {
            field = classType.getField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException e) {
            try {
                field = classType.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException | SecurityException e1) {
                if (classType.getSuperclass() == null || classType.getSuperclass() == Object.class) {
                    return null;
                }
                return this.getField(classType.getSuperclass(), fieldName);
            }
        }
        return field;
    }
}

