/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.debug.Impl;

import java.util.HashMap;
import java.util.Map;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.plugin.debug.Impl.ManagePlugInDebug;

class StaticMethodDebug
extends ManagePlugInDebug {
    private static final String ISSERVERSIDEOPEN = "isServerSideOpen";
    private static final String ISOUTLOG = "isOutLog";
    private static final String GETFLEXPROPERTIES = "getFlexProperties";
    private static final String ISBILLTYPELAYOUT = "isBillTypeLayout";
    private static final String GETVERSION = "getVersion";
    private static final String GETALLPORTALAPPCACHE = "getAllPortalAppCache";
    private static final String CLEANALLAPPMETADATACACHE = "cleanAllAppMetadataCache";
    String classType;
    static Map<String, String[]> methodMap = new HashMap<String, String[]>();

    StaticMethodDebug(String classType) {
        this.classType = classType;
    }

    ManagePlugInDebug getManageDebug() {
        if (methodMap.containsKey(this.classType)) {
            return this;
        }
        return null;
    }

    @Override
    protected Class<?> getClassType() {
        try {
            return Class.forName(this.classType);
        }
        catch (ClassNotFoundException e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{e.getMessage()});
        }
    }

    @Override
    protected String[] getAccessMethodNames() {
        return methodMap.get(this.classType);
    }

    @Override
    protected String[] getAccessfieldNames() {
        return new String[0];
    }

    static {
        String[] flexEntityMetaUtilsMethods = new String[]{ISSERVERSIDEOPEN, ISOUTLOG, GETFLEXPROPERTIES};
        methodMap.put("kd.bos.entity.flex.FlexEntityMetaUtils", flexEntityMetaUtilsMethods);
        String[] layoutControlInfoMethods = new String[]{ISBILLTYPELAYOUT, ISOUTLOG};
        methodMap.put("kd.bos.entity.LayoutControlInfo", layoutControlInfoMethods);
        String[] domainModelTypeMethods = new String[]{GETVERSION};
        methodMap.put("kd.bos.metadata.domainmodel.DomainModelType", domainModelTypeMethods);
        String[] metadataDaoMethods = new String[]{GETALLPORTALAPPCACHE, CLEANALLAPPMETADATACACHE};
        methodMap.put("kd.bos.metadata.dao.MetadataDao", metadataDaoMethods);
    }
}

