/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.debug.cmd;

import java.util.ArrayList;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.plugin.debug.cmd.DebugCommand;
import kd.bos.form.plugin.debug.cmd.DebugCommandContext;
import kd.bos.metadata.BuildFormDesignMeta;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.datamanager.DataEntityCacheManager;

public class ClearCacheCommand
extends DebugCommand {
    private static String[] cmdtoken = new String[]{"m", "d", "am", "ad", "t", "rds"};
    private List<String> parameter = new ArrayList<String>();

    public ClearCacheCommand(DebugCommandContext ctx, String[] cmdStrings) {
        super(ctx);
        this.initCmd(cmdStrings);
    }

    @Override
    public String exec() {
        if (this.getCmdParam().equals(cmdtoken[0])) {
            return this.clearMetaCache(this.parameter);
        }
        if (this.getCmdParam().equals(cmdtoken[1])) {
            return this.clearDataCache(this.parameter);
        }
        if (this.getCmdParam().equals(cmdtoken[2])) {
            return this.clearAppMetaCache();
        }
        if (this.getCmdParam().equals(cmdtoken[3])) {
            return this.clearAppDataCache(this.parameter);
        }
        if (this.getCmdParam().equals(cmdtoken[4])) {
            return this.clearTypeDataCache(this.parameter);
        }
        if (this.getCmdParam().equals(cmdtoken[5])) {
            return this.clearRedisCache(this.parameter);
        }
        return "debug command does not match";
    }

    private String clearMetaCache(List<String> params) {
        String formNumber = params.get(0);
        String id = MetadataDao.getIdByNumber((String)formNumber, (MetaCategory)MetaCategory.Form);
        if (StringUtils.isBlank((CharSequence)id)) {
            return String.format("FormNumber:%s does not exist", formNumber);
        }
        BuildFormDesignMeta meta = new BuildFormDesignMeta();
        meta.setId(id);
        meta.setNumber(formNumber);
        MainEntityType mt = EntityMetadataCache.getDataEntityType((String)formNumber);
        if (mt != null) {
            meta.setTableName(mt.getAlias());
        }
        ArrayList<BuildFormDesignMeta> list = new ArrayList<BuildFormDesignMeta>();
        list.add(meta);
        MetadataDao.clearCache(list);
        return String.format("clear metacache %s finish!", formNumber);
    }

    private String clearDataCache(List<String> params) {
        String formNumber = params.get(0);
        this.clearCacheByNumber(formNumber);
        return String.format("clear %s data cache finish!", formNumber);
    }

    private String clearAppMetaCache() {
        this.clearCacheByNumber("bos_devportal_bizapp");
        MetadataDao.cleanAllAppMetadataCache();
        return "clear app meta cache finish!";
    }

    private String clearAppDataCache(List<String> params) {
        String appKey = params.get(0);
        IAppCache appCache = AppCache.get((String)appKey);
        appCache.clear();
        return String.format("clear app:%s data cache finish!", appKey);
    }

    private String clearTypeDataCache(List<String> params) {
        Class<?> c1;
        String className = params.get(0);
        try {
            c1 = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new KDException((Throwable)e, BosErrorCode.actionClassNotFound, new Object[]{"class not found"});
        }
        IDataEntityType type = OrmUtils.getDataEntityType(c1);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager(type);
        cacheManager.removeByDt();
        return String.format("clear type:%s data cache finish!", className);
    }

    private String clearRedisCache(List<String> params) {
        String regionKey = params.get(0);
        String type = params.get(1);
        if (regionKey.equals("null")) {
            regionKey = null;
        }
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(regionKey, new DistributeCacheHAPolicy());
        if (params.size() > 2) {
            String key = params.get(2);
            cache.remove(type, key);
            return String.format("clear redis cache remove: %s, %s finish!", type, key);
        }
        cache.removeType(type);
        return String.format("clear redis cache removeType: %s finish!", type);
    }

    @Override
    protected void initCmd(String[] cmdStrings) {
        super.initCmd(cmdStrings);
        this.checkCmd(cmdStrings);
        for (String para : this.getParameter()) {
            this.parameter.add(para);
        }
    }

    private void checkCmd(String[] cmdStrings) {
        if (cmdStrings.length < 2 || cmdStrings.length < 3 && !this.getCmdParam().equals(cmdtoken[2])) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"debug command error."});
        }
        if (StringUtils.isBlank((CharSequence)cmdStrings[2]) && this.getCmdParam().equals(cmdtoken[2])) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"debug command error."});
        }
        boolean isMatch = false;
        for (String str : cmdtoken) {
            if (!str.equals(this.getCmdParam())) continue;
            isMatch = true;
            break;
        }
        if (!isMatch) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"debug command does not match."});
        }
    }

    private void clearCacheByNumber(String formNumber) {
        MainEntityType mt = EntityMetadataCache.getDataEntityType((String)formNumber);
        if (mt != null && !StringUtils.isBlank((CharSequence)mt.getAlias())) {
            DataEntityCacheManager cm = new DataEntityCacheManager(mt.getAlias());
            cm.removeByDt();
        }
    }

    private void clearMetaCacheByNumber(String formNumber) {
        String id = MetadataDao.getIdByNumber((String)formNumber, (MetaCategory)MetaCategory.Form);
        BuildFormDesignMeta meta = new BuildFormDesignMeta();
        meta.setId(id);
        meta.setNumber(formNumber);
        MainEntityType mt = EntityMetadataCache.getDataEntityType((String)formNumber);
        if (mt != null) {
            meta.setTableName(mt.getAlias());
        }
        ArrayList<BuildFormDesignMeta> list = new ArrayList<BuildFormDesignMeta>();
        list.add(meta);
        MetadataDao.clearCache(list);
    }
}

