/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.debug.cmd;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.plugin.debug.cmd.DebugCommandContext;

public abstract class DebugCommand {
    private DebugCommandContext ctx;
    private String cmd;
    private String cmdParam;
    private String[] parameter;
    private String outType = "json";
    private List<String> downLoadUrls = new ArrayList<String>();

    public DebugCommandContext getContext() {
        return this.ctx;
    }

    public String getCmd() {
        return this.cmd;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public String getCmdParam() {
        return this.cmdParam;
    }

    public void setCmdParam(String cmdParam) {
        this.cmdParam = cmdParam;
    }

    public String[] getParameter() {
        return this.parameter;
    }

    public String getOutType() {
        return this.outType;
    }

    protected void setOutType(String outType) {
        this.outType = outType;
    }

    public List<String> getDownLoadUrls() {
        return this.downLoadUrls;
    }

    public void addDownLoadUrls(String url) {
        this.downLoadUrls.add(url);
    }

    public DebugCommand(DebugCommandContext ctx) {
        this.ctx = ctx;
    }

    public String getCmdInfo() {
        return String.format("%s - %s", this.cmd, this.cmdParam);
    }

    protected void initCmd(String[] cmdStrings) {
        if (cmdStrings.length < 2) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"debug command error."});
        }
        this.cmd = cmdStrings[0];
        String str = cmdStrings[1];
        if (!str.startsWith("-")) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"debug command error."});
        }
        this.cmdParam = str.split("-")[1];
        if (cmdStrings.length == 2 || StringUtils.isBlank((CharSequence)cmdStrings[2])) {
            this.parameter = new String[0];
        } else {
            String[] tmpStrs = cmdStrings[2].trim().split(" ");
            ArrayList<String> strList = new ArrayList<String>();
            for (String tmpStr : tmpStrs) {
                if (!StringUtils.isNotBlank((CharSequence)tmpStr)) continue;
                strList.add(tmpStr);
            }
            this.parameter = strList.toArray(new String[0]);
        }
    }

    public abstract String exec();
}

