/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.debug.cmd;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.debug.cmd.StatusInfo;
import kd.bos.mvc.SessionManager;
import org.apache.commons.lang3.StringUtils;

public class DebugCommandContext {
    private String pageId;
    private StatusInfo statusInfo;
    private IPageCache pageCache;
    private Map<String, String> varExprs = new HashMap<String, String>();

    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
        this.pageCache.put("debug_PageId", pageId);
    }

    public DebugCommandContext(IPageCache pageCache) {
        this.pageCache = pageCache;
        this.pageId = pageCache.get("debug_PageId");
        this.statusInfo = new StatusInfo();
        this.initInits(pageCache);
        this.initVars(pageCache);
    }

    public IFormView getFormView() {
        if (StringUtils.isBlank((CharSequence)this.pageId)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"pageId is null"});
        }
        return SessionManager.getCurrent().getViewNoPlugin(this.pageId);
    }

    public void addVar(String var, String expr) {
        this.varExprs.put(var, expr);
    }

    public void removeVar(String var) {
        this.varExprs.remove(var);
    }

    public void clear() {
        this.varExprs.clear();
    }

    public String getExpr(String var) {
        return this.varExprs.get(var);
    }

    public Set<String> getVars() {
        return this.varExprs.keySet();
    }

    public Map<String, String> getVarExprMap() {
        return this.varExprs;
    }

    public void setErrInfo(String errInfo) {
        this.statusInfo.setPageId(this.pageId);
        this.statusInfo.setErrInfo(errInfo);
    }

    public void update() {
        this.pageCache.put("debug_Vars", SerializationUtils.toJsonString(this.varExprs));
        String refMaxQuantity = this.varExprs.get("refMaxQuantity");
        if (StringUtils.isNotBlank((CharSequence)refMaxQuantity)) {
            DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("BASEDATA_REFERENCING_PROPERTY ", new DistributeCacheHAPolicy(true, true));
            cache.put(CacheKeyUtil.getAcctId() + ".refMaxQuantity", (Object)refMaxQuantity, 600);
        }
    }

    public String getStatusInfo() {
        return this.statusInfo.toString();
    }

    private void initInits(IPageCache pageCache) {
        String debugInits = pageCache.get("debug_Inits");
        if (StringUtils.isBlank((CharSequence)debugInits)) {
            return;
        }
        Map varMap = (Map)SerializationUtils.fromJsonString((String)pageCache.get("debug_Inits"), Map.class);
    }

    private void initVars(IPageCache pageCache) {
        String debugVars = pageCache.get("debug_Vars");
        if (StringUtils.isBlank((CharSequence)debugVars)) {
            return;
        }
        Map varMap = (Map)SerializationUtils.fromJsonString((String)debugVars, Map.class);
        for (Map.Entry entry : varMap.entrySet()) {
            this.varExprs.put((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

