/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.debug.cmd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.SqlBuilder;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.api.model.DBInstance;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.EntityItemTypes;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.plugin.debug.cmd.DebugCommand;
import kd.bos.form.plugin.debug.cmd.DebugCommandContext;
import kd.bos.form.plugin.debug.cmd.MulLangSqlCommand;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class GenCommentSqlCommand
extends DebugCommand {
    private static String[] cmdtoken = new String[]{"sql", "sql2file", "comment"};
    private String dbType;
    private int start = 0;
    private int end = 0;
    private Map<String, Object> procAppFormMap = new HashMap<String, Object>();
    private static final Log log = LogFactory.getLog(MulLangSqlCommand.class);

    public GenCommentSqlCommand(DebugCommandContext ctx, String[] cmdStrings) {
        super(ctx);
        this.initCmd(cmdStrings);
    }

    @Override
    public String exec() {
        if ("?".equals(this.getCmdParam())) {
            String helpStrBuilder = "genCommentSql -comment dbtype start end specifyform" + System.lineSeparator() + String.format(ResManager.loadKDString((String)"  -sql    \u751f\u6210\u6ce8\u91ca(\u6807\u9898)sql%s", (String)"GenCommentSqlCommand_15", (String)"bos-form-business", (Object[])new Object[0]), System.lineSeparator()) + String.format(ResManager.loadKDString((String)"  -sql2file  \u751f\u6210\u6ce8\u91ca(\u6807\u9898)sql\u6587\u4ef6%s", (String)"GenCommentSqlCommand_16", (String)"bos-form-business", (Object[])new Object[0]), System.lineSeparator()) + String.format(ResManager.loadKDString((String)"  -comment   \u53d6\u5bf9\u8c61\u6807\u9898%s", (String)"GenCommentSqlCommand_17", (String)"bos-form-business", (Object[])new Object[0]), System.lineSeparator()) + String.format(ResManager.loadKDString((String)"  dbtype  \u6570\u636e\u5e93\u7c7b\u578b\uff0c\u5982\uff1aOracle SQLServer PostgreSQL MySQL%s", (String)"GenCommentSqlCommand_18", (String)"bos-form-business", (Object[])new Object[0]), System.lineSeparator()) + String.format(ResManager.loadKDString((String)"  start   \u5f00\u59cb\u8bb0\u5f55\u53f7%s", (String)"GenCommentSqlCommand_19", (String)"bos-form-business", (Object[])new Object[0]), System.lineSeparator()) + String.format(ResManager.loadKDString((String)"  end     \u7ed3\u675f\u8bb0\u5f55\u53f7%s", (String)"GenCommentSqlCommand_20", (String)"bos-form-business", (Object[])new Object[0]), System.lineSeparator()) + String.format(ResManager.loadKDString((String)"  specifyform  \u6307\u5b9a\u5e94\u7528\u6216\u8868\u5355\u3002\u53ef\u9009\u53c2\u6570\uff0c\u672a\u6307\u5b9a\u8f93\u51fa\u5168\u90e8\uff0c\u8f93\u51fa\u5168\u90e8\u65f6\u8bf7\u63a7\u5236start\u548cend\u5206\u6279\u53d6\u6570\uff0c\u5efa\u8baeend-start<2000\u3002 \u6307\u5b9a\u5e94\u7528\u548c\u8868\u5355 {\"gl\":[\"cas_agentpaybill\",\"gl_voucher\"]} \u53ea\u6307\u5b9a\u5e94\u7528\uff1a {\"gl\",\"ar\"} \u53ea\u6307\u5b9a\u8868\u5355\uff1a {\"\":[\"cas_agentpaybill\",\"gl_voucher\"]}%s", (String)"GenCommentSqlCommand_21", (String)"bos-form-business", (Object[])new Object[0]), System.lineSeparator()) + "e.g. " + System.lineSeparator() + "     genCommentSql -comment MySQL 0 10 {\"gl\":[\"cas_agentpaybill\",\"gl_voucher\"]}" + System.lineSeparator() + "     genCommentSql -comment MySQL 1000 2000" + System.lineSeparator();
            return "::" + helpStrBuilder;
        }
        if (this.getCmdParam().equals(cmdtoken[2])) {
            Account account = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
            List dbs = account.getDBInstanceList();
            HashMap<String, String> dbRouteInstanceMap = new HashMap<String, String>(dbs.size());
            for (DBInstance dbInstance : dbs) {
                dbRouteInstanceMap.put(dbInstance.getRouteKey(), dbInstance.getDBInsatnce());
            }
            return SerializationUtils.toJsonString(this.getCommentInfo(dbRouteInstanceMap));
        }
        if (this.getCmdParam().equals(cmdtoken[1])) {
            this.setOutType("file");
        }
        return this.genSql();
    }

    @Override
    protected void initCmd(String[] cmdStrings) {
        String formJson;
        super.initCmd(cmdStrings);
        if (this.getCmdParam().equals("?")) {
            return;
        }
        if (cmdStrings.length < 3) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"debug command error."});
        }
        boolean isMatch = false;
        for (String str : cmdtoken) {
            if (!str.equals(this.getCmdParam())) continue;
            isMatch = true;
            break;
        }
        if (!isMatch) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"debug command does not match."});
        }
        String[] parameter = this.getParameter();
        if (parameter.length < 3) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"debug command parameter error. e.g.'genCommentSql -comment MySQL 1000 2000'"});
        }
        this.dbType = parameter[0];
        DBType currDBType = DB.getDBType((DBRoute)DBRoute.base);
        if (!this.dbType.equals(currDBType.name())) {
            throw new KDException(BosErrorCode.bOS, new Object[]{String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u7c7b\u578b%1$s\u4e0e\u6570\u636e\u5e93\u7c7b\u578b%2$s\u4e0d\u5339\u914d\u3002", (String)"GenCommentSqlCommand_7", (String)"bos-form-business", (Object[])new Object[0]), this.dbType, currDBType.name())});
        }
        this.start = Integer.parseInt(parameter[1]);
        this.end = Integer.parseInt(parameter[2]);
        if (parameter.length > 3 && StringUtils.isNotBlank((CharSequence)(formJson = parameter[3]))) {
            if (formJson.startsWith("[")) {
                List listApp = (List)SerializationUtils.fromJsonString((String)formJson, List.class);
                for (String appId : listApp) {
                    this.procAppFormMap.put(appId, null);
                }
            } else {
                this.procAppFormMap = (Map)SerializationUtils.fromJsonString((String)formJson, Map.class);
            }
        }
    }

    private String genSql() {
        Account account = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
        List dbs = account.getDBInstanceList();
        HashMap<String, String> dbRouteInstanceMap = new HashMap<String, String>(dbs.size());
        for (DBInstance dbInstance : dbs) {
            dbRouteInstanceMap.put(dbInstance.getRouteKey(), dbInstance.getDBInsatnce());
        }
        Map<String, List<CommentInfo>> dbTableMap = this.getCommentInfo(dbRouteInstanceMap);
        StringBuilder sql = new StringBuilder(20);
        for (Map.Entry<String, List<CommentInfo>> entry : dbTableMap.entrySet()) {
            StringBuilder outFileSql = new StringBuilder(20);
            String dbInstance = entry.getKey();
            List<CommentInfo> tableColumnCommentList = entry.getValue();
            outFileSql.append("---------------- ").append(dbInstance).append(" ----------------").append(System.lineSeparator());
            outFileSql.append("use ").append(dbInstance).append(";").append(System.lineSeparator());
            outFileSql.append(this.genDBInstanceColumnSql(dbInstance, tableColumnCommentList));
            this.exportFile(dbInstance, outFileSql.toString());
            sql.append((CharSequence)outFileSql);
        }
        return sql.toString();
    }

    private String genDBInstanceColumnSql(String dbInstance, List<CommentInfo> tableColumnCommentList) {
        StringBuilder outSql = new StringBuilder(20);
        outSql.append("-- DBKey = ").append(dbInstance).append(" table count:").append(tableColumnCommentList.size()).append(System.lineSeparator());
        if ("MySQL".equals(this.dbType)) {
            Object[] tables = new Object[tableColumnCommentList.size()];
            HashMap<String, String> columnCommentMap = new HashMap<String, String>();
            for (int i = 0; i < tableColumnCommentList.size(); ++i) {
                CommentInfo commentInfo = tableColumnCommentList.get(i);
                tables[i] = commentInfo.tableName;
                for (int j = 0; j < commentInfo.getFieldNames().size(); ++j) {
                    String key = String.format("%s.%s", tables[i], commentInfo.getFieldNames().get(j));
                    columnCommentMap.put(key.toLowerCase(), commentInfo.getFieldComments().get(j));
                }
            }
            Object[] params = new Object[]{dbInstance};
            SqlBuilder sql = new SqlBuilder();
            sql.append("/*dialect*/SELECT table_name, column_name, concat('alter table ', table_schema, '.', table_name, ' modify column ', column_name, ' ', column_type, ' ', if(is_nullable = 'YES', ' ', 'not null '), if(column_default IS NULL, '', ", new Object[0]);
            sql.append(" if(data_type IN ('char', 'varchar') OR data_type IN ('date', 'datetime', 'timestamp') AND column_default != 'CURRENT_TIMESTAMP', concat(' default ''', column_default,''''), concat(' default ', column_default))), ", new Object[0]);
            sql.append(" if(extra is null or extra='','',concat(' ',extra)), ' comment ''') s FROM information_schema.columns WHERE table_schema = ? and ", params).appendIn("table_name", tables);
            DB.query((DBRoute)DBRoute.base, (SqlBuilder)sql, rs -> {
                while (rs.next()) {
                    String key = String.format("%s.%s", rs.getString(1), rs.getString(2));
                    String comment = (String)columnCommentMap.get(key.toLowerCase());
                    if (!StringUtils.isNotBlank((CharSequence)comment)) continue;
                    outSql.append(rs.getString(3)).append(comment).append("';").append(System.lineSeparator());
                }
                return null;
            });
        } else if ("PostgreSQL".equals(this.dbType)) {
            for (CommentInfo commentInfo : tableColumnCommentList) {
                for (int j = 0; j < commentInfo.getFieldNames().size(); ++j) {
                    String columnName = commentInfo.getFieldNames().get(j);
                    String columnComment = commentInfo.getFieldComments().get(j);
                    outSql.append("COMMENT ON COLUMN ").append(commentInfo.tableName).append(".").append(columnName).append(" is '").append(columnComment).append("';").append(System.lineSeparator());
                }
            }
        }
        return outSql.toString();
    }

    private Map<String, List<CommentInfo>> getCommentInfo(Map<String, String> dbRouteInstanceMap) {
        ArrayList<String> appParams = new ArrayList<String>();
        ArrayList<String> formParams = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : this.procAppFormMap.entrySet()) {
            if (entry.getValue() == null && StringUtils.isNotBlank((CharSequence)entry.getKey())) {
                appParams.add(entry.getKey());
                continue;
            }
            if (entry.getValue() != null && entry.getValue() instanceof String) {
                formParams.add(entry.getValue().toString());
                continue;
            }
            if (entry.getValue() == null || !(entry.getValue() instanceof Collection)) continue;
            formParams.addAll((Collection)entry.getValue());
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select top ", new Object[0]).append(String.valueOf(this.end - this.start), new Object[0]).append(",", new Object[0]).append(String.valueOf(this.start), new Object[0]).append(" a.fnumber, a.fdata from t_meta_entity a ", new Object[0]);
        sql.append(" inner join t_meta_entitydesign b on a.fid = b.fid inner join t_meta_appruntime c on b.fbizappid = c.fid ", new Object[0]);
        sql.append(" where a.ftype = 11", new Object[0]);
        if (formParams.size() > 0) {
            sql.append(" and ", new Object[0]).appendIn("a.fnumber", formParams);
        }
        if (appParams.size() > 0) {
            sql.append(" and ", new Object[0]).appendIn("c.fappid", appParams);
        }
        sql.append(" order by c.fcloudid, b.fbizappid, b.fnumber", new Object[0]);
        HashMap dbRouteEntityMap = new HashMap(20);
        DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sql, rs -> {
            while (rs.next()) {
                try {
                    MainEntityType dt = (MainEntityType)EntityItemTypes.fromJsonString((String)rs.getString(2));
                    String dbInstance = (String)dbRouteInstanceMap.get(dt.getDBRouteKey());
                    if (StringUtils.isBlank((CharSequence)dbInstance)) {
                        log.error("GenCommentSqlCommand error -- dbInstance is null, dboute:" + dt.getDBRouteKey());
                    }
                    List list = dbRouteEntityMap.computeIfAbsent(dbInstance, k -> new ArrayList());
                    list.add(dt);
                }
                catch (Exception e) {
                    log.error("GenCommentSqlCommand error -- EntityItemTypes.fromJsonString error. formnumber:" + rs.getString(1), (Throwable)e);
                }
            }
            return null;
        });
        HashMap<String, List<CommentInfo>> dbTableMap = new HashMap<String, List<CommentInfo>>(20);
        for (Map.Entry entry : dbRouteEntityMap.entrySet()) {
            String routeKey = (String)entry.getKey();
            for (MainEntityType met : (List)entry.getValue()) {
                if (StringUtils.isBlank((CharSequence)met.getAlias())) continue;
                String dbInstance = routeKey;
                List commentTableList = dbTableMap.computeIfAbsent(dbInstance, k -> new ArrayList());
                Collection entityTypes = met.getAllEntities().values();
                for (EntityType entityType : entityTypes) {
                    if (StringUtils.isBlank((CharSequence)entityType.getAlias())) continue;
                    CommentInfo commentTable = new CommentInfo(entityType.getAlias(), entityType.getDisplayName().getLocaleValue());
                    HashMap<String, CommentInfo> extTable = new HashMap<String, CommentInfo>(2);
                    commentTableList.add(commentTable);
                    Collection allFields = entityType.getFields().values();
                    for (IDataEntityProperty field : allFields) {
                        String extTableGroup = field.getTableGroup();
                        if (StringUtils.isNotBlank((CharSequence)extTableGroup)) {
                            IDataEntityType dt = field.getParent();
                            if (dt == null || !StringUtils.isNotBlank((CharSequence)dt.getAlias())) continue;
                            String extTableName = String.format("%s_%s", dt.getAlias(), extTableGroup);
                            CommentInfo extCommentInfo = (CommentInfo)extTable.get(extTableGroup);
                            if (extCommentInfo == null) {
                                extCommentInfo = new CommentInfo(extTableName, entityType.getDisplayName().getLocaleValue());
                                commentTableList.add(extCommentInfo);
                                extTable.put(extTableGroup, extCommentInfo);
                            }
                            extCommentInfo.addField(field.getAlias(), field.getDisplayName().getLocaleValue());
                            continue;
                        }
                        if (!StringUtils.isNotBlank((CharSequence)field.getAlias()) || !StringUtils.isNotBlank((Object)field.getDisplayName()) || !StringUtils.isNotBlank((CharSequence)field.getDisplayName().getLocaleValue())) continue;
                        commentTable.addField(field.getAlias(), field.getDisplayName().getLocaleValue());
                    }
                }
            }
        }
        dbRouteEntityMap.clear();
        return dbTableMap;
    }

    private void exportFile(String fileNamePrefix, String content) {
        String fileName = String.format("%s_%s.sql", fileNamePrefix, new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        try (ByteArrayInputStream ins = new ByteArrayInputStream(content.getBytes());){
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)ins, 5000);
            this.addDownLoadUrls(url);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("GenCommentSqlCommand error:%s.", e.getMessage())});
        }
    }

    static class CommentInfo {
        String tableName;
        String tableComment;
        List<String> fieldNames = new ArrayList<String>(10);
        List<String> fieldComments = new ArrayList<String>(10);

        public String getTableName() {
            return this.tableName;
        }

        public String getTableComment() {
            return this.tableComment;
        }

        public List<String> getFieldNames() {
            return this.fieldNames;
        }

        public List<String> getFieldComments() {
            return this.fieldComments;
        }

        public void addField(String fieldName, String comment) {
            this.fieldNames.add(fieldName);
            this.fieldComments.add(comment);
        }

        CommentInfo(String tableName, String comment) {
            this.tableName = tableName;
            this.tableComment = comment;
        }
    }
}

