/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.debug.cmd;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.plugin.debug.cmd.DebugCommand;
import kd.bos.form.plugin.debug.cmd.DebugCommandContext;
import kd.bos.instance.Instance;
import kd.bos.lang.Lang;
import kd.bos.metadata.domainmodel.define.DomainModelTypeFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class GetCacheCommand
extends DebugCommand {
    private static String[] cmdtoken = new String[]{"m", "am", "ad", "d", "k", "t", "ld", "domain"};
    private static String[] metaTypeToken = new String[]{"formconfig", "rootcontrol", "dt", "operate", "entityrule"};
    private Map<String, String> metaTypeMap;
    private String cacheParameter;
    private String appId;
    private String metaType;
    private String metaNumber;
    private String cacheKey;
    private String tableName;
    private List<String> subParas = new ArrayList<String>();
    private String regionKey;
    private String key;

    public GetCacheCommand(DebugCommandContext ctx, String[] cmdStrings) {
        super(ctx);
        this.initCmd(cmdStrings);
    }

    @Override
    public String exec() {
        if ("?".equals(this.getCmdParam())) {
            ArrayList<String> list = new ArrayList<String>(16);
            list.add("getcache -m appid type number | -am appid | -d regionkey key | -ad appid cachekey | -k entitynumber");
            list.add(ResManager.loadKDString((String)"-m    \u53d6\u5143\u6570\u636e\u7f13\u5b58", (String)"GetCacheCommand_0", (String)"bos-form-business", (Object[])new Object[0]));
            list.add(ResManager.loadKDString((String)"-am   \u53d6\u5e94\u7528\u5143\u6570\u636e\u7f13\u5b58", (String)"GetCacheCommand_1", (String)"bos-form-business", (Object[])new Object[0]));
            list.add(ResManager.loadKDString((String)"-d    \u53d6\u6570\u636e\u7f13\u5b58", (String)"GetCacheCommand_2", (String)"bos-form-business", (Object[])new Object[0]));
            list.add(ResManager.loadKDString((String)"-ad   \u53d6\u5e94\u7528\u6570\u636e\u7f13\u5b58", (String)"GetCacheCommand_3", (String)"bos-form-business", (Object[])new Object[0]));
            list.add(ResManager.loadKDString((String)"-k    \u53d6\u5b9e\u4f53\u6570\u636e\u7f13\u5b58regionkey", (String)"GetCacheCommand_4", (String)"bos-form-business", (Object[])new Object[0]));
            list.add(ResManager.loadKDString((String)"type  \u5143\u6570\u636e\u7c7b\u578b\uff0c\u5305\u62ec\uff1aformconfig | rootcontrol | dt | operate | entityrule", (String)"GetCacheCommand_5", (String)"bos-form-business", (Object[])new Object[0]));
            list.add(ResManager.loadKDString((String)"key   \u7f13\u5b58key\uff0c\u901a\u5e38\u662f\u6570\u636e\u7684\u5185\u7801", (String)"GetCacheCommand_6", (String)"bos-form-business", (Object[])new Object[0]));
            list.add(ResManager.loadKDString((String)"regionkey  \u7f13\u5b58regionkey \u53ef\u4ee5\u4ece-k\u547d\u4ee4\u83b7\u5f97", (String)"GetCacheCommand_7", (String)"bos-form-business", (Object[])new Object[0]));
            list.add(ResManager.loadKDString((String)"cachekey   \u5e94\u7528\u7f13\u5b58\u5b58\u50a8\u7684key\uff0c\u901a\u5e38\u662f\u4f7f\u7528\u8005\u81ea\u5df1\u5b9a\u4e49", (String)"GetCacheCommand_8", (String)"bos-form-business", (Object[])new Object[0]));
            return SerializationUtils.toJsonString(list);
        }
        if (this.getCmdParam().equals(cmdtoken[0])) {
            return this.getMetaCache();
        }
        if (this.getCmdParam().equals(cmdtoken[1])) {
            return this.getAppMetaCache();
        }
        if (this.getCmdParam().equals(cmdtoken[2])) {
            return this.getAppDataCache();
        }
        if (this.getCmdParam().equals(cmdtoken[3])) {
            return this.getDataCache();
        }
        if (this.getCmdParam().equals(cmdtoken[4])) {
            return this.getCacheTypes();
        }
        if (this.getCmdParam().equals(cmdtoken[5])) {
            return this.getCacheTypes();
        }
        if (this.getCmdParam().equals(cmdtoken[6])) {
            return this.getLocalDataCache();
        }
        if (this.getCmdParam().equals(cmdtoken[7])) {
            return this.getDomainModelByRedisCache();
        }
        return "debug command does not match";
    }

    private String getMetaCache() {
        String method = this.metaTypeMap.get(this.metaType);
        if (StringUtils.isNotBlank((CharSequence)this.appId)) {
            String str = this.getMetaByLocalCache(this.appId, this.metaNumber, method);
            return String.format("getMetaByLocalCache: appName:%s, meta:%s", this.appId, str);
        }
        String str = this.getMetaByRedisCache(this.appId, this.metaNumber, method);
        return String.format("getMetaByRedisCache: appName:%s, meta:%s", this.appId, str);
    }

    private String getAppMetaCache() {
        AppInfo app = AppMetadataCache.getAppInfo((String)this.appId);
        return SerializationUtils.toJsonString((Object)app);
    }

    private String getAppDataCache() {
        return this.getAppCache(this.appId, this.cacheKey);
    }

    private String getCacheTypes() {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy());
        LinkedHashSet<Object> subTypes = new LinkedHashSet<Object>();
        if (this.cacheParameter.startsWith("$allbase")) {
            if (this.subParas.isEmpty()) {
                subTypes.add(" : " + String.format(ResManager.loadKDString((String)"%s\u65e0\u8bb0\u5f55\u3002", (String)"GetCacheCommand_10", (String)"bos-form-business", (Object[])new Object[0]), this.cacheParameter));
            } else {
                RequestContext context = RequestContext.get();
                for (String tab : this.subParas) {
                    Set set = cache.getAll(context.getAccountId() + "." + tab.toLowerCase()).keySet();
                    if (set.isEmpty()) continue;
                    LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                    map.put("count", set.size());
                    map.put(tab, set);
                    subTypes.add(map);
                }
            }
        } else {
            subTypes.addAll(cache.getAll(this.getRootType()).keySet());
            Map<String, String> varMap = this.getContext().getVarExprMap();
            int i = 0;
            for (Object e : subTypes) {
                varMap.put(this.cacheParameter + i, e.toString());
                ++i;
            }
        }
        return "::" + SerializationUtils.toJsonString(subTypes);
    }

    private String getDataCache() {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy());
        Map<String, String> varMap = this.getContext().getVarExprMap();
        if (this.key.startsWith(":all")) {
            return SerializationUtils.toJsonString((Object)cache.getAll(this.regionKey));
        }
        if (this.key.startsWith(":")) {
            this.key = varMap.get(this.key.substring(1)).trim();
        }
        if (this.regionKey.startsWith(":")) {
            this.regionKey = varMap.get(this.regionKey.substring(1)).trim();
        }
        return (String)cache.get(this.regionKey, this.key);
    }

    private String getLocalDataCache() {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(3600);
        info.setMaxMemSize(300);
        LocalMemoryCache rootCache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(RequestContext.get().getAccountId(), "bd", info);
        Map cacheData = (Map)rootCache.get(this.cacheKey);
        return SerializationUtils.toJsonString((Object)cacheData);
    }

    @Override
    protected void initCmd(String[] cmdStrings) {
        super.initCmd(cmdStrings);
        this.checkCmd(cmdStrings);
        this.metaTypeMap = new HashMap<String, String>();
        this.metaTypeMap.put("formconfig", "getFormConfig");
        this.metaTypeMap.put("rootcontrol", "getRootControl");
        this.metaTypeMap.put("dt", "getDataEntityType");
        this.metaTypeMap.put("operate", "getDataEntityOperate");
        this.metaTypeMap.put("entityrule", "getAllEntityRules");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkCmd(String[] cmdStrings) {
        if (cmdStrings.length < 2) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"debug command error."});
        }
        if (this.getCmdParam().equals("?")) {
            return;
        }
        this.cacheParameter = cmdStrings[2].trim();
        if (StringUtils.isBlank((CharSequence)this.cacheParameter)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"debug command error."});
        }
        String[] tmpStrs = this.cacheParameter.split(" ");
        ArrayList<String> strList = new ArrayList<String>();
        for (String str : tmpStrs) {
            if (!StringUtils.isNotBlank((CharSequence)str)) continue;
            strList.add(str);
        }
        if (this.getCmdParam().equals(cmdtoken[0])) {
            if (strList.size() == 2) {
                this.metaType = (String)strList.get(0);
                this.metaNumber = (String)strList.get(1);
            } else {
                if (strList.size() != 3) throw new KDException(BosErrorCode.bOS, new Object[]{"debug command error."});
                this.appId = (String)strList.get(0);
                this.metaType = (String)strList.get(1);
                this.metaNumber = (String)strList.get(2);
            }
            if (!this.checkMetaType()) {
                throw new KDException(BosErrorCode.bOS, new Object[]{"debug command error."});
            }
        } else if (this.getCmdParam().equals(cmdtoken[1])) {
            if (strList.size() != 1) throw new KDException(BosErrorCode.bOS, new Object[]{"debug command error."});
            this.appId = (String)strList.get(0);
        } else if (this.getCmdParam().equals(cmdtoken[2])) {
            if (strList.size() != 2) throw new KDException(BosErrorCode.bOS, new Object[]{"debug command error."});
            this.appId = (String)strList.get(0);
            this.cacheKey = (String)strList.get(1);
        } else if (this.getCmdParam().equals(cmdtoken[3])) {
            if (strList.size() == 1) {
                String[] cachetmpkeys = ((String)strList.get(0)).split(":");
                ArrayList<String> dataCacheParmList = new ArrayList<String>();
                for (String str : cachetmpkeys) {
                    if (StringUtils.isNotBlank((CharSequence)str) && str.startsWith("\"")) {
                        str = str.substring(1);
                    }
                    if (StringUtils.isNotBlank((CharSequence)str) && str.endsWith("\"")) {
                        str = str.substring(0, str.length() - 1);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)str)) continue;
                    dataCacheParmList.add(str);
                }
                if (dataCacheParmList.size() != 2) {
                    throw new KDException(BosErrorCode.bOS, new Object[]{"debug command error."});
                }
                this.regionKey = (String)dataCacheParmList.get(0);
                this.key = (String)dataCacheParmList.get(1);
            } else {
                if (strList.size() != 2) throw new KDException(BosErrorCode.bOS, new Object[]{"debug command error."});
                this.regionKey = (String)strList.get(0);
                this.key = (String)strList.get(1);
            }
        } else if (this.getCmdParam().equals(cmdtoken[4])) {
            if (strList.size() == 1) {
                String entityNumber = (String)strList.get(0);
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityNumber);
                if (dt != null) {
                    this.tableName = dt.getAlias();
                }
            } else {
                if (strList.size() != 2) throw new KDException(BosErrorCode.bOS, new Object[]{"debug command error."});
                String pa1 = (String)strList.get(0);
                if (!"$allbase".equals(pa1)) throw new KDException(BosErrorCode.bOS, new Object[]{"debug command error."});
                final ArrayList tabNameList = new ArrayList();
                DB.query((DBRoute)DBRoute.meta, (String)"select distinct ftablename from T_META_MAINENTITYINFO where fmodeltype = 'BaseFormModel'", (ResultSetHandler)new ResultSetHandler<String>(){

                    public String handle(ResultSet rs) throws Exception {
                        while (rs.next()) {
                            String name = rs.getString(1);
                            if (!StringUtils.isNotBlank((CharSequence)name)) continue;
                            tabNameList.add(name);
                        }
                        return null;
                    }
                });
                String pa2 = (String)strList.get(1);
                int page = StringUtils.isBlank((CharSequence)pa2) ? 1 : Integer.parseInt(pa2) - 1;
                int size = tabNameList.size();
                if (page < 0) {
                    page = 0;
                } else if (size > (page + 1) * 1000) {
                    size = (page + 1) * 1000;
                }
                for (int i = page * 1000; i < size; ++i) {
                    this.subParas.add((String)tabNameList.get(i));
                }
            }
        } else if (this.getCmdParam().equals(cmdtoken[5])) {
            if (strList.size() == 1) {
                if (!((String)strList.get(0)).contains(".")) {
                    this.tableName = (String)strList.get(0);
                }
            } else if (strList.size() != 2) {
                throw new KDException(BosErrorCode.bOS, new Object[]{"debug command error."});
            }
        } else if (this.getCmdParam().equals(cmdtoken[6])) {
            if (strList.size() != 1) throw new KDException(BosErrorCode.bOS, new Object[]{"debug command error."});
            this.cacheKey = (String)strList.get(0);
        } else if (this.getCmdParam().equals(cmdtoken[7])) {
            if (strList.size() != 1) throw new KDException(BosErrorCode.bOS, new Object[]{"debug command error."});
            this.metaType = (String)strList.get(0);
        }
        boolean isMatch = false;
        for (String str : cmdtoken) {
            if (!str.equals(this.getCmdParam())) continue;
            return;
        }
        if (isMatch) return;
        throw new KDException(BosErrorCode.bOS, new Object[]{"debug command does not match."});
    }

    private boolean checkMetaType() {
        boolean isMatch = false;
        for (String str : metaTypeToken) {
            if (!str.equals(this.metaType)) continue;
            isMatch = true;
            break;
        }
        if (!isMatch) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"debug command does not match."});
        }
        return isMatch;
    }

    private String getMetaByLocalCache(String appId, String number, String methodName) {
        String appName = Instance.getAppName();
        return (String)DispatchServiceHelper.invokeBOSService((String)appId, (String)"DebugMetadataService", (String)"getMetaByLocalCache", (Object[])new Object[]{methodName, new String[]{number}});
    }

    private String getMetaByRedisCache(String appId, String number, String methodName) {
        String appName = Instance.getAppName();
        return (String)DispatchServiceHelper.invokeBOSService((String)"bos", (String)"DebugMetadataService", (String)"getMetaByRedisCache", (Object[])new Object[]{methodName, new String[]{number}});
    }

    private String getAppCache(String appKey, String cacheparam) {
        return (String)AppCache.get((String)appKey).get(cacheparam, String.class);
    }

    private String getDomainModelByRedisCache() {
        String modelType = this.metaType;
        String locale = Lang.get().getLocale().toString();
        String domainCacheKey = DomainModelTypeFactory.getEntityRedisCacheKey((String)locale);
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("domainmodel", new DistributeCacheHAPolicy());
        return domainCacheKey + (String)cache.get(domainCacheKey, modelType);
    }

    private String getRootType() {
        RequestContext context = RequestContext.get();
        return context.getAccountId() + "." + this.tableName.toLowerCase();
    }
}

