/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.debug.cmd;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.debug.cmd.DebugCommand;
import kd.bos.form.plugin.debug.cmd.DebugCommandContext;
import kd.bos.form.plugin.debug.executor.ExprExecutor;
import kd.bos.form.plugin.debug.executor.MethodExpr;
import kd.bos.ksql.exception.ParserException;

class GetValueCommand
extends DebugCommand {
    private static String[] cmdtoken = new String[]{"d", "s"};
    private String parameter;

    public GetValueCommand(DebugCommandContext ctx, String[] cmdStrings) {
        super(ctx);
        this.initCmd(cmdStrings);
    }

    @Override
    public String exec() {
        if (this.getCmdParam().equals(cmdtoken[0])) {
            return this.executeDynamicMethod();
        }
        if (this.getCmdParam().equals(cmdtoken[1])) {
            return this.executeDynamicMethod();
        }
        return "debug command does not match";
    }

    @Override
    protected void initCmd(String[] cmdStrings) {
        super.initCmd(cmdStrings);
        this.checkCmd(cmdStrings);
        this.parameter = cmdStrings[2];
    }

    private String executeDynamicMethod() {
        IFormView obj = this.getContext().getFormView();
        if (obj == null) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"getFormView() is null."});
        }
        try {
            MethodExpr expr = MethodExpr.parseMethod(this.parameter);
            HashMap<String, MethodExpr> varExprMap = new HashMap<String, MethodExpr>(this.getContext().getVarExprMap().size());
            for (Map.Entry<String, String> entry : this.getContext().getVarExprMap().entrySet()) {
                MethodExpr exprtmp = MethodExpr.parseMethod(entry.getValue());
                varExprMap.put(entry.getKey(), exprtmp);
            }
            Object ret = ExprExecutor.execMethodExpr(expr, obj, varExprMap);
            if (ret == null) {
                return null;
            }
            return ret.toString();
        }
        catch (ParserException e) {
            this.getContext().setErrInfo(e.getMessage());
            return "";
        }
    }

    private String executeStaticMethod() {
        return "";
    }

    private void checkCmd(String[] cmdStrings) {
        if (cmdStrings.length < 3) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"debug command error."});
        }
        if (StringUtils.isBlank((CharSequence)cmdStrings[2])) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"debug command error."});
        }
        boolean isMatch = false;
        for (String str : cmdtoken) {
            if (!str.equals(this.getCmdParam())) continue;
            isMatch = true;
            break;
        }
        if (!isMatch) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"debug command does not match."});
        }
    }
}

