/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.debug.cmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityItemTypes;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.plugin.debug.cmd.DebugCommand;
import kd.bos.form.plugin.debug.cmd.DebugCommandContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.xdb.util.Pair;

public class MulLangSqlCommand
extends DebugCommand {
    private static String[] cmdtoken = new String[]{"mysql", "ksql"};
    private int start = 0;
    private int end = 0;
    private int dbStart = 0;
    private int dbEnd = 0;
    private int outzero = 1;
    private int min = 0;
    private static final Log log = LogFactory.getLog(MulLangSqlCommand.class);

    public MulLangSqlCommand(DebugCommandContext ctx, String[] cmdStrings) {
        super(ctx);
        this.initCmd(cmdStrings);
    }

    @Override
    public String exec() {
        return this.testGLangUpdateSql(this.getCmdParam());
    }

    @Override
    protected void initCmd(String[] cmdStrings) {
        super.initCmd(cmdStrings);
        this.checkCmd(cmdStrings);
    }

    private void checkCmd(String[] cmdStrings) {
        if (cmdStrings.length < 3) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"debug command error."});
        }
        if (this.getCmdParam().equals("?")) {
            return;
        }
        String[] parameter = this.getParameter();
        if (parameter.length < 2) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"debug command parameter error. e.g.'updateMulLangSql -mysql 1000 2000'"});
        }
        String par1 = parameter[0];
        String par2 = parameter[1];
        if (par1.startsWith("db:")) {
            this.dbStart = Integer.parseInt(par1.substring(3));
            this.dbEnd = par2.startsWith("db:") ? Integer.parseInt(par2.substring(3)) : Integer.parseInt(par2);
        } else {
            this.start = Integer.parseInt(parameter[0]);
            this.end = Integer.parseInt(parameter[1]);
        }
        if (parameter.length > 2) {
            this.outzero = Integer.parseInt(parameter[2]);
        }
        if (parameter.length > 3) {
            this.min = Integer.parseInt(parameter[3]);
        }
    }

    private String testGLangUpdateSql(String sqlDBType) {
        Map tableFieldMap;
        String[] parameter = this.getParameter();
        if (parameter == null || parameter.length == 0) {
            return "parameter is null";
        }
        String sql = "select a.fnumber, a.fdata from t_meta_entity a where a.ftype = 11 and exists (select 1 from t_meta_entitydesign where fmodeltype = 'BaseFormModel' and ftype <> '2') order by fnumber";
        HashMap dbRouteEntityMap = new HashMap(20);
        DB.query((DBRoute)DBRoute.meta, (String)sql, rs -> {
            int i = 0;
            while (rs.next() && (++i <= this.dbEnd || this.dbEnd == 0)) {
                if (this.dbEnd != 0 && i < this.dbStart) continue;
                try {
                    MainEntityType dt = (MainEntityType)EntityItemTypes.fromJsonString((String)rs.getString(2));
                    String dbRoute = dt.getDBRouteKey();
                    List list = dbRouteEntityMap.computeIfAbsent(dbRoute, k -> new ArrayList());
                    list.add(dt);
                }
                catch (Exception e) {
                    log.error("EntityItemTypes.fromJsonString error. formnumber:" + rs.getString(1), (Throwable)e);
                }
            }
            return null;
        });
        HashMap<String, Map> dbTableMap = new HashMap<String, Map>(20);
        for (Map.Entry entry : dbRouteEntityMap.entrySet()) {
            for (MainEntityType mainEntityType : (List)entry.getValue()) {
                if (!(mainEntityType instanceof BasedataEntityType)) continue;
                String routeKey = (String)entry.getKey();
                tableFieldMap = dbTableMap.computeIfAbsent(routeKey, k -> new HashMap());
                Collection allFields = mainEntityType.getAllFields().values();
                for (IDataEntityProperty iDataEntityProperty : allFields) {
                    boolean isGl;
                    if (!(iDataEntityProperty instanceof MuliLangTextProp) || !(isGl = ((MuliLangTextProp)iDataEntityProperty).isGL())) continue;
                    String tableName = iDataEntityProperty.getParent().getAlias();
                    ArrayList<MuliLangTextProp> fields = (ArrayList<MuliLangTextProp>)tableFieldMap.get(tableName);
                    if (fields == null) {
                        fields = new ArrayList<MuliLangTextProp>();
                        tableFieldMap.put(tableName, fields);
                    }
                    boolean isExist = false;
                    for (MuliLangTextProp mulProp : fields) {
                        if (!StringUtils.isBlank((CharSequence)mulProp.getAlias()) && !mulProp.getAlias().equals(iDataEntityProperty.getAlias())) continue;
                        isExist = true;
                    }
                    if (isExist) continue;
                    fields.add((MuliLangTextProp)iDataEntityProperty);
                }
            }
        }
        dbRouteEntityMap.clear();
        int i = 1;
        StringBuilder sb = new StringBuilder(100);
        for (Map.Entry entry : dbTableMap.entrySet()) {
            String dbkey = (String)entry.getKey();
            tableFieldMap = (Map)entry.getValue();
            if (i > this.start && this.end != 0) {
                sb.append("---- use DBKey = ").append(dbkey).append(" table count:").append(tableFieldMap.size());
                sb.append(System.lineSeparator());
            }
            ArrayList<Pair> updateSql = new ArrayList<Pair>();
            block5: for (Map.Entry entry2 : tableFieldMap.entrySet()) {
                String table = (String)entry2.getKey();
                if (StringUtils.isBlank((CharSequence)table)) continue;
                List fields = (List)entry2.getValue();
                for (MuliLangTextProp field : fields) {
                    if (StringUtils.isBlank((CharSequence)field.getAlias())) continue;
                    if (i > this.end && this.end != 0) continue block5;
                    if (this.end != 0 && i < this.start) continue;
                    String mainTableName = field.getParent().getAlias();
                    String mainPKName = field.getParent().getPrimaryKey().getAlias();
                    String mulTableName = ((DynamicObjectType)field.getParent()).getLocaleProperty().getDynamicCollectionItemPropertyType().getAlias();
                    Integer rowCount = this.getFieldIsNullRowCount(dbkey, table, field);
                    if (rowCount <= 0 && (rowCount != 0 || this.outzero != 1) || rowCount < this.min) continue;
                    if (i == this.start) {
                        sb.append("---- use DBKey = ").append(dbkey).append(" table count:").append(tableFieldMap.size());
                        sb.append(System.lineSeparator());
                    }
                    StringBuilder updateSqlStringBuilder = new StringBuilder(20);
                    updateSqlStringBuilder.append("update ").append(table).append(" A inner join ").append(mulTableName).append(" B on A.").append(mainPKName).append("=B.").append(mainPKName).append(" and B.FLOCALEID = 'zh_CN' set A.").append(field.getAlias()).append(" = B.").append(field.getAlias()).append(" where A.").append(field.getAlias()).append(" is null OR ").append("A.").append(field.getAlias()).append(" = ' ';");
                    updateSqlStringBuilder.append(" -- count:").append(rowCount);
                    updateSqlStringBuilder.append(System.lineSeparator());
                    updateSql.add(new Pair((Object)updateSqlStringBuilder, (Object)rowCount));
                    ++i;
                }
            }
            updateSql.sort((o1, o2) -> (Integer)o2.getValue() - (Integer)o1.getValue());
            for (Pair pair : updateSql) {
                sb.append((CharSequence)pair.getKey());
            }
            updateSql.clear();
        }
        String str = sb.toString();
        sb.setLength(0);
        return str;
    }

    private Integer getFieldIsNullRowCount(String dbkey, String table, MuliLangTextProp field) {
        StringBuilder countRowSql = new StringBuilder();
        countRowSql.append("select count(1) from ").append(table).append(" where ").append(field.getAlias()).append(" is null OR ").append(field.getAlias()).append(" = ' ';");
        Integer rowCount = -1;
        try {
            rowCount = (Integer)DB.query((DBRoute)DBRoute.of((String)dbkey), (String)countRowSql.toString(), rs -> {
                int count1 = 0;
                if (rs.next()) {
                    count1 = rs.getInt(1);
                }
                return count1;
            });
        }
        catch (Exception e) {
            log.error(String.format("dbkey:%s sql:%s", dbkey, countRowSql.toString()), (Throwable)e);
        }
        return rowCount;
    }
}

