/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.debug.cmd;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.plugin.debug.cmd.DebugCommand;
import kd.bos.form.plugin.debug.cmd.DebugCommandContext;
import kd.bos.metadata.BuildFormDesignMeta;
import kd.bos.metadata.dao.MetaRebuilder;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.util.ExceptionUtils;

public class RebuildCommand
extends DebugCommand {
    private static String[] cmdtoken = new String[]{"m", "a", "gm", "ga"};
    private List<String> parameter = new ArrayList<String>();

    public RebuildCommand(DebugCommandContext ctx, String[] cmdStrings) {
        super(ctx);
        this.initCmd(cmdStrings);
    }

    @Override
    public String exec() {
        if ("?".equals(this.getCmdParam())) {
            ArrayList<String> list = new ArrayList<String>(16);
            list.add("rebuildmeta -m $metanumber force | -a $appnumber | -gm $metanumber $appgroup force | -ga $appnumber $appgroup");
            list.add(ResManager.loadKDString((String)"-m    \u91cd\u5efa\u5143\u6570\u636e\u7f13\u5b58", (String)"RebuildCommand_0", (String)"bos-form-business", (Object[])new Object[0]));
            list.add(ResManager.loadKDString((String)"-a    \u91cd\u5efa\u5e94\u7528\u5143\u6570\u636e\u7f13\u5b58", (String)"RebuildCommand_1", (String)"bos-form-business", (Object[])new Object[0]));
            list.add(ResManager.loadKDString((String)"-gm   \u91cd\u5efa\u7070\u5ea6\u5143\u6570\u636e\u7f13\u5b58", (String)"RebuildCommand_2", (String)"bos-form-business", (Object[])new Object[0]));
            list.add(ResManager.loadKDString((String)"-ga   \u91cd\u5efa\u7070\u5ea6\u5e94\u7528\u6570\u636e\u7f13\u5b58", (String)"RebuildCommand_3", (String)"bos-form-business", (Object[])new Object[0]));
            list.add(ResManager.loadKDString((String)"force  \u8868\u793a\u5f3a\u5236\u6267\u884c\uff0c\u4e0d\u6307\u5b9a\u5219\u6bd4\u8f83\u7248\u672c\u6267\u884c", (String)"RebuildCommand_4", (String)"bos-form-business", (Object[])new Object[0]));
            list.add(ResManager.loadKDString((String)"$metanumber  \u5143\u6570\u636e\u7f16\u7801", (String)"RebuildCommand_5", (String)"bos-form-business", (Object[])new Object[0]));
            list.add(ResManager.loadKDString((String)"$appnumber   \u5e94\u7528\u5143\u6570\u636e\u7f16\u7801", (String)"RebuildCommand_6", (String)"bos-form-business", (Object[])new Object[0]));
            list.add(ResManager.loadKDString((String)"$appgroup    \u7070\u5ea6\u7248\u672c", (String)"RebuildCommand_7", (String)"bos-form-business", (Object[])new Object[0]));
            return SerializationUtils.toJsonString(list);
        }
        if (this.getCmdParam().equals(cmdtoken[0])) {
            return this.rebuildMeta();
        }
        if (this.getCmdParam().equals(cmdtoken[1])) {
            return this.rebuildAppMeta();
        }
        if (this.getCmdParam().equals(cmdtoken[2])) {
            return this.rebuilGraydMeta();
        }
        if (this.getCmdParam().equals(cmdtoken[3])) {
            return this.rebuildGrayAppMeta();
        }
        return "debug command does not match";
    }

    private String rebuildMeta() {
        String appGroup = "defaultGroup";
        boolean force = false;
        if (this.parameter.size() > 1 && this.parameter.get(1).equalsIgnoreCase("force")) {
            force = true;
        }
        return this.rebuildMeta(appGroup, force);
    }

    private String rebuilGraydMeta() {
        String appGroup = this.parameter.get(1);
        if (StringUtils.isBlank((CharSequence)appGroup)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"debug command error. appGroup is null"});
        }
        boolean force = false;
        if (this.parameter.size() > 2 && this.parameter.get(2).equalsIgnoreCase("force")) {
            force = true;
        }
        return this.rebuildMeta(appGroup, force);
    }

    private String rebuildAppMeta() {
        String appGroup = "defaultGroup";
        return this.rebuildAppMeta(appGroup);
    }

    private String rebuildGrayAppMeta() {
        String appGroup = this.parameter.get(1);
        if (StringUtils.isBlank((CharSequence)appGroup)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"debug command error. appGroup is null"});
        }
        return this.rebuildAppMeta(appGroup);
    }

    private String rebuildMeta(String appGroup, boolean force) {
        String metaNumber = this.parameter.get(0);
        MetaRebuilder mr = new MetaRebuilder(appGroup);
        StringBuilder resultStrBuilder = new StringBuilder(16);
        try {
            if ("all".equalsIgnoreCase(metaNumber)) {
                List metas = mr.getAllRebuildFormDesignMeta();
                ArrayList<String> numbers = new ArrayList<String>(10);
                for (BuildFormDesignMeta meta : metas) {
                    numbers.add(meta.getNumber());
                }
                Map runtimeVerMap = MetadataDao.getRuntimeMetaVersion(numbers);
                for (BuildFormDesignMeta meta : metas) {
                    if (meta.getDevType().compareTo("1") == 0 || meta.getDevType().compareTo("3") == 0) continue;
                    String runtimeVer = (String)runtimeVerMap.get(meta.getNumber());
                    if (force) {
                        mr.rebuildRuntimeMetaById(meta.getId());
                        resultStrBuilder.append(String.format("%s BUILD SUCCESSFUL!", meta.getNumber()));
                        resultStrBuilder.append(System.lineSeparator());
                        continue;
                    }
                    int ret = mr.rebuildMetaOfDiffVerById(meta.getId(), runtimeVer);
                    if (ret == 2) {
                        this.getContext().setErrInfo(String.format("%s BUILD WARNING!", metaNumber));
                        resultStrBuilder.append(String.format("%s is null : BUILD WARNING!!", meta.getNumber()));
                        resultStrBuilder.append(System.lineSeparator());
                        continue;
                    }
                    if (ret != 3) continue;
                    this.getContext().setErrInfo(String.format("%s BUILD SUCCESSFUL!", metaNumber));
                    resultStrBuilder.append(String.format("%s BUILD SUCCESSFUL(same version, not rebuilding)!", meta.getNumber()));
                    resultStrBuilder.append(System.lineSeparator());
                }
            } else {
                mr.rebuildRuntimeMetaByNumber(metaNumber);
                resultStrBuilder.append(String.format("%s BUILD SUCCESSFUL!", metaNumber));
            }
        }
        catch (Exception e) {
            this.getContext().setErrInfo(String.format("%s BUILD FAILED!", metaNumber));
            resultStrBuilder.append(String.format("%s BUILD FAILED!!!, error: %s\u3002", metaNumber, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        return resultStrBuilder.toString();
    }

    private String rebuildAppMeta(String appGroup) {
        String number = this.parameter.get(0);
        MetaRebuilder mr = new MetaRebuilder(appGroup);
        try {
            mr.rebuildRuntimeAppMetaByNumber(number);
        }
        catch (Exception e) {
            this.getContext().setErrInfo("BUILD FAILED\uff01");
            return ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
        }
        return String.format("%s BUILD SUCCESSFUL!", number);
    }

    @Override
    protected void initCmd(String[] cmdStrings) {
        super.initCmd(cmdStrings);
        this.checkCmd(cmdStrings);
    }

    private void checkCmd(String[] cmdStrings) {
        String[] tmpStrs;
        if (this.getCmdParam().equals("?")) {
            return;
        }
        if (cmdStrings.length < 3 || cmdStrings.length > 6) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"debug command error."});
        }
        if (cmdStrings.length > 4 && StringUtils.isBlank((CharSequence)cmdStrings[3]) && (this.getCmdParam().equals(cmdtoken[0]) || this.getCmdParam().equals(cmdtoken[1]))) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"debug command error."});
        }
        String parmstr = cmdStrings[2].trim();
        if (StringUtils.isBlank((CharSequence)parmstr)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"debug command error."});
        }
        for (String str : tmpStrs = parmstr.split(" ")) {
            if (!StringUtils.isNotBlank((CharSequence)str)) continue;
            this.parameter.add(str);
        }
        boolean isMatch = false;
        for (String str : cmdtoken) {
            if (!str.equals(this.getCmdParam())) continue;
            isMatch = true;
            break;
        }
        if (!isMatch) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"debug command does not match."});
        }
    }
}

