/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.debug.executor;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.plugin.debug.Impl.ManagePlugInDebug;
import kd.bos.form.plugin.debug.executor.ConstructorArrayExpr;
import kd.bos.form.plugin.debug.executor.DMethodParam;
import kd.bos.form.plugin.debug.executor.MethodExpr;

public class ExprExecutor {
    public static Object execMethodExpr(MethodExpr expr, Object obj) {
        return ExprExecutor.execMethodExpr(expr, obj, null);
    }

    public static Object execMethodExpr(MethodExpr expr, Object obj, Map<String, MethodExpr> varExprMap) {
        String retType = expr.returnType;
        if (StringUtils.isBlank((CharSequence)retType)) {
            retType = "kd.bos.mvc.form.FormView";
        }
        ManagePlugInDebug pd = null;
        if (expr.getInstance() != null) {
            String instName = expr.getInstance().instanceName;
            pd = ManagePlugInDebug.getType(instName);
        }
        if (pd == null) {
            pd = ManagePlugInDebug.getType(retType);
        }
        if (pd == null) {
            try {
                Class<?> c = ExprExecutor.getInnerClass(retType);
                if (expr instanceof ConstructorArrayExpr) {
                    List<Object> values = ((ConstructorArrayExpr)expr).getValues();
                    Object dynamicArray = Array.newInstance(c, values.size());
                    for (int i = 0; i < values.size(); ++i) {
                        Array.set(dynamicArray, i, values.get(i));
                    }
                    return dynamicArray;
                }
                if (!expr.params.isEmpty()) {
                    ArrayList<Object> paramList = new ArrayList<Object>();
                    ArrayList paramClassList = new ArrayList();
                    for (DMethodParam param : expr.params) {
                        if (param.expr != null) {
                            paramList.add(ExprExecutor.execMethodExpr(param.expr, obj));
                            paramClassList.add(ExprExecutor.getClass(param.expr.returnType));
                            continue;
                        }
                        if (!StringUtils.isNotBlank((Object)param.value)) continue;
                        Object varObj = ExprExecutor.execVarExpr(obj, varExprMap, param.value);
                        paramList.add(varObj);
                    }
                    Constructor<?> cor = c.getConstructor(paramClassList.toArray(new Class[0]));
                    return cor.newInstance(paramList);
                }
                Constructor<?> cor = c.getConstructor(c);
                return cor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new KDException(BosErrorCode.bOS, new Object[]{String.format("class:%s, Constructor() error:%s", retType, e.getMessage())});
            }
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (expr.params != null) {
            for (DMethodParam param : expr.params) {
                if (param.expr != null) {
                    paramList.add(ExprExecutor.execMethodExpr(param.expr, obj));
                    continue;
                }
                if (!StringUtils.isNotBlank((Object)param.value)) continue;
                Object varObj = ExprExecutor.execVarExpr(obj, varExprMap, param.value);
                param.classType = varObj.getClass();
                paramList.add(varObj);
            }
        }
        Object instance = obj;
        if (expr.instance != null && expr.instance.expr != null) {
            instance = ExprExecutor.execMethodExpr(expr.instance.expr, instance);
            for (Class<?> instanceType = instance.getClass(); instanceType != null && (pd = ManagePlugInDebug.getType(instanceType.getName())) == null; instanceType = instanceType.getSuperclass()) {
            }
            if (pd == null || instance == null) {
                throw new KDException(BosErrorCode.bOS, new Object[]{"instance is null."});
            }
        } else if (expr.instance != null) {
            if (StringUtils.isNotBlank((CharSequence)expr.instance.instanceName)) {
                pd = ManagePlugInDebug.getType(expr.instance.instanceName);
                instance = null;
            }
            if (StringUtils.isBlank((CharSequence)expr.instance.instanceName)) {
                throw new KDException(BosErrorCode.bOS, new Object[]{"expr.instance.instanceName is null."});
            }
        }
        AccessibleObject ao = pd.getAction(expr.methodName, expr.params);
        return ExprExecutor.invokeMethod(paramList, instance, ao);
    }

    private static Object execVarExpr(Object obj, Map<String, MethodExpr> varExprMap, Object value) {
        Object varObj;
        if (varExprMap == null || varExprMap.isEmpty()) {
            return value;
        }
        MethodExpr varExpr = varExprMap.get(value);
        if (varExpr != null) {
            if (varExpr.instance != null || !StringUtils.isBlank((CharSequence)varExpr.methodName) || varExpr.getParams().size() > 1) {
                // empty if block
            }
            varObj = varExpr.instance == null && StringUtils.isBlank((CharSequence)varExpr.methodName) && varExpr.getParams().size() == 1 ? varExpr.getParams().get(0).getValue() : ExprExecutor.execMethodExpr(varExpr, obj, varExprMap);
        } else {
            varObj = value;
        }
        return varObj;
    }

    private static Object invokeMethod(List<Object> paramList, Object instance, AccessibleObject ao) {
        Object obj = null;
        if (ao instanceof Method) {
            try {
                if (paramList.isEmpty()) {
                    obj = ((Method)ao).invoke(instance, new Object[0]);
                }
                Object[] pars = new Object[paramList.size()];
                for (int i = 0; i < paramList.size(); ++i) {
                    if (((Method)ao).getParameterTypes()[i] == Boolean.TYPE) {
                        pars[i] = Boolean.parseBoolean((String)paramList.get(i));
                        continue;
                    }
                    try {
                        pars[i] = ((Method)ao).getParameterTypes()[i].cast(paramList.get(i));
                        continue;
                    }
                    catch (ClassCastException e) {
                        throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format("method:%s,param:%s,err:%s", ((Method)ao).getName(), paramList.get(i), e.getMessage())});
                    }
                }
                obj = ((Method)ao).invoke(instance, pars);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format("method:%s, err:%s", ((Method)ao).getName(), e.getMessage())});
            }
        } else {
            try {
                ((Field)ao).setAccessible(true);
                obj = ((Field)ao).get(instance);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{e.getMessage()});
            }
        }
        return obj;
    }

    private static Class<?> getClass(String retType) {
        ManagePlugInDebug pd = ManagePlugInDebug.getType(retType);
        if (pd != null) {
            return pd.getClass();
        }
        return ExprExecutor.getInnerClass(retType);
    }

    private static Class<?> getInnerClass(String retType) {
        if (retType.contains(".")) {
            try {
                return Class.forName(retType);
            }
            catch (ClassNotFoundException e) {
                throw new KDException(BosErrorCode.bOS, new Object[]{String.format("class:%s, Constructor() error:%s", retType, e.getMessage())});
            }
        }
        if ("Object".equals(retType)) {
            return Object.class;
        }
        if ("String".equals(retType)) {
            return String.class;
        }
        if ("Long".equals(retType)) {
            return Long.class;
        }
        if ("long".equals(retType)) {
            return Long.TYPE;
        }
        throw new KDException(BosErrorCode.bOS, new Object[]{"NotImplement"});
    }
}

