/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.debug.executor;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.plugin.debug.executor.ConstructorArrayExpr;
import kd.bos.form.plugin.debug.executor.ConstructorExpr;
import kd.bos.form.plugin.debug.executor.DInstance;
import kd.bos.form.plugin.debug.executor.DMethodParam;
import kd.bos.form.plugin.debug.executor.Element;
import kd.bos.form.plugin.debug.executor.IdentifierElement;
import kd.bos.form.plugin.debug.executor.MethodElement;
import kd.bos.form.plugin.debug.executor.MethodParser;
import kd.bos.form.plugin.debug.executor.NewOperatorElement;
import kd.bos.ksql.exception.ParserException;

public class MethodExpr {
    String returnType;
    DInstance instance;
    String methodName;
    List<DMethodParam> params = new ArrayList<DMethodParam>();
    static String[] s = new String[]{"this.getModel()", "(FormDataModel)getModel()", "((FormDataModel)getModel()).getDataEntity(true)", "((DynamicObject)( ( (FormDataModel)getModel() ).getDataEntity(true))).getValue()"};

    public String getReturnType() {
        return this.returnType;
    }

    public DInstance getInstance() {
        return this.instance;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<DMethodParam> getParams() {
        return this.params;
    }

    public static MethodExpr parseMethod(String text) throws ParserException {
        MethodParser methodParser = new MethodParser(text);
        MethodElement element = methodParser.parserMethod();
        return MethodExpr.getMethod(element);
    }

    private static MethodExpr getMethod(MethodElement element) {
        MethodExpr me = new MethodExpr();
        for (int i = 0; i < element.subElement.size(); ++i) {
            element.subCursor = i;
            Element el = element.subElement.get(i);
            if (el instanceof IdentifierElement) {
                if (MethodExpr.isReturnType(el)) {
                    me.returnType = el.elementString;
                    continue;
                }
                if (MethodExpr.isInstance(el)) {
                    DInstance inst = new DInstance();
                    inst.instanceName = el.elementString;
                    while (i + 2 < element.subElement.size() && el instanceof IdentifierElement && element.subElement.get(i + 1) == MethodElement.PeriodElement) {
                        el = element.subElement.get(i + 2);
                        element.subCursor = i + 2;
                        if (MethodExpr.isInstance(el)) {
                            inst.instanceName = inst.instanceName + MethodElement.PeriodElement.elementString + el.elementString;
                            i += 2;
                            continue;
                        }
                        element.subCursor = i;
                        break;
                    }
                    me.instance = inst;
                    continue;
                }
                if (MethodExpr.isMethodName(el)) {
                    me.methodName = el.elementString;
                    continue;
                }
                if (MethodExpr.isPunctuation(el)) continue;
                DMethodParam param = new DMethodParam();
                if (i < element.subElement.size()) {
                    Element nextEl = element.subElement.get(i + 1);
                    if (nextEl instanceof MethodElement) {
                        MethodExpr expr = MethodExpr.getMethod((MethodElement)nextEl);
                        param.setExpr(expr);
                        me.params.add(param);
                    } else {
                        param.value = el.elementString;
                    }
                } else {
                    param.value = el.elementString;
                }
                me.params.add(param);
                continue;
            }
            if (el == MethodElement.PeriodElement) {
                if (el != MethodElement.PeriodElement || i <= 1) continue;
                Element prev = element.subElement.get(i - 1);
                Element prev2 = element.subElement.get(i - 2);
                if (!(prev instanceof MethodElement) || !(prev2 instanceof IdentifierElement)) continue;
                MethodExpr subExpr = new MethodExpr();
                subExpr.returnType = me.returnType;
                subExpr.instance = me.instance;
                subExpr.methodName = me.methodName;
                subExpr.params = me.params;
                me = new MethodExpr();
                DInstance inst = new DInstance();
                inst.expr = subExpr;
                me.instance = inst;
                continue;
            }
            if (el instanceof NewOperatorElement) {
                Element valElement;
                ConstructorExpr expr;
                NewOperatorElement operatorEl = (NewOperatorElement)el;
                if (MethodExpr.isEmptyArgument(operatorEl.subElement)) {
                    me.params = null;
                }
                if (operatorEl.isArray) {
                    expr = new ConstructorArrayExpr();
                    ((ConstructorArrayExpr)expr).returnType = operatorEl.elementString;
                    ((ConstructorArrayExpr)expr).instance = new DInstance();
                    if (operatorEl.subElement.size() > 1) {
                        for (int j = 1; j < operatorEl.subElement.size(); ++j) {
                            valElement = (Element)operatorEl.subElement.get(j);
                            if (!(valElement instanceof IdentifierElement)) continue;
                            int length = valElement.elementString.length();
                            if (valElement.elementString.startsWith("\"")) {
                                String val = valElement.elementString.substring(1, length - 1);
                                ((ConstructorArrayExpr)expr).addValue(val);
                                continue;
                            }
                            if (valElement.elementString.endsWith("L")) {
                                ((ConstructorArrayExpr)expr).addValue(Long.parseLong(valElement.elementString.substring(0, length - 1)));
                                continue;
                            }
                            if (MethodExpr.isInteger(valElement.elementString)) {
                                ((ConstructorArrayExpr)expr).addValue(Integer.parseInt(valElement.elementString));
                                continue;
                            }
                            ((ConstructorArrayExpr)expr).addValue(valElement.elementString);
                        }
                    } else {
                        Element valElement2 = (Element)operatorEl.subElement.get(1);
                        if (valElement2 instanceof MethodElement) {
                            MethodExpr sizeExpr = MethodExpr.getMethod((MethodElement)valElement2);
                            ((ConstructorArrayExpr)expr).setSize(sizeExpr);
                        } else {
                            throw new KDException(BosErrorCode.bOS, new Object[]{"NotImplement"});
                        }
                    }
                    me = expr;
                    continue;
                }
                expr = new ConstructorExpr();
                expr.returnType = operatorEl.elementString;
                expr.instance = new DInstance();
                for (int j = 1; j < operatorEl.subElement.size() - 1; ++j) {
                    valElement = (Element)operatorEl.subElement.get(j);
                    if (valElement instanceof MethodElement) {
                        MethodExpr paramExpr = MethodExpr.getMethod((MethodElement)valElement);
                        DMethodParam param = new DMethodParam();
                        me.params.addAll(paramExpr.params);
                        continue;
                    }
                    DMethodParam param = new DMethodParam();
                    param.value = el.elementString;
                    me.params.add(param);
                }
                me = expr;
                continue;
            }
            if (!(el instanceof MethodElement)) continue;
            if (MethodExpr.isEmptyArgument(((MethodElement)el).subElement)) {
                me.params = null;
                continue;
            }
            MethodExpr expr = MethodExpr.getMethod((MethodElement)el);
            if (StringUtils.isBlank((CharSequence)expr.methodName) && expr.instance == null && StringUtils.isNotBlank((CharSequence)expr.returnType)) {
                me.returnType = expr.returnType;
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)expr.methodName) || expr.instance != null || MethodExpr.isInstance(el)) {
                DInstance inst = new DInstance();
                inst.expr = expr;
                me.instance = inst;
                continue;
            }
            DMethodParam param = new DMethodParam();
            me.params.addAll(expr.params);
        }
        return me;
    }

    private static boolean isEmptyArgument(List<Element> list) {
        return list.size() == 2 && list.get(0) == MethodElement.openParenthesisElement && list.get(1) == MethodElement.closeParenthesisElement;
    }

    private static boolean isReturnType(Element el) {
        Element elPrev;
        if (el.parent == null) {
            return false;
        }
        MethodElement elParent = (MethodElement)el.parent;
        Element elNext = elParent.getSubNext();
        if (el instanceof MethodElement && MethodExpr.isIdentifierOrOpenParenthesis(elNext)) {
            return true;
        }
        int subcur = elParent.subCursor;
        Element elNext2 = null;
        if (subcur < elParent.subElement.size() - 2) {
            elNext2 = elParent.subElement.get(subcur + 2);
        }
        if (MethodExpr.isEnclosedElement(elPrev = elParent.getSubPrev(), elNext) && MethodExpr.isIdentifierOrOpenParenthesis(elNext2)) {
            return true;
        }
        if (MethodExpr.isEnclosedElement(elPrev, elNext) && elNext2 == null && elParent.parent != null) {
            return MethodExpr.isNextIdentifierOrMethodElement((MethodElement)elParent.parent);
        }
        return false;
    }

    private static boolean isInstance(Element el) {
        if (el.parent == null) {
            return false;
        }
        MethodElement elParent = (MethodElement)el.parent;
        Element elNext = elParent.getSubNext();
        if (elNext == null) {
            return false;
        }
        return elNext == MethodElement.PeriodElement;
    }

    private static boolean isMethodName(Element el) {
        if (el.parent == null) {
            return false;
        }
        MethodElement elParent = (MethodElement)el.parent;
        Element elPrev = elParent.getSubPrev();
        if (elPrev != null && elPrev == MethodElement.PeriodElement) {
            return true;
        }
        Element elNext = elParent.getSubNext();
        return elNext != null && (elNext == MethodElement.openParenthesisElement || elNext instanceof MethodElement && ((MethodElement)elNext).subElement.get(0) == MethodElement.openParenthesisElement) && (elPrev == null || elPrev != null && (elPrev == MethodElement.closeParenthesisElement || elPrev instanceof MethodElement));
    }

    private static boolean isPunctuation(Element el) {
        return el == MethodElement.openParenthesisElement || el == MethodElement.closeParenthesisElement || el == MethodElement.PeriodElement;
    }

    private static boolean isEnclosedElement(Element elPrev, Element elNext) {
        return elPrev != null && elPrev == MethodElement.openParenthesisElement && elNext != null && elNext == MethodElement.closeParenthesisElement;
    }

    private static boolean isNextIdentifierOrMethodElement(Element el) {
        if (el == null) {
            return false;
        }
        Element elNext = ((MethodElement)el).getSubNext();
        if (elNext == null) {
            return false;
        }
        if (elNext instanceof IdentifierElement || elNext instanceof MethodElement) {
            return true;
        }
        if (elNext == MethodElement.closeParenthesisElement) {
            return MethodExpr.isNextIdentifierOrMethodElement(el.parent);
        }
        return false;
    }

    private static boolean isIdentifierOrOpenParenthesis(Element elNext) {
        return elNext != null && (elNext instanceof IdentifierElement || elNext == MethodElement.openParenthesisElement);
    }

    public static void main(String[] args) {
        for (String string : s) {
            MethodExpr expr = new MethodExpr();
            try {
                MethodExpr.parseMethod(string);
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }
}

