/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.debug.executor;

import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.plugin.debug.executor.MethodToken;
import kd.bos.ksql.exception.ParserException;
import kd.bos.ksql.parser.StringReader;

public class MethodLexer {
    int _ptr;
    StringReader _sr;

    MethodLexer(String text) {
        this._sr = new StringReader(text);
    }

    public MethodToken next() throws ParserException {
        while (!this._sr.eos()) {
            char c = this._sr.next();
            if (c == '(') {
                return MethodToken.OpenParenthesisToken;
            }
            if (c == ')') {
                return MethodToken.CloseParenthesisToken;
            }
            if (c == '[') {
                return MethodToken.OpenBracketToken;
            }
            if (c == ']') {
                return MethodToken.CloseBracketToken;
            }
            if (c == '\"') {
                return new MethodToken(this.readString(), 1);
            }
            if (Character.isLetterOrDigit(c)) {
                String text = this.readIdent(c);
                if ("new".equals(text)) {
                    return this.readNewOperatorToken(text);
                }
                return new MethodToken(text, 1);
            }
            if (c != '.') continue;
            return MethodToken.PeriodToken;
        }
        return null;
    }

    private MethodToken readNewOperatorToken(String text) {
        return new MethodToken(text, 4);
    }

    public char lookup(int i) {
        try {
            return this._sr.lookup(i);
        }
        catch (ParserException e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{"lookup error"});
        }
    }

    public void unget(int i) {
        for (int j = 0; j < i; ++j) {
            try {
                this._sr.unget();
                continue;
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
        }
    }

    private final String readIdent(char c) throws ParserException {
        StringBuilder s = new StringBuilder(16);
        s.append(c);
        while (!this._sr.eos()) {
            c = this._sr.next();
            if (!Character.isLetterOrDigit(c)) {
                this._sr.unget();
                break;
            }
            s.append(c);
        }
        return s.toString();
    }

    private final String readString() throws ParserException {
        int ch = 0;
        StringBuilder text = new StringBuilder(16);
        text.append('\"');
        while (!this._sr.eos()) {
            char c = this._sr.next();
            ch = c;
            if (c == '\"') {
                if (this._sr.eos()) {
                    text.append('\"');
                    return text.toString();
                }
                if (this._sr.next() == '\"') {
                    text.append('\"');
                    continue;
                }
                this._sr.unget();
                ch = 34;
                text.append('\"');
                break;
            }
            text.append((char)ch);
        }
        if (ch != 34) {
            String message = "End of File before String terminated at \"";
            throw new KDException(BosErrorCode.bOS, new Object[]{message});
        }
        return text.toString();
    }
}

