/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.layoutscheme;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityObjectReader;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class LayoutAllotSchemePlugin
extends StandardTreeListPlugin
implements ItemClickListener {
    public static final String TBLNEW = "tblnew";
    private static final String PREFIX_APP = "app_";
    private static final String PREFIX_CLOUD = "cloud_";
    private static final String KEY_BILLFORMID = "layoutschemeid";
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DELETE = "btndel";

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_NEW, BTN_EDIT, BTN_DELETE});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("tblrefresh".equals(evt.getItemKey())) {
            ((ListView)this.getView()).refresh();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (TBLNEW.equals(evt.getActionId())) {
            ((ListView)this.getView()).refresh();
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if ("layoutschemeid_name".equals(args.getHyperLinkClickEvent().getFieldName())) {
            ListSelectedRow row = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow();
            Object pkValue = row.getPrimaryKeyValue();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"bos_assignscheme", (String)"id, layoutschemeid, orgid, billtypeid");
            DynamicObject layoutschemeid = dynamicObject.getDynamicObject(KEY_BILLFORMID);
            DynamicObject org = dynamicObject.getDynamicObject("orgid");
            DynamicObject billtype = dynamicObject.getDynamicObject("billtypeid");
            if (layoutschemeid != null) {
                args.setCancel(true);
                BaseShowParameter showParameter = new BaseShowParameter();
                showParameter.setFormId("bos_newpageconfig");
                showParameter.setPkId(layoutschemeid.getPkValue());
                showParameter.setCustomParam("orgid", (Object)org);
                showParameter.setCustomParam("billtypeid", (Object)billtype);
                showParameter.setCustomParam("closeItem", (Object)true);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (showParameter.getCustomParam("rowPkId") != null) {
            Object rowPkId = showParameter.getCustomParam("rowPkId");
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.getFilterParameter().getQFilters().add(new QFilter(KEY_BILLFORMID, "=", rowPkId));
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter param = e.getParameter();
        String currentNodeId = this.getTreeModel().getCurrentNodeId().toString();
        String rootId = this.getTreeModel().getRoot().getId();
        if (currentNodeId.contains(PREFIX_CLOUD) || currentNodeId.contains(PREFIX_APP) || rootId.equals(currentNodeId)) {
            return;
        }
        param.setCustomParam("tree_parent_id", null);
        param.setCustomParam(KEY_BILLFORMID, (Object)currentNodeId);
    }

    public void initializeTree(EventObject e) {
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"LayoutAllotSchemePlugin_0", (String)"bos-form-business", (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        root.addChildren(this.getCloudNodes());
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
    }

    private List<TreeNode> getCloudNodes() {
        TreeNode root = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree(null, null, null, (String)"app");
        List clouds = null;
        if (root != null) {
            clouds = root.getChildren();
        }
        if (clouds == null) {
            return new ArrayList<TreeNode>(0);
        }
        Iterator cloudIterator = clouds.iterator();
        while (cloudIterator.hasNext()) {
            TreeNode cloud = (TreeNode)cloudIterator.next();
            String cloudNodeId = PREFIX_CLOUD + cloud.getId();
            cloud.setId(cloudNodeId);
            cloud.setData((Object)"cloud");
            List apps = cloud.getChildren();
            if (apps == null) {
                cloudIterator.remove();
                continue;
            }
            for (TreeNode app : apps) {
                String appNodeId = PREFIX_APP + app.getId();
                app.setId(appNodeId);
                app.setParentid(cloudNodeId);
                app.setData((Object)"app");
                app.setChildren(new ArrayList(0));
            }
        }
        return clouds;
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent evt) {
        super.buildTreeListFilter(evt);
        String nodeId = String.valueOf(evt.getNodeId());
        QFilter qfilter = null;
        String ids = this.getPageCache().get("idfilter");
        if (nodeId.contains(PREFIX_CLOUD)) {
            String[] realNodeId = nodeId.split("_");
            qfilter = new QFilter("cloudid", "=", (Object)realNodeId[1]);
            evt.addQFilter(qfilter);
        } else if (nodeId.contains(PREFIX_APP)) {
            String[] realNodeId = nodeId.split("_");
            qfilter = new QFilter("appid", "=", (Object)realNodeId[1]);
            evt.addQFilter(qfilter);
        }
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            evt.addQFilter(new QFilter("id", "in", (Object)SerializationUtils.fromJsonStringToList((String)ids, String.class)));
            this.getPageCache().remove("idfilter");
        }
        evt.setCancel(true);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        super.treeNodeClick(e);
        String nodeId = (String)e.getNodeId();
        String appId = (String)e.getParentNodeId();
        if (appId.contains(PREFIX_APP)) {
            Map assignscheme = BusinessDataServiceHelper.loadFromCache((String)"bos_assignscheme", (QFilter[])new QFilter[0]);
            ArrayList<Object> list = new ArrayList<Object>();
            for (DynamicObject dyn : assignscheme.values()) {
                String number;
                if (dyn.getDynamicObject(KEY_BILLFORMID) == null || !nodeId.equals(number = (String)dyn.getDynamicObject(KEY_BILLFORMID).getDynamicObject("formnumber").get("number"))) continue;
                list.add(dyn.getPkValue());
            }
            this.getPageCache().put("idfilter", SerializationUtils.toJsonString(list));
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        List<TreeNode> childNodes = this.getChildNodes(nodeId);
        e.setChildNodes(childNodes);
    }

    private List<TreeNode> getChildNodes(String parentId) {
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode parent = root.getTreeNode(parentId, 20);
        if (parent == null) {
            return new ArrayList<TreeNode>();
        }
        if (!parentId.startsWith(PREFIX_APP)) {
            return parent.getChildren();
        }
        if (parent.getChildren() != null && parent.getChildren().isEmpty()) {
            List<TreeNode> billNodes = this.buildBillNodesInApp(parentId.substring(PREFIX_APP.length()));
            return billNodes != null && !billNodes.isEmpty() ? billNodes : null;
        }
        return parent.getChildren();
    }

    private List<TreeNode> buildBillNodesInApp(String appId) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            return new ArrayList<TreeNode>(0);
        }
        QFilter[] filters = new QFilter[]{new QFilter("modeltype", "=", (Object)"BillFormModel"), new QFilter("billtype", "=", (Object)Boolean.TRUE)};
        List billNodes = EntityObjectReader.buildBillNodesInApp((String)appId, (QFilter[])filters);
        if (billNodes != null && !billNodes.isEmpty()) {
            for (TreeNode bill : billNodes) {
                String parentId = PREFIX_APP + appId;
                bill.setParentid(parentId);
            }
        }
        return billNodes;
    }
}

