/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.layoutscheme;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityObjectReader;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.formop.Refresh;
import kd.bos.form.plugin.layoutscheme.scheme.LayoutSchemeEditPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.AdminAppResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.smc.ManageServiceHelper;
import kd.bos.util.CollectionUtils;

public class OrgConfigTreePlugin
extends StandardTreeListPlugin
implements ItemClickListener {
    private static Log log = LogFactory.getLog(OrgConfigTreePlugin.class);
    public static final String BILLLISTAP = "billlistap";
    public static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final String PREFIX_APP = "app_";
    private static final String PREFIX_CLOUD = "cloud_";
    private static final String KEY_BILLFORMID = "formnumber";
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DELETE = "btndel";
    private static final String BTN_LISTALLOT = "allocation";
    private static final String BTN_ALLOTQUERY = "allotquery";
    private static final String APP_ID = "formnumber.bizappid.id";

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_NEW, BTN_EDIT, BTN_DELETE});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (BTN_ALLOTQUERY.equals(itemKey)) {
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            int[] rows = billList.getEntryState().getSelectedRows();
            if (rows.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"OrgConfigTreePlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            } else if (rows.length == 1) {
                ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"bos_assignscheme", (boolean)true, (int)0, (boolean)true);
                showParameter.setCustomParam("rowPkId", billList.getFocusRowPkId());
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        int n;
        DynamicObject[] dynamicObjectArray;
        String cloudId;
        String appId;
        String mainOrg;
        String formId;
        String enable;
        Object rowPkId;
        String opk = evt.getOperateKey();
        if (BTN_LISTALLOT.equals(opk)) {
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            int[] rows = billList.getEntryState().getSelectedRows();
            if (rows.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"OrgConfigTreePlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                return;
            }
            rowPkId = billList.getFocusRowPkId();
            DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)rowPkId, (String)"bos_newpageconfig");
            enable = obj.getString("enable");
            DynamicObject formNumber = obj.getDynamicObject(KEY_BILLFORMID);
            formId = (String)formNumber.getPkValue();
            LayoutSchemeEditPlugin pageScheme = new LayoutSchemeEditPlugin();
            mainOrg = pageScheme.getOrgFuncId(formId);
            DynamicObject[] appDynamic = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"bizappid", (QFilter[])new QFilter[0]);
            appId = null;
            cloudId = null;
            dynamicObjectArray = appDynamic;
            n = dynamicObjectArray.length;
        } else {
            if ("delete".equals(opk) && evt.getOperationResult().isSuccess()) {
                List successPkIds = evt.getOperationResult().getSuccessPkIds();
                if (!successPkIds.isEmpty()) return;
                return;
            }
            if ("refresh".equals(opk)) {
                ((ListView)this.getView()).refresh();
                return;
            }
            if (!"disable".equals(opk)) {
                if (!"enable".equals(opk)) return;
            }
            LayoutSchemeEditPlugin.removeCache();
            return;
        }
        for (int i = 0; i < n; ++i) {
            DynamicObject d = dynamicObjectArray[i];
            if (!String.valueOf(d.get(0)).equals(formId)) continue;
            DynamicObject app = (DynamicObject)d.get("bizappid");
            appId = (String)app.get(0);
            break;
        }
        DynamicObject[] cloudDynamic = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"bizcloud", (QFilter[])new QFilter[]{new QFilter("id", "=", appId)});
        DynamicObject cloudIds = (DynamicObject)cloudDynamic[0].get(2);
        cloudId = (String)cloudIds.get(0);
        if ("1".equals(enable)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("bos_selallocationty");
            formShowParameter.setCustomParam("mainOrg", (Object)mainOrg);
            formShowParameter.setCustomParam("appId", (Object)appId);
            formShowParameter.setCustomParam("formId", (Object)formId);
            formShowParameter.setCustomParam("cloudId", (Object)cloudId);
            formShowParameter.setCustomParam("schemeName", rowPkId);
            this.getView().showForm(formShowParameter);
            return;
        }
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u754c\u9762\u65b9\u6848\u88ab\u7981\u7528\uff0c\u8bf7\u542f\u7528\u4e4b\u540e\u518d\u8fdb\u884c\u5206\u914d\u3002", (String)"OrgConfigTreePlugin_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
    }

    public void initializeTree(EventObject e) {
        this.initTree();
    }

    public void refreshNode(RefreshNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        List<TreeNode> childNodes = this.getChildNodes(nodeId);
        e.setChildNodes(childNodes);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String nodeId = e.getNodeId().toString();
        QFilter[] billFilters = new QFilter[]{new QFilter("modeltype", "in", (Object)new String[]{"BillFormModel", "BaseFormModel"})};
        Object[] billFormIds = null;
        if (!this.isTopNodeId(nodeId)) {
            if (nodeId.contains(PREFIX_CLOUD)) {
                String cloudId = StringUtils.substringAfter((String)nodeId, (String)"_");
                billFormIds = EntityObjectReader.loadEntityNumbersInCloud((String)cloudId, (QFilter[])billFilters);
            } else if (nodeId.contains(PREFIX_APP)) {
                String appId = StringUtils.substringAfter((String)nodeId, (String)"_");
                billFormIds = EntityObjectReader.loadEntityNumbersInApp((String)appId, (QFilter[])billFilters);
            } else {
                billFormIds = new Object[]{nodeId};
            }
        }
        if (billFormIds != null) {
            QFilter filter = null;
            filter = billFormIds.length == 1 ? new QFilter(KEY_BILLFORMID, "=", billFormIds[0]) : new QFilter(KEY_BILLFORMID, "in", (Object)billFormIds);
            e.addQFilter(filter);
        }
        e.setCancel(true);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        if (evt.getSource() instanceof Refresh && StringUtils.equals((CharSequence)"refresh", (CharSequence)((Refresh)((Object)evt.getSource())).getOperateKey())) {
            String focusId = this.getTreeListView().getTreeView().getTreeState().getFocusNodeId();
            this.getTreeModel().refreshNode((Object)"-1");
            TreeNode root = this.getTreeModel().getRoot();
            this.getTreeListView().getTreeView().deleteAllNodes();
            this.getTreeListView().getTreeView().addNode(root);
            TreeNode focusNode = root.getTreeNode(focusId, 20);
            if (focusNode == null) {
                focusNode = root;
            }
            focusNode.setExpend(true);
            this.getTreeListView().getTreeView().focusNode(focusNode);
            this.getTreeListView().refreshTreeNode(focusNode.getId(), true);
            evt.setCancel(true);
        }
    }

    public void setFilter(SetFilterEvent e) {
        AdminAppResult adminAppResult = PermissionServiceHelper.getAdminApps((Long)RequestContext.get().getCurrUserId(), (boolean)true);
        if (adminAppResult.needAdminAppRange()) {
            List adminAppIds = adminAppResult.getAppIds();
            if (!CollectionUtils.isEmpty((Collection)adminAppIds)) {
                Set<String> extendAppIds = this.getExtendAppIds();
                if (!extendAppIds.isEmpty()) {
                    adminAppIds.removeAll(extendAppIds);
                }
                QFilter adminAppFilter = new QFilter(APP_ID, "in", (Object)adminAppIds);
                e.addCustomQFilter(adminAppFilter);
            } else {
                QFilter adminFilter = new QFilter(APP_ID, "in", Collections.emptyList());
                e.addCustomQFilter(adminFilter);
            }
        } else {
            Set<String> disableObjIds = this.getDisabledAppIds();
            QFilter filter = new QFilter(APP_ID, "not in", disableObjIds);
            e.addCustomQFilter(filter);
        }
    }

    private Set<String> getExtendAppIds() {
        Set disabledAppIds = ManageServiceHelper.getDisabledAppIds();
        return this.getExtendAppIds(disabledAppIds);
    }

    private Set<String> getDisabledAppIds() {
        Set disabledAppIds = ManageServiceHelper.getDisabledAppIds();
        Set<String> extendAppIds = this.getExtendAppIds(disabledAppIds);
        disabledAppIds.addAll(extendAppIds);
        return disabledAppIds;
    }

    private Set<String> getExtendAppIds(Set<String> bizAppId) {
        String selectFields = "id";
        QFilter[] filters = new QFilter[]{new QFilter("masterid", "in", bizAppId)};
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)selectFields, (QFilter[])filters);
        HashSet<String> extendAppIds = new HashSet<String>();
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String id = dynamicObject.getString("id");
                if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                extendAppIds.add(id);
            }
        }
        return extendAppIds;
    }

    private void initTree() {
        TreeNode root = new TreeNode();
        root.setId("-1");
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"OrgConfigTreePlugin_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        root.addChildren(this.getCloudNodes());
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
    }

    private List<TreeNode> getCloudNodes() {
        TreeNode root = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree(null, null, null, (String)"app");
        List clouds = null;
        if (root != null) {
            clouds = root.getChildren();
        }
        if (clouds == null) {
            return new ArrayList<TreeNode>(0);
        }
        Set disabledCloudIds = ManageServiceHelper.getDisabledCloudIds();
        Set<String> disabledAppIds = this.getDisabledAppIds();
        AdminAppResult adminAppResult = PermissionServiceHelper.getAdminApps((Long)RequestContext.get().getCurrUserId(), (boolean)true);
        log.info("Cloud is diabled : {}, Appid is diabled : {}, needAdminAppRange : {}, rangeApp size : {}", new Object[]{disabledCloudIds, disabledAppIds, adminAppResult.needAdminAppRange(), adminAppResult.getAppIds() == null ? "null" : Integer.valueOf(adminAppResult.getAppIds().size())});
        Iterator cloudIterator = clouds.iterator();
        while (cloudIterator.hasNext()) {
            TreeNode cloud = (TreeNode)cloudIterator.next();
            String cloudId = cloud.getId();
            String cloudNodeId = PREFIX_CLOUD + cloudId;
            cloud.setId(cloudNodeId);
            cloud.setData((Object)"cloud");
            List apps = cloud.getChildren();
            if (apps == null || disabledCloudIds.contains(cloudId)) {
                cloudIterator.remove();
                continue;
            }
            Iterator appIterator = apps.iterator();
            while (appIterator.hasNext()) {
                boolean adminNotCharge;
                TreeNode app = (TreeNode)appIterator.next();
                String appId = app.getId();
                String appNodeId = PREFIX_APP + appId;
                app.setId(appNodeId);
                app.setParentid(cloudNodeId);
                app.setData((Object)"app");
                boolean bl = adminNotCharge = adminAppResult.needAdminAppRange() && (adminAppResult.getAppIds() == null || !adminAppResult.getAppIds().contains(appId));
                if (disabledAppIds.contains(appId) || adminNotCharge) {
                    appIterator.remove();
                    continue;
                }
                app.setChildren(new ArrayList(0));
            }
            if (!apps.isEmpty()) continue;
            cloudIterator.remove();
        }
        return clouds;
    }

    private List<TreeNode> getChildNodes(String parentId) {
        List<TreeNode> cloudNodes = null;
        if (this.getTreeModel().getRoot().getId().equals(parentId)) {
            cloudNodes = this.getCloudNodes();
        } else {
            if (parentId.startsWith(PREFIX_APP)) {
                List<TreeNode> billNodes = this.buildBillNodesInApp(parentId.substring(PREFIX_APP.length()));
                if (billNodes == null || billNodes.isEmpty()) {
                    return null;
                }
                return billNodes;
            }
            TreeNode node = this.getTreeModel().getRoot().getTreeNode(parentId, 20);
            if (node != null) {
                return node.getChildren();
            }
        }
        return cloudNodes;
    }

    private List<TreeNode> buildBillNodesInApp(String appId) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            return new ArrayList<TreeNode>(0);
        }
        QFilter[] filters = new QFilter[]{new QFilter("modeltype", "in", (Object)new String[]{"BillFormModel", "BaseFormModel"})};
        List billNodes = EntityObjectReader.buildBillNodesInApp((String)appId, (QFilter[])filters);
        if (billNodes == null || billNodes.isEmpty()) {
            return billNodes;
        }
        for (TreeNode bill : billNodes) {
            String parentId = PREFIX_APP + appId;
            bill.setParentid(parentId);
        }
        return billNodes;
    }

    private boolean isTopNodeId(String currNodeId) {
        return currNodeId.equals(this.getTreeModel().getRoot().getId());
    }
}

