/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.layoutscheme;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Button;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SelectAllotOrgPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ORG_NAME_FIELD = "orgnamefield";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final String BTN_OK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
        BasedataEdit basedataBillType = (BasedataEdit)this.getControl(ORG_NAME_FIELD);
        basedataBillType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button btn = (Button)evt.getSource();
        if (!BTN_OK.equals(btn.getKey())) {
            return;
        }
        IDataModel model = this.getModel();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object layoutSchemeId = showParameter.getCustomParam("schemeName");
        if (layoutSchemeId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5206\u914d\u7684\u754c\u9762\u65b9\u6848\u3002", (String)"SelectAllotOrgPlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection entryList = model.getEntryEntity("orgentryentity");
        ArrayList<Object> orgIds = new ArrayList<Object>();
        for (DynamicObject obj : entryList) {
            DynamicObject orgNameField = obj.getDynamicObject(ORG_NAME_FIELD);
            if (null == orgNameField) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u5206\u914d\u7ec4\u7ec7\u3002", (String)"SelectAllotOrgPlugin_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                return;
            }
            if (orgIds.contains(orgNameField.getPkValue())) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a\u201c%s\u201d\u91cd\u590d\u9009\u62e9\uff0c\u8bf7\u5220\u9664\u91cd\u590d\u6570\u636e\u3002", (String)"SelectAllotOrgPlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), orgNameField.getString(BOS_FORM_BUSINESS)));
                return;
            }
            orgIds.add(orgNameField.getPkValue());
        }
        if (orgIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u5206\u914d\u7ec4\u7ec7\u3002", (String)"SelectAllotOrgPlugin_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        boolean isRepetition = this.checkRepetition(showParameter, orgIds);
        if (!isRepetition) {
            this.save(showParameter, entryList, layoutSchemeId);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String mainOrgFunc = (String)formShowParameter.getCustomParam("mainOrgFunc");
        FormShowParameter showParameter = beforeF7SelectEvent.getFormShowParameter();
        if (mainOrgFunc != null) {
            showParameter.setCustomParam("islockfunc", (Object)true);
            showParameter.setCustomParam("orgFuncId", (Object)mainOrgFunc);
        } else {
            showParameter.setCustomParam("islockfunc", (Object)false);
        }
    }

    private boolean checkRepetition(FormShowParameter showParameter, List<Object> orgIds) {
        boolean isRepetition = false;
        Object billFormId = showParameter.getCustomParam("formId");
        DynamicObject[] usedOrgLayoutSchemes = BusinessDataServiceHelper.load((String)"bos_assignscheme", (String)"id,layoutschemeid.id,layoutschemeid.number,layoutschemeid.name,orgid.id,orgid.name", (QFilter[])new QFilter[]{new QFilter("layoutschemeid.formnumber", "=", billFormId), new QFilter("orgid.id", "in", orgIds), new QFilter("billtypeid", "=", (Object)0)});
        if (usedOrgLayoutSchemes.length > 0) {
            isRepetition = true;
            for (DynamicObject usedOrgLayoutScheme : usedOrgLayoutSchemes) {
                Object existOrgName = usedOrgLayoutScheme.get("orgid.name");
                Object usedLayoutSchemeNumber = usedOrgLayoutScheme.get("layoutschemeid.number");
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u754c\u9762\u65b9\u6848\u5206\u914d\u5931\u8d25\uff0c\r\n \u7ec4\u7ec7\u201c%1$s\u201d\u5df2\u7ecf\u5206\u914d\u7ed9\u754c\u9762\u65b9\u6848\u201c%2$s\u201d\u3002", (String)"SelectAllotOrgPlugin_8", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), existOrgName, usedLayoutSchemeNumber));
            }
        }
        return isRepetition;
    }

    private void save(FormShowParameter showParameter, DynamicObjectCollection entryList, Object layoutSchemeId) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"bos_assignscheme");
        Object type = showParameter.getCustomParam("radiogroupfield");
        String cloudId = (String)showParameter.getCustomParam("cloudId");
        String appId = (String)showParameter.getCustomParam("appId");
        ArrayList<DynamicObject> assignSchemes = new ArrayList<DynamicObject>(entryList.size());
        for (DynamicObject obj : entryList) {
            DynamicObject assignScheme = new DynamicObject((DynamicObjectType)mainEntityType);
            String includeSubOrg = obj.getBoolean("includesuborg") ? "1" : "0";
            assignScheme.set("layoutschemeid", layoutSchemeId);
            assignScheme.set("type", type);
            assignScheme.set("cloudid", (Object)cloudId);
            assignScheme.set("appid", (Object)appId);
            assignScheme.set("createtime", (Object)new Date());
            assignScheme.set("creator", (Object)RequestContext.get().getUserId());
            assignScheme.set("modifier", (Object)RequestContext.get().getUserId());
            assignScheme.set("includesuborg", (Object)includeSubOrg);
            DynamicObject orgNameField = obj.getDynamicObject(ORG_NAME_FIELD);
            assignScheme.set("orgid", orgNameField.getPkValue());
            assignSchemes.add(assignScheme);
        }
        SaveServiceHelper.save((DynamicObject[])assignSchemes.toArray(new DynamicObject[0]));
        this.getView().showConfirm(ResManager.loadKDString((String)"\u754c\u9762\u65b9\u6848\u5206\u914d\u6210\u529f\u3002", (String)"SelectAllotOrgPlugin_7", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), MessageBoxOptions.OK);
        this.getView().close();
    }
}

