/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.layoutscheme;

import java.util.Date;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Button;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SelectBillTypePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String BTN_OK = "btnok";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
        BasedataEdit basedataBillType = (BasedataEdit)this.getControl("billtype");
        basedataBillType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button btn = (Button)evt.getSource();
        if (!BTN_OK.equals(btn.getKey())) {
            return;
        }
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object layoutSchemeId = showParameter.getCustomParam("schemeName");
        if (layoutSchemeId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5206\u914d\u7684\u754c\u9762\u65b9\u6848\u3002", (String)"SelectBillTypePlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        DynamicObject billtype = (DynamicObject)this.getModel().getValue("billtype");
        if (billtype == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u5355\u636e\u7c7b\u578b\u3002", (String)"SelectBillTypePlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        boolean isRepetition = this.checkRepetition(showParameter, billtype);
        if (!isRepetition) {
            this.save(showParameter, layoutSchemeId, billtype);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String formId = (String)showParameter.getCustomParam("formId");
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        listShowParameter.getListFilterParameter().getQFilters().add(QFilter.like((String)"billformid", (String)formId));
    }

    private boolean checkRepetition(FormShowParameter showParameter, DynamicObject billtype) {
        boolean isRepetition = false;
        Object billFormId = showParameter.getCustomParam("formId");
        DynamicObject[] usedBillTypeLayoutSchemes = BusinessDataServiceHelper.load((String)"bos_assignscheme", (String)"id,layoutschemeid.id,layoutschemeid.number,layoutschemeid.name,billtypeid.id,billtypeid.name", (QFilter[])new QFilter[]{new QFilter("layoutschemeid.formnumber", "=", billFormId), new QFilter("orgid.id", "=", (Object)0), new QFilter("billtypeid", "=", billtype.getPkValue())});
        if (usedBillTypeLayoutSchemes.length > 0) {
            isRepetition = true;
            for (DynamicObject usedBillTypeLayoutScheme : usedBillTypeLayoutSchemes) {
                Object existBillTypeName = usedBillTypeLayoutScheme.get("billtypeid.name");
                Object usedLayoutSchemeNumber = usedBillTypeLayoutScheme.get("layoutschemeid.number");
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u754c\u9762\u65b9\u6848\u5206\u914d\u5931\u8d25\uff0c\r\n \u5355\u636e\u7c7b\u578b\u201d%1$s\u201d\u5df2\u7ecf\u5206\u914d\u7ed9\u754c\u9762\u65b9\u6848\u201c%2$s\u201d\u3002", (String)"SelectBillTypePlugin_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), existBillTypeName, usedLayoutSchemeNumber));
            }
        }
        return isRepetition;
    }

    private void save(FormShowParameter showParameter, Object layoutSchemeId, DynamicObject billtype) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"bos_assignscheme");
        Object type = showParameter.getCustomParam("radiogroupfield");
        String cloudId = (String)showParameter.getCustomParam("cloudId");
        String appId = (String)showParameter.getCustomParam("appId");
        DynamicObject assignScheme = new DynamicObject((DynamicObjectType)mainEntityType);
        assignScheme.set("layoutschemeid", layoutSchemeId);
        assignScheme.set("type", type);
        assignScheme.set("cloudid", (Object)cloudId);
        assignScheme.set("appid", (Object)appId);
        assignScheme.set("createtime", (Object)new Date());
        assignScheme.set("creator", (Object)RequestContext.get().getUserId());
        assignScheme.set("modifier", (Object)RequestContext.get().getUserId());
        assignScheme.set("includesuborg", (Object)"0");
        assignScheme.set("billtypeid", billtype.getPkValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{assignScheme});
        this.getView().showConfirm(ResManager.loadKDString((String)"\u754c\u9762\u65b9\u6848\u5206\u914d\u6210\u529f\u3002", (String)"SelectBillTypePlugin_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), MessageBoxOptions.OK);
        this.getView().close();
    }
}

