/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.layoutscheme.scheme;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.servicehelper.billtype.BillTypeServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class LayoutSchemeBasicInfoWidget {
    protected static final String FIELD_FORM_NUMBER = "formnumber";
    protected static final String FIELD_LAYOUT_NUMBER_D = "layoutnumber_d";
    private static final String FIELD_NUMBER = "number";
    private static final String FIELD_NAME = "name";
    private static final String LAYOUT_LIST_CACHE = "layout_list_cache";
    private static final String LAYOUT_NUMBER = "layoutnumber";
    private IFormView view;
    private IDataModel model;
    private IPageCache pageCache;

    protected LayoutSchemeBasicInfoWidget(IFormView view, IDataModel model) {
        this.view = view;
        this.model = model;
        this.pageCache = view.getPageCache();
    }

    protected void init() {
        this.setDefaultNumber();
        this.bindLayout();
    }

    protected void changeForm() {
        this.model.setValue(LAYOUT_NUMBER, (Object)"");
        this.model.setValue(FIELD_LAYOUT_NUMBER_D, (Object)"");
        this.pageCache.put(LAYOUT_LIST_CACHE, SerializationUtils.toJsonString(new ArrayList()));
        this.init();
    }

    private void bindLayout() {
        String formId = this.getFormId();
        ArrayList layouts = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            layouts = BillTypeServiceHelper.getBillLayoutByFormId((String)formId, (boolean)true);
        }
        layouts = null == layouts ? new ArrayList() : layouts;
        this.pageCache.put(LAYOUT_LIST_CACHE, SerializationUtils.toJsonString(layouts));
        List items = layouts.stream().map(layout -> {
            String id = (String)layout.get("id");
            ILocaleString name = (ILocaleString)layout.get(FIELD_NAME);
            return new ComboItem(new LocaleString(name.getLocaleValue()), id);
        }).collect(Collectors.toList());
        ComboEdit layoutEdit = (ComboEdit)this.view.getControl(FIELD_LAYOUT_NUMBER_D);
        layoutEdit.setComboItems(items);
        if (layouts.isEmpty()) {
            return;
        }
        String selectLayout = (String)this.model.getValue(FIELD_LAYOUT_NUMBER_D);
        if (StringUtils.isBlank((CharSequence)selectLayout)) {
            Map defaultLayout = (Map)layouts.get(0);
            String id = (String)defaultLayout.get("id");
            String number = (String)defaultLayout.get(FIELD_NUMBER);
            this.model.setValue(FIELD_LAYOUT_NUMBER_D, (Object)id);
            this.model.setValue(LAYOUT_NUMBER, (Object)number);
        }
    }

    protected String getFormId() {
        DynamicObject curBill = (DynamicObject)this.model.getValue(FIELD_FORM_NUMBER);
        if (null == curBill) {
            return "";
        }
        BasedataEntityType rdType = (BasedataEntityType)curBill.getDataEntityType();
        return curBill.get(rdType.getNumberProperty()).toString();
    }

    protected String getLayoutId() {
        String id = (String)this.model.getValue(FIELD_LAYOUT_NUMBER_D);
        if (StringUtils.isBlank((CharSequence)id)) {
            return "";
        }
        String layoutCache = this.pageCache.get(LAYOUT_LIST_CACHE);
        List layouts = SerializationUtils.fromJsonStringToList((String)layoutCache, Map.class);
        return layouts.stream().filter(item -> item.get("id").equals(id)).map(item -> (String)item.get(FIELD_NUMBER)).findFirst().orElse("");
    }

    private void setDefaultNumber() {
        String billFormNumber;
        String number = (String)this.model.getValue(FIELD_NUMBER);
        DynamicObject billForm = (DynamicObject)this.model.getValue(FIELD_FORM_NUMBER);
        String string = billFormNumber = null == billForm ? "" : billForm.getString(FIELD_NUMBER);
        if (StringUtils.isNotBlank((CharSequence)billFormNumber) && StringUtils.isBlank((CharSequence)number)) {
            String currentIsv = AppMetaServiceHelper.getDeveloperInfo();
            String suffix = "kingdee".equals(currentIsv) ? "_KD_S" : "_KD";
            this.model.setValue(FIELD_NUMBER, (Object)(billFormNumber + suffix));
        }
    }

    protected String getName() {
        ILocaleString name = (ILocaleString)this.model.getValue(FIELD_NAME);
        return null == name ? "" : name.getLocaleValue();
    }

    protected void changeLayout(String layoutId) {
        this.model.setValue(LAYOUT_NUMBER, (Object)layoutId);
    }
}

