/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.layoutscheme.scheme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillTypeControlInfo;
import kd.bos.entity.DifferentialControlInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.FieldApInfoUtils;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;

public class LayoutSchemeControlEntryWidget {
    public static final String FIELD_KEY = "fieldkey";
    public static final String FIELD_MUST_INPUT = "mustinput";
    public static final String FIELD_DEFAULT_VALUE = "defaultvalue";
    protected static final String FIELD_CONTROL_ENTRY_DISPLAY = "fieldcontrolentry_d";
    protected static final String FIELD_CONTROL_ENTRY = "fieldcontrolentry";
    private static final String MAIN_ENTITY_NUMBER = "bos_newpageconfig";
    private static final String COL_NAME_D = "fieldname_d";
    private static final String COL_KEY_D = "fieldkey_d";
    private static final String KEY_ENTITYFIELDKEY = "entityfieldkey_d";
    private static final String COL_DEFAULT_VALUE_D = "defaultvalue_d";
    private static final String COL_MUST_INPUT_D = "mustinput_d";
    private static final String COL_DEFAULT_FUNC_PARAM_D = "defaultfuncparam_d";
    private static final List<String> SIMPLE_FIELDS = Arrays.asList("TextField", "BillNoField", "LargeTextField", "MuliLangTextField", "TextAreaField", "IconField", "PictureField", "CheckBoxField", "DecimalField", "AmountField", "QtyField", "IntegerField", "PriceField", "AttachmentCountField", "PrintCountFIeld", "BigIntField");
    private static final List<String> UNSUPPORTED_FIELDS = Arrays.asList("BasedataPropField", "UserAvatarField", "BillTypeField", "CreateDateField", "CreaterField", "ModifierField", "ModifyDateField", "ItemClassField", "ItemClassTypeField", "ParentBasedataField", "FlexField", "FormulaField", "FilterField", "PeriodField", "OrgField", "MulBasedataField", "TimeField", "TimeRangeField");
    private static final List<String> UNSUPPORTED_MUST_INPUT_FIELDS = Arrays.asList("BasedataPropField", "FlexField", "BillTypeField");
    private static final Map<String, String> VISIBLE2STATUS = new HashMap<String, String>();
    private static final Map<String, String> LOCK2STATUS = new HashMap<String, String>();
    private static final Map<String, String> DISPLAY2STORE = new HashMap<String, String>();
    private IFormView view;
    private IDataModel model;

    protected LayoutSchemeControlEntryWidget(IFormView view, IDataModel model) {
        this.view = view;
        this.model = model;
    }

    protected void init(String formId, String layoutId, boolean fromDb) {
        this.model.deleteEntryData(FIELD_CONTROL_ENTRY_DISPLAY);
        if (StringUtils.isBlank((CharSequence)formId)) {
            return;
        }
        Map ctrlInfos = FieldApInfoUtils.getFullControlInfos((String)(layoutId = StringUtils.isBlank((CharSequence)layoutId) ? formId : layoutId), (String)formId);
        if (ctrlInfos.isEmpty()) {
            return;
        }
        Object pkId = ((BillShowParameter)this.view.getFormShowParameter()).getPkId();
        if (pkId == null || pkId.equals(0L)) {
            pkId = this.model.getDataEntity().getPkValue();
        }
        this.initDisplayEntry(ctrlInfos, fromDb, pkId);
        this.lockDisplayFields(ctrlInfos);
        this.view.updateView(FIELD_CONTROL_ENTRY_DISPLAY);
    }

    private void initDisplayEntry(Map<String, BillTypeControlInfo> ctlInfos, boolean fromDb, Object pkId) {
        this.model.beginInit();
        this.model.batchCreateNewEntryRow(FIELD_CONTROL_ENTRY_DISPLAY, ctlInfos.size());
        DynamicObjectCollection list = fromDb ? this.loadFromDb(pkId) : this.model.getEntryEntity(FIELD_CONTROL_ENTRY);
        List<DifferentialControlInfo> diffInfos = this.resolveDifferentialControlInfos(ctlInfos, list);
        HashMap<String, DifferentialControlInfo> diffInfoMap = new HashMap<String, DifferentialControlInfo>(diffInfos.size());
        for (DifferentialControlInfo info : diffInfos) {
            diffInfoMap.put(info.getFieldKey(), info);
        }
        int index = 0;
        for (Map.Entry<String, BillTypeControlInfo> entry : ctlInfos.entrySet()) {
            boolean flag;
            BillTypeControlInfo ctrlInfo = entry.getValue();
            this.model.setValue(KEY_ENTITYFIELDKEY, (Object)ctrlInfo.getEntityFieldKey(), index);
            this.model.setValue(COL_KEY_D, (Object)ctrlInfo.getFieldKey(), index);
            this.model.setValue(COL_NAME_D, (Object)ctrlInfo.getFieldName(), index);
            this.model.setValue(COL_DEFAULT_FUNC_PARAM_D, (Object)ctrlInfo.getFieldType(), index);
            DifferentialControlInfo diffInfo = (DifferentialControlInfo)diffInfoMap.get(ctrlInfo.getFieldKey());
            if (null != diffInfo && StringUtils.isNotBlank((CharSequence)diffInfo.getDefaultValue())) {
                this.model.setValue(COL_DEFAULT_VALUE_D, (Object)diffInfo.getDefaultValue(), index);
            }
            boolean mustInput = diffInfo != null ? diffInfo.isMustInput().booleanValue() : ctrlInfo.isMustInput();
            this.model.setValue(COL_MUST_INPUT_D, (Object)mustInput, index);
            for (Map.Entry<String, String> lockEntry : LOCK2STATUS.entrySet()) {
                flag = diffInfo != null ? diffInfo.isLock(lockEntry.getValue()).booleanValue() : ctrlInfo.isLock(lockEntry.getValue());
                this.model.setValue(lockEntry.getKey(), (Object)flag, index);
            }
            for (Map.Entry<String, String> visibleEntry : VISIBLE2STATUS.entrySet()) {
                flag = diffInfo != null ? diffInfo.isVisible(visibleEntry.getValue()).booleanValue() : ctrlInfo.isVisible(visibleEntry.getValue());
                this.model.setValue(visibleEntry.getKey(), (Object)flag, index);
            }
            ++index;
        }
        this.model.endInit();
    }

    protected void lockDisplayFields(Map<String, BillTypeControlInfo> ctlInfos) {
        int i = 0;
        for (Map.Entry<String, BillTypeControlInfo> entry : ctlInfos.entrySet()) {
            BillTypeControlInfo ctlInfo = entry.getValue();
            int rowIndex = i++;
            this.lockCell(COL_KEY_D, rowIndex);
            this.lockCell(COL_NAME_D, rowIndex);
            if (UNSUPPORTED_FIELDS.contains(ctlInfo.getFieldType())) {
                this.lockCell(COL_DEFAULT_VALUE_D, rowIndex);
            }
            if (ctlInfo.isMustInput() || UNSUPPORTED_MUST_INPUT_FIELDS.contains(ctlInfo.getFieldType())) {
                this.lockCell(COL_MUST_INPUT_D, rowIndex);
            }
            VISIBLE2STATUS.forEach((statusKey, status) -> {
                if (!ctlInfo.isVisible(status)) {
                    this.lockCell((String)statusKey, rowIndex);
                }
            });
            LOCK2STATUS.forEach((statusKey, status) -> {
                if (ctlInfo.isLock(status)) {
                    this.lockCell((String)statusKey, rowIndex);
                }
            });
        }
    }

    private void lockCell(String key, int row) {
        FieldEdit cellEdit = (FieldEdit)this.view.getControl(key);
        cellEdit.setEntryKey(FIELD_CONTROL_ENTRY_DISPLAY);
        cellEdit.setEnable("", false, row);
    }

    protected void changeLayout(String formId, String layoutId) {
        this.model.deleteEntryData(FIELD_CONTROL_ENTRY);
        this.init(formId, layoutId, false);
    }

    private DynamicObjectCollection loadFromDb(Object id) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)MAIN_ENTITY_NUMBER);
        DynamicObject[] arr = BusinessDataReader.load((Object[])new Object[]{id}, (DynamicObjectType)mainEntityType, (Boolean)true);
        if (null == arr || arr.length == 0) {
            return null;
        }
        DynamicObject layoutConfig = arr[0];
        return layoutConfig.getDynamicObjectCollection(FIELD_CONTROL_ENTRY);
    }

    private List<DifferentialControlInfo> resolveDifferentialControlInfos(Map<String, BillTypeControlInfo> fullInfo, DynamicObjectCollection storeInfos) {
        ArrayList<DifferentialControlInfo> diffInfos = new ArrayList<DifferentialControlInfo>();
        HashMap<String, DifferentialControlInfo> finishedFields = new HashMap<String, DifferentialControlInfo>();
        if (null == storeInfos || storeInfos.isEmpty()) {
            return diffInfos;
        }
        for (DynamicObject storeInfo : storeInfos) {
            String fieldKey = storeInfo.getString(FIELD_KEY);
            BillTypeControlInfo fieldInfo = fullInfo.get(fieldKey);
            if (fieldInfo == null) continue;
            DifferentialControlInfo differentialControlInfo = (DifferentialControlInfo)finishedFields.get(fieldKey);
            if (differentialControlInfo == null) {
                differentialControlInfo = new DifferentialControlInfo();
                diffInfos.add(differentialControlInfo);
                finishedFields.put(fieldKey, differentialControlInfo);
            }
            differentialControlInfo.setFieldKey(fieldKey);
            differentialControlInfo.setFieldId(fieldInfo.getFieldId());
            differentialControlInfo.setEntityFieldKey(fieldInfo.getEntityFieldKey());
            if (!Objects.equals(storeInfo.getBoolean(FIELD_MUST_INPUT), fieldInfo.isMustInput())) {
                differentialControlInfo.setMustInput(true);
            } else {
                differentialControlInfo.setMustInput(fieldInfo.isMustInput());
            }
            for (Map.Entry<String, String> entry : VISIBLE2STATUS.entrySet()) {
                if (!Objects.equals(storeInfo.get(DISPLAY2STORE.get(entry.getKey())), fieldInfo.isVisible(entry.getValue()))) {
                    differentialControlInfo.addVisible(entry.getValue(), false);
                    continue;
                }
                differentialControlInfo.addVisible(entry.getValue(), fieldInfo.isVisible(entry.getValue()));
            }
            for (Map.Entry<String, String> entry : LOCK2STATUS.entrySet()) {
                if (!Objects.equals(storeInfo.get(DISPLAY2STORE.get(entry.getKey())), fieldInfo.isLock(entry.getValue()))) {
                    differentialControlInfo.addLock(entry.getValue(), true);
                    continue;
                }
                differentialControlInfo.addLock(entry.getValue(), fieldInfo.isLock(entry.getValue()));
            }
            if (!StringUtils.isNotBlank((CharSequence)storeInfo.getString(FIELD_DEFAULT_VALUE))) continue;
            differentialControlInfo.setDefaultValue(storeInfo.getString(FIELD_DEFAULT_VALUE));
        }
        return diffInfos;
    }

    protected void buildDifferentialControlInfo(String formId, String layoutId) {
        int i;
        if (StringUtils.isBlank((CharSequence)formId) || StringUtils.isBlank((CharSequence)layoutId)) {
            return;
        }
        Map ctrlInfos = FieldApInfoUtils.getFullControlInfos((String)layoutId, (String)formId);
        DynamicObjectCollection displayEntry = this.model.getEntryEntity(FIELD_CONTROL_ENTRY_DISPLAY);
        HashSet<Integer> changeFields = new HashSet<Integer>();
        block0: for (i = 0; i < displayEntry.size(); ++i) {
            DynamicObject row = (DynamicObject)displayEntry.get(i);
            String fieldKey = row.getString(COL_KEY_D);
            String defaultValue = row.getString(COL_DEFAULT_VALUE_D);
            Boolean mustInput = row.getBoolean(COL_MUST_INPUT_D);
            BillTypeControlInfo ctrlInfo = (BillTypeControlInfo)ctrlInfos.get(fieldKey);
            if (StringUtils.isNotBlank((CharSequence)defaultValue) || !Objects.equals(mustInput, ctrlInfo.isMustInput())) {
                changeFields.add(i);
                continue;
            }
            for (Map.Entry<String, String> entry : VISIBLE2STATUS.entrySet()) {
                if (Objects.equals(row.get(entry.getKey()), ctrlInfo.isVisible(entry.getValue()))) continue;
                changeFields.add(i);
                break;
            }
            for (Map.Entry<String, String> entry : LOCK2STATUS.entrySet()) {
                if (Objects.equals(row.get(entry.getKey()), ctrlInfo.isLock(entry.getValue()))) continue;
                changeFields.add(i);
                continue block0;
            }
        }
        this.model.deleteEntryData(FIELD_CONTROL_ENTRY);
        if (changeFields.isEmpty()) {
            return;
        }
        this.model.batchCreateNewEntryRow(FIELD_CONTROL_ENTRY, changeFields.size());
        i = 0;
        Iterator iterator = changeFields.iterator();
        while (iterator.hasNext()) {
            int changeFieldIdx = (Integer)iterator.next();
            DynamicObject displayRowObj = (DynamicObject)displayEntry.get(changeFieldIdx);
            for (Map.Entry<String, String> entry : DISPLAY2STORE.entrySet()) {
                this.model.setValue(entry.getValue(), displayRowObj.get(entry.getKey()), i);
            }
            ++i;
        }
    }

    protected void showDefaultValueEditForm(String formId, CloseCallBack callback) {
        if (StringUtils.isBlank((CharSequence)formId)) {
            return;
        }
        int currentRow = this.model.getEntryCurrentRowIndex(FIELD_CONTROL_ENTRY_DISPLAY);
        String fieldType = (String)this.model.getValue(COL_DEFAULT_FUNC_PARAM_D, currentRow);
        if (StringUtils.isBlank((CharSequence)fieldType) || SIMPLE_FIELDS.contains(fieldType) || UNSUPPORTED_FIELDS.contains(fieldType)) {
            return;
        }
        String fieldKey = (String)this.model.getValue(COL_KEY_D, currentRow);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_defaultvalueedit");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> mockContext = new HashMap<String, String>();
        mockContext.put("FormId", formId);
        mockContext.put("_Type_", fieldType);
        mockContext.put("Key", fieldKey);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)formId);
        IDataEntityProperty prop = mainEntityType.findProperty(fieldKey);
        if (prop instanceof MulBasedataProp) {
            mockContext.put("BaseEntityId", ((MulBasedataProp)prop).getBaseEntityId());
        } else if (prop instanceof BasedataProp) {
            String id = MetadataDao.getIdByNumber((String)((BasedataProp)prop).getBaseEntityId(), (MetaCategory)MetaCategory.Entity);
            mockContext.put("BaseEntityId", id);
        }
        if (prop instanceof AssistantProp) {
            mockContext.put("AsstTypeId", ((AssistantProp)prop).getAsstTypeId());
        }
        parameter.setCustomParam("context", Collections.singletonList(mockContext));
        parameter.setCustomParam("formLayoutScheme", (Object)"true");
        parameter.setCloseCallBack(callback);
        this.view.showForm(parameter);
    }

    protected void postBackDefaultValue(Object value) {
        int currentRow = this.model.getEntryCurrentRowIndex(FIELD_CONTROL_ENTRY_DISPLAY);
        this.model.setValue(COL_DEFAULT_VALUE_D, value, currentRow);
    }

    static {
        VISIBLE2STATUS.put("vinit_d", "init");
        VISIBLE2STATUS.put("vnew_d", "new");
        VISIBLE2STATUS.put("vedit_d", "edit");
        VISIBLE2STATUS.put("vview_d", "view");
        VISIBLE2STATUS.put("vsubmit_d", "submit");
        VISIBLE2STATUS.put("vaudit_d", "audit");
        LOCK2STATUS.put("enabled_d", "new");
        LOCK2STATUS.put("editenabled_d", "edit");
        LOCK2STATUS.put("submitenabled_d", "submit");
        LOCK2STATUS.put("auditenabled_d", "audit");
        DISPLAY2STORE.put(COL_KEY_D, FIELD_KEY);
        DISPLAY2STORE.put(KEY_ENTITYFIELDKEY, "entityfieldkey");
        DISPLAY2STORE.put("vinit_d", "vinit");
        DISPLAY2STORE.put("vnew_d", "vnew");
        DISPLAY2STORE.put("vedit_d", "vedit");
        DISPLAY2STORE.put("vview_d", "vview");
        DISPLAY2STORE.put("vsubmit_d", "vsubmit");
        DISPLAY2STORE.put("vaudit_d", "vaudit");
        DISPLAY2STORE.put("enabled_d", "enabled");
        DISPLAY2STORE.put("editenabled_d", "editenabled");
        DISPLAY2STORE.put("submitenabled_d", "submitenabled");
        DISPLAY2STORE.put("auditenabled_d", "auditenabled");
        DISPLAY2STORE.put(COL_MUST_INPUT_D, FIELD_MUST_INPUT);
        DISPLAY2STORE.put(COL_DEFAULT_VALUE_D, FIELD_DEFAULT_VALUE);
    }
}

