/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.layoutscheme.scheme;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.bill.BillLayoutSchemeAssignEntity;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.layoutscheme.scheme.LayoutSchemeBasicInfoWidget;
import kd.bos.form.plugin.layoutscheme.scheme.LayoutSchemeControlEntryWidget;
import kd.bos.metadata.FieldApInfoUtils;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;

public class LayoutSchemeEditPlugin
extends AbstractBillPlugIn
implements ICloseCallBack {
    private static final String KEY_DEFAULT_VALUE = "defaultvalue_d";
    private static final String OPERATION_ALLOCATION = "allocation";
    private LayoutSchemeBasicInfoWidget basicInfo;
    private LayoutSchemeControlEntryWidget controlEntry;

    public static void removeCache() {
        IDataEntityType type = OrmUtils.getDataEntityType(BillLayoutSchemeAssignEntity.class);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager(type);
        cacheManager.removeByDt();
    }

    public void initialize() {
        this.basicInfo = new LayoutSchemeBasicInfoWidget(this.getView(), this.getModel());
        this.controlEntry = new LayoutSchemeControlEntryWidget(this.getView(), this.getModel());
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_DEFAULT_VALUE});
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void click(EventObject e) {
        Control control = (Control)e.getSource();
        String btnKey = control.getKey();
        if (KEY_DEFAULT_VALUE.equals(btnKey)) {
            this.controlEntry.showDefaultValueEditForm(this.basicInfo.getFormId(), new CloseCallBack((IFormPlugin)this, KEY_DEFAULT_VALUE));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (KEY_DEFAULT_VALUE.equals(actionId) && null != returnData) {
            Map data = (Map)returnData;
            this.controlEntry.postBackDefaultValue(data.get("value"));
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.basicInfo.init();
        this.controlEntry.init(this.basicInfo.getFormId(), this.basicInfo.getLayoutId(), true);
    }

    public void afterLoadData(EventObject e) {
        this.basicInfo.init();
        this.controlEntry.init(this.basicInfo.getFormId(), this.basicInfo.getLayoutId(), true);
        this.getModel().setDataChanged(false);
    }

    public void afterCopyData(EventObject e) {
        this.basicInfo.init();
        this.controlEntry.init(this.basicInfo.getFormId(), this.basicInfo.getLayoutId(), true);
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getModel().getValue("formnumber") != null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"formnumber"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        AbstractOperate operate = (AbstractOperate)evt.getSource();
        String operateKey = operate.getOperateKey();
        List<String> operatorKeys = Arrays.asList("save", "saveandnew");
        if (operatorKeys.contains(operateKey)) {
            this.controlEntry.buildDifferentialControlInfo(this.basicInfo.getFormId(), this.basicInfo.getLayoutId());
        } else if ("new".equals(operateKey)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"formnumber"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey = evt.getOperateKey();
        if (OPERATION_ALLOCATION.equals(operateKey)) {
            String formId = this.basicInfo.getFormId();
            if (StringUtils.isBlank((CharSequence)formId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"LayoutSchemeEditPlugin_0", (String)"bos-form-business", (Object[])new Object[0]));
                return;
            }
            if (!this.getModel().getDataEntity().getDataEntityState().getFromDatabase()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4fdd\u5b58\u754c\u9762\u65b9\u6848\u4e4b\u540e\u518d\u8fdb\u884c\u5206\u914d\u3002", (String)"LayoutSchemeEditPlugin_2", (String)"bos-form-business", (Object[])new Object[0]));
                return;
            }
            if ("0".equals(this.getModel().getValue("enable"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u754c\u9762\u65b9\u6848\u88ab\u7981\u7528\uff0c\u8bf7\u542f\u7528\u4e4b\u540e\u518d\u8fdb\u884c\u5206\u914d\u3002", (String)"LayoutSchemeEditPlugin_1", (String)"bos-form-business", (Object[])new Object[0]));
                return;
            }
            Object layoutSchemeId = this.getModel().getDataEntity().getPkValue();
            String mainOrg = this.getOrgFuncId(formId);
            String appId = BizAppServiceHelp.getAppIdByFormNum((String)formId);
            DynamicObject cloud = BizCloudServiceHelp.getBizCloudByAppID((String)appId);
            Object cloudId = cloud == null ? "" : cloud.getPkValue();
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("bos_selallocationty");
            formShowParameter.setCustomParam("appId", (Object)appId);
            formShowParameter.setCustomParam("mainOrg", (Object)mainOrg);
            formShowParameter.setCustomParam("formId", (Object)formId);
            formShowParameter.setCustomParam("cloudId", cloudId);
            formShowParameter.setCustomParam("schemeName", layoutSchemeId);
            this.getView().showForm(formShowParameter);
        } else if ("save".equals(operateKey)) {
            LayoutSchemeEditPlugin.removeCache();
        } else if ("disable".equals(operateKey) || "enable".equals(operateKey)) {
            LayoutSchemeEditPlugin.removeCache();
        }
    }

    private void lockLimitEditCell() {
        Map ctrlInfos = FieldApInfoUtils.getFullControlInfos((String)this.basicInfo.getLayoutId(), (String)this.basicInfo.getFormId());
        if (ctrlInfos.isEmpty()) {
            return;
        }
        this.controlEntry.lockDisplayFields(ctrlInfos);
    }

    public String getOrgFuncId(String formId) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)formId);
        if (mainEntityType == null) {
            return "15";
        }
        String mainOrg = mainEntityType.getMainOrg();
        if (StringUtils.isBlank((CharSequence)mainOrg)) {
            return "15";
        }
        MainOrgProp org = (MainOrgProp)mainEntityType.getProperty(mainOrg);
        if (org == null) {
            return "15";
        }
        String orgFuncId = org.getOrgFunc();
        return StringUtils.isBlank((CharSequence)orgFuncId) ? "15" : orgFuncId;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        IDataEntityProperty property = e.getProperty();
        String string = name = property == null ? "" : property.getName();
        if ("formnumber".equals(name)) {
            ChangeData[] changeData = e.getChangeSet();
            Object newValue = changeData[0].getNewValue();
            Object oldValue = changeData[0].getOldValue();
            if (newValue != null && !newValue.equals(oldValue)) {
                this.basicInfo.changeForm();
                this.controlEntry.changeLayout(this.basicInfo.getFormId(), this.basicInfo.getLayoutId());
            }
            return;
        }
        if ("layoutnumber_d".equals(name)) {
            ChangeData[] changeData = e.getChangeSet();
            Object newValue = changeData[0].getNewValue();
            Object oldValue = changeData[0].getOldValue();
            if (newValue != null && !newValue.equals(oldValue)) {
                this.basicInfo.changeLayout(this.basicInfo.getLayoutId());
                this.controlEntry.changeLayout(this.basicInfo.getFormId(), this.basicInfo.getLayoutId());
            }
            return;
        }
    }
}

