/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.lightlayout;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.lightlayout.FormMetaUtil;
import kd.bos.form.plugin.lightlayout.IFormMetaUtil;
import kd.bos.form.plugin.lightlayout.LightLayoutUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.AbstractBasedataField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.entity.fielddefvalue.DefValueDesign;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import org.apache.commons.beanutils.ConvertUtils;

public class LightLayoutSaveServicePlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(LightLayoutSaveServicePlugin.class);
    private IFormMetaUtil iFormMetaUtil = new FormMetaUtil();

    protected MetadataWriter getMetadataWriter(String modelType) {
        return new MetadataWriter(modelType);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] rows = e.getDataEntities();
        FormMetadata[] formMetadatas = new FormMetadata[rows.length];
        String[] newId = new String[rows.length];
        int i = 0;
        for (DynamicObject row : rows) {
            String number = row.getString("number");
            FormMetadata formMetadata = this.iFormMetaUtil.getFormMetadata(number);
            if (formMetadata == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u8868\u5355\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u8868\u5355\u5143\u6570\u636e\u662f\u5426\u6b63\u5e38\u3002", (String)"LightLayoutSaveServicePlugin_0", (String)"bos-form-business", (Object[])new Object[0]));
            }
            BillFormAp rootAp = (BillFormAp)formMetadata.getRootAp();
            if (rootAp.getMobMeta() != null) {
                rootAp.getMobMeta().bindEntityMetadata(formMetadata.getEntityMetadata());
                rootAp.getMobMeta().createIndex();
            }
            if (rootAp.getListMeta() != null) {
                rootAp.getListMeta().createIndex();
            }
            if (rootAp.getMobListMeta() != null) {
                rootAp.getMobListMeta().createIndex();
            }
            this.setBillMetatadata(row.getDynamicObjectCollection("billentry_s"), formMetadata, rootAp);
            this.setListMetadata(row.getDynamicObjectCollection("listentry_s"), rootAp);
            formMetadatas[i] = formMetadata;
            newId[i] = String.valueOf(row.getPkValue());
            ++i;
        }
        this.saveMetadata(newId, formMetadatas);
    }

    private void setBillMetatadata(DynamicObjectCollection billentryRows, FormMetadata formMetadata, BillFormAp rootAp) {
        boolean isLayout = !formMetadata.getId().equals(formMetadata.getEntityId());
        for (DynamicObject entryRow : billentryRows) {
            String controlId = entryRow.getString("controlid_s");
            ControlAp item = formMetadata.getItem(controlId);
            if (item == null && rootAp.getMobMeta() != null) {
                item = rootAp.getMobMeta().getItem(controlId);
            }
            if (item == null) {
                logger.info("can't find control id:{},key:{}", (Object)controlId, (Object)entryRow.getString("fieldkey_s"));
                continue;
            }
            item.setName(LocaleString.fromMap((Map)entryRow.getLocaleString("fielddspname_s")));
            item.setLock(LightLayoutUtil.getMapValue(entryRow, LightLayoutUtil.LOCK2STATUS));
            item.setVisible(LightLayoutUtil.getMapValue(entryRow, LightLayoutUtil.VISIBLE2STATUS));
            if (isLayout || !(item instanceof FieldAp)) continue;
            Field field = ((FieldAp)item).getField();
            field.setMustInput(entryRow.getBoolean("fieldmustinput_s"));
            String defValue = entryRow.getString("fielddefvalue_s");
            if (StringUtils.isNotBlank((CharSequence)defValue)) {
                this.setDefValue(entryRow, field, defValue);
            }
            field.setName(LocaleString.fromMap((Map)entryRow.getLocaleString("fielddspname_s")));
        }
        this.swapIndex(formMetadata, billentryRows, "controlid_s");
        if (rootAp.getMobMeta() != null) {
            this.swapIndex(rootAp.getMobMeta(), billentryRows, "controlid_s");
        }
    }

    private void swapIndex(FormMetadata formMetadata, DynamicObjectCollection rows, String idField) {
        String controlId;
        HashSet<String> done = new HashSet<String>(16);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int index = 1;
        for (DynamicObject entryRow : rows) {
            controlId = entryRow.getString(idField);
            map.put(controlId, index++);
        }
        for (DynamicObject entryRow : rows) {
            int i;
            ControlAp parent;
            ControlAp item;
            controlId = entryRow.getString(idField);
            if (done.contains(controlId) || (item = formMetadata.getItem(controlId)) == null || !StringUtils.isNotBlank((CharSequence)item.getParentId()) || !((parent = formMetadata.getItem(item.getParentId())) instanceof ContainerAp)) continue;
            List childItems = ((ContainerAp)parent).getItems();
            childItems.removeIf(o -> !map.containsKey(o.getId()));
            int[] oldIndex = new int[childItems.size()];
            for (i = 0; i < childItems.size(); ++i) {
                oldIndex[i] = ((ControlAp)childItems.get(i)).getIndex();
                done.add(((ControlAp)childItems.get(i)).getId());
            }
            childItems.sort(Comparator.comparingInt(o -> map.get(o.getId()) == null ? 0 : (Integer)map.get(o.getId())));
            for (i = 0; i < childItems.size(); ++i) {
                ((ControlAp)childItems.get(i)).setIndex(oldIndex[i]);
            }
        }
    }

    private void setListMetadata(DynamicObjectCollection rows, BillFormAp rootAp) {
        for (DynamicObject entryRow : rows) {
            String controlId = entryRow.getString("listcontrolid_s");
            String layouttype = entryRow.getString("listlayouttype_s");
            ControlAp item = null;
            if ("pc".equals(layouttype)) {
                if (rootAp.getListMeta() != null) {
                    item = rootAp.getListMeta().getItem(controlId);
                }
            } else if (rootAp.getMobListMeta() != null) {
                item = rootAp.getMobListMeta().getItem(controlId);
            }
            if (item == null) {
                logger.info("can't find control id:{},key:{}", (Object)controlId, (Object)entryRow.getString("listkey_s"));
                continue;
            }
            item.setName(LocaleString.fromMap((Map)entryRow.getLocaleString("listdspname_s")));
            String mapValue = LightLayoutUtil.getMapValue(entryRow, LightLayoutUtil.LISTVISIBLE2STATUS);
            if ("default,lookup".equals(mapValue)) {
                mapValue = "default,lookup,init,new,edit,view,submit,audit";
            }
            item.setVisible(mapValue);
        }
        if (rootAp.getListMeta() != null) {
            this.swapIndex(rootAp.getListMeta(), rows, "listcontrolid_s");
        }
        if (rootAp.getMobListMeta() != null) {
            this.swapIndex(rootAp.getMobListMeta(), rows, "listcontrolid_s");
        }
    }

    private void setDefValue(DynamicObject entryRow, Field<?> field, String defValue) {
        block13: {
            if (field instanceof TextField) {
                ((TextField)field).setDefValue(defValue);
            } else if (field instanceof AbstractBasedataField) {
                String defValueDesign = entryRow.getString("fielddefvaluedesign_s");
                if (StringUtils.isNotBlank((CharSequence)defValueDesign)) {
                    Map map = (Map)SerializationUtils.fromJsonString((String)defValueDesign, Map.class);
                    DefValueDesign defVal = new DefValueDesign();
                    defVal.setFuncType((String)map.get("FuncType"));
                    defVal.setFuncParameter((String)map.get("FuncParameter"));
                    ((AbstractBasedataField)field).setDefValueDesign(defVal);
                }
            } else if (field instanceof DateTimeField) {
                String defValueDesign = entryRow.getString("fielddefvaluedesign_s");
                if (StringUtils.isNotBlank((CharSequence)defValueDesign)) {
                    Map map = (Map)SerializationUtils.fromJsonString((String)defValueDesign, Map.class);
                    DefValueDesign defVal = new DefValueDesign();
                    defVal.setFuncType((String)map.get("FuncType"));
                    defVal.setFuncParameter((String)map.get("FuncParameter"));
                    ((DateTimeField)field).setDefValueDesign(defVal);
                } else if (StringUtils.isNotBlank((CharSequence)defValue)) {
                    ((DateTimeField)field).setDefValue(defValue);
                }
            } else {
                try {
                    Method[] methods;
                    for (Method method : methods = field.getClass().getMethods()) {
                        if (!method.getName().equals("setDefValue") || method.getParameterCount() != 1) continue;
                        method.invoke(field, ConvertUtils.convert((Object)entryRow.get("fielddefvalue_s"), method.getParameterTypes()[0]));
                        break;
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    if (!(ex instanceof IllegalArgumentException)) break block13;
                    logger.info("\u53c2\u6570\u9519\u8bef:{}", (Object)ex);
                }
            }
        }
    }

    private void saveMetadata(String[] newId, FormMetadata[] formMetadatas) {
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                int i = 0;
                for (FormMetadata formMetadata : formMetadatas) {
                    String masterId = StringUtils.isBlank((CharSequence)formMetadata.getMasterId()) ? formMetadata.getId() : formMetadata.getMasterId();
                    LightLayoutSaveServicePlugin.setExtMeta((AbstractMetadata)formMetadata, masterId);
                    formMetadata.setKey(newId[i]);
                    MetadataWriter metadataWriter = this.getMetadataWriter(formMetadata.getModelType());
                    if (formMetadata.getId().equals(formMetadata.getEntityId())) {
                        formMetadata.setId(newId[i]);
                        formMetadata.setEntityId(newId[i]);
                        EntityMetadata entityMetadata = formMetadata.getEntityMetadata();
                        LightLayoutSaveServicePlugin.setExtMeta((AbstractMetadata)entityMetadata, masterId);
                        entityMetadata.setKey(newId[i]);
                        entityMetadata.setId(newId[i]);
                        metadataWriter.save(new AbstractMetadata[]{formMetadata, entityMetadata});
                    } else {
                        formMetadata.setId(newId[i]);
                        metadataWriter.save(new AbstractMetadata[]{formMetadata});
                    }
                    txHandle.commit();
                }
            }
            catch (Exception ex) {
                txHandle.markRollback();
                throw ex;
            }
        }
    }

    private static void setExtMeta(AbstractMetadata metadata, String masterId) {
        metadata.setIsv("kdprod");
        metadata.setParentId(metadata.getId());
        metadata.setDevType("2");
        metadata.setMasterId(masterId);
        if (metadata instanceof FormMetadata) {
            ((FormMetadata)metadata).setEnabled(true);
        } else if (metadata instanceof EntityMetadata) {
            ((EntityMetadata)metadata).setEnabled(true);
        }
        String path = metadata.getInheritPath();
        path = StringUtils.isNotBlank((CharSequence)path) ? path + "," + metadata.getId() : metadata.getId();
        metadata.setInheritPath(path);
    }
}

