/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.list;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.LayoutControlInfo;
import kd.bos.entity.SelectedDisplayField;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.plugin.Plugin;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.events.AfterBindDataEvent;
import kd.bos.form.events.AfterBindDataListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ORMUtil;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.list.AbstractMobF7Plugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.list.MulBdPermUtil;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.mvc.list.MobileListView;

public class MobTabF7Plugin
extends AbstractMobF7Plugin {
    private static final String FLEX_PANEL_AP_1 = "flexpanelap1";
    private static final String BOS_MOB_LIST_TAB_F7_SELECTED = "bos_moblisttabf7selected";
    private static final String PAGE_ID = "pageId";
    private static final String IS_MULTI_SELECT = "isMultiSelect";
    private static final String SELECTED_DISPLAY_FIELD = "selectedDisplayField";
    private static final String LB_SEL = "lbsel";
    private static final String LBL_CLEAR = "lblclear";
    private static final String LBL_CLEAR_1 = "lblclear1";
    private static final String CONFIRM = "confirm";
    private static final String FLEX_CLEAR = "flexclear";
    private static final String SHOW_FREQUENT_PANEL = "showFrequentPanel";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";

    @Override
    public void registerListener(EventObject e) {
        Label lbclear1;
        final BillList billList = (BillList)this.getControl("billlistap");
        final Label lbsel = (Label)this.getControl(LB_SEL);
        Label lbclear = (Label)this.getControl(LBL_CLEAR);
        Container flexPanel = (Container)this.getControl(FLEX_PANEL_AP_1);
        flexPanel.addClickListener((ClickListener)this);
        if (lbclear != null) {
            lbclear.addClickListener(new ClickListener(){

                public void click(EventObject evt) {
                    if (billList != null) {
                        FormShowParameter showParameter = MobTabF7Plugin.this.getView().getFormShowParameter();
                        String parentFormId = (String)showParameter.getCustomParam("originFormId");
                        if (parentFormId == null) {
                            billList.clearSelection();
                        } else {
                            if (parentFormId.endsWith("_mob")) {
                                FormConfig mobileConfig = FormMetadataCache.getFormConfig((String)parentFormId);
                                parentFormId = mobileConfig.getEntityTypeId();
                            }
                            showParameter.setCustomParam("originFormId", (Object)parentFormId);
                            ListSelectedRowCollection collection = billList.getSelectedRows();
                            List pks = collection.stream().map(c -> c.getPrimaryKeyValue()).collect(Collectors.toList());
                            Map result = MulBdPermUtil.getAblePkIdsForMulBdProp((IFormView)MobTabF7Plugin.this.getView(), pks);
                            ArrayList unauthorizedDatas = new ArrayList();
                            if (result != null && result.get("items") != null) {
                                unauthorizedDatas = (ArrayList)result.get("items");
                            }
                            if (!unauthorizedDatas.isEmpty()) {
                                billList.restoreUnRemovablePks(unauthorizedDatas);
                            } else {
                                billList.clearSelection();
                            }
                        }
                        lbsel.setText(String.format("%s", billList.getSelectedRows().size()));
                        if (MobTabF7Plugin.this.isMustInput()) {
                            MobTabF7Plugin.this.getView().setEnable(Boolean.valueOf(false), new String[]{MobTabF7Plugin.CONFIRM});
                        }
                        if (billList.getSelectedRows().size() == 0) {
                            MobTabF7Plugin.this.getView().setEnable(Boolean.valueOf(false), new String[]{MobTabF7Plugin.FLEX_PANEL_AP_1});
                        }
                    }
                }
            });
        }
        if ((lbclear1 = (Label)this.getControl(LBL_CLEAR_1)) != null) {
            lbclear1.addClickListener(new ClickListener(){

                public void click(EventObject evt) {
                    if (billList != null) {
                        billList.clearSelection();
                        lbsel.setText(String.format("%s", billList.getSelectedRows().size()));
                        if (!MobTabF7Plugin.this.isMultiSelect()) {
                            ((IListView)MobTabF7Plugin.this.getView()).returnLookupData();
                        }
                        MobTabF7Plugin.this.getView().setEnable(Boolean.valueOf(false), new String[]{MobTabF7Plugin.FLEX_PANEL_AP_1});
                    }
                }
            });
        }
        billList.addListRowClickListener((ListRowClickListener)this);
        billList.addAfterBindDataListener(new AfterBindDataListener(){

            public void afterBindData(AfterBindDataEvent evt) {
                MobTabF7Plugin.this.changeSelectedEnable(MobTabF7Plugin.FLEX_PANEL_AP_1);
                lbsel.setText(String.format("%s", billList.getSelectedRows().size()));
            }
        });
        super.registerListener(e);
    }

    public void listRowClick(ListRowClickEvent event) {
        if (this.switchBilltype(event)) {
            return;
        }
        this.changeConfirmStatus(CONFIRM);
        this.changeSelectedEnable(FLEX_PANEL_AP_1);
        super.listRowClick(event);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if ("switchbilltype".equals(event.getCallBackId())) {
            if (event.getResult() == MessageBoxResult.Yes) {
                Map customVauleMap = (Map)SerializationUtils.fromJsonString((String)event.getCustomVaule(), Map.class);
                if (customVauleMap != null && StringUtils.isNotBlank(customVauleMap.get("formId"))) {
                    Object billTypeId = customVauleMap.get("billTypeId");
                    String formId = (String)customVauleMap.get("formId");
                    this.showLayoutForm(formId, billTypeId);
                }
                this.getView().returnDataToParent(SerializationUtils.fromJsonString((String)this.getPageCache().get("billTypeClientArgs"), ListSelectedRowCollection.class));
                this.getView().close();
            } else if (event.getResult() == MessageBoxResult.Cancel) {
                this.getView().close();
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        if (this.isMultiSelect() || this.isMustInput()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_CLEAR});
        }
        this.changeConfirmStatus(CONFIRM);
        this.changeSelectedEnable(FLEX_PANEL_AP_1);
        super.afterBindData(e);
        this.showFrequentPanel();
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (FLEX_PANEL_AP_1.equals(key) && this.getView().getFormShowParameter() instanceof MobileListShowParameter) {
            MobileListShowParameter listShowParameter = (MobileListShowParameter)this.getView().getFormShowParameter();
            SelectedDisplayField selectedDisplayField = listShowParameter.getSelectedDisplayField();
            MobileFormShowParameter parameter = new MobileFormShowParameter();
            parameter.setFormId(BOS_MOB_LIST_TAB_F7_SELECTED);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam(SELECTED_DISPLAY_FIELD, (Object)selectedDisplayField);
            parameter.setCustomParam(PAGE_ID, (Object)listShowParameter.getPageId());
            parameter.setCustomParam(IS_MULTI_SELECT, (Object)this.isMultiSelect());
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private void showFrequentPanel() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        ListShowParameter showParameter = (ListShowParameter)formShowParameter;
        if (showParameter.isShowFrequent()) {
            String showFrequentPanel;
            HashMap<String, Object> showFrequentMap = new HashMap<String, Object>();
            showFrequentMap.put("type", showParameter.getBillFormId());
            if (this.isMultiSelect()) {
                showFrequentMap.put("isMulti", true);
            }
            if ("false".equals(showFrequentPanel = this.getPageCache().get(SHOW_FREQUENT_PANEL))) {
                showFrequentMap.put("show", false);
            }
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            proxy.invokeControlMethod("billlistap", SHOW_FREQUENT_PANEL, new Object[]{showFrequentMap});
        }
    }

    public void mobileSearchTextChange(MobileSearchTextChangeEvent args) {
        String text = args.getText();
        if (StringUtils.isEmpty((CharSequence)text)) {
            this.getPageCache().put(SHOW_FREQUENT_PANEL, "true");
        } else {
            this.getPageCache().put(SHOW_FREQUENT_PANEL, "false");
        }
        super.mobileSearchTextChange(args);
    }

    private boolean switchBilltype(ListRowClickEvent event) {
        Map resultMap;
        String formId;
        if (!this.isBosBilltype()) {
            return false;
        }
        ListSelectedRowCollection rows = event.getListSelectedRowCollection();
        if (rows == null || rows.isEmpty() && !rows.isClearFlag()) {
            return false;
        }
        ListSelectedRow newValue = rows.get(0);
        String newId = newValue.getPrimaryKeyValue().toString();
        if (StringUtils.isBlank((CharSequence)newId)) {
            return false;
        }
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        ListSelectedRowCollection oldRows = listShowParameter.getListSelectedRowCollection();
        String oldId = "";
        if (oldRows != null && oldRows.size() > 0) {
            ListSelectedRow oldValue = oldRows.get(0);
            oldId = oldValue.getPrimaryKeyValue().toString();
        }
        if (!newId.equalsIgnoreCase(oldId) && LayoutControlInfo.isBillTypeLayout() && StringUtils.isNotBlank((CharSequence)(formId = (String)(resultMap = ORMUtil.getFormIdByBillTypeId((long)Long.parseLong(newId), (boolean)true)).get("formId"))) && !StringUtils.equals((CharSequence)formId, (CharSequence)this.getView().getParentView().getFormShowParameter().getFormId())) {
            boolean switchbilltype = false;
            if (Boolean.parseBoolean((String)resultMap.get("isMobFormId"))) {
                switchbilltype = true;
            } else if (StringUtils.isNotBlank((CharSequence)oldId) && Boolean.parseBoolean((String)(resultMap = ORMUtil.getFormIdByBillTypeId((long)Long.parseLong(oldId), (boolean)true)).get("isMobFormId"))) {
                switchbilltype = true;
            }
            if (switchbilltype) {
                this.prompt(formId, newId, rows);
                event.setCancel(true);
                return switchbilltype;
            }
        }
        return false;
    }

    private boolean isBosBilltype() {
        return this.getView() instanceof MobileListView && "bos_billtype".equals(((MobileListView)this.getView()).getBillFormId());
    }

    private void prompt(String formId, String billTypeId, ListSelectedRowCollection rows) {
        this.getPageCache().put("billTypeClientArgs", SerializationUtils.toJsonString((Object)rows));
        HashMap<String, String> callbackValue = new HashMap<String, String>();
        callbackValue.put("formId", formId);
        callbackValue.put("billTypeId", billTypeId);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5355\u636e\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"MobTabF7Plugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("switchbilltype", (IFormPlugin)this), null, SerializationUtils.toJsonString(callbackValue));
    }

    private void showLayoutForm(String formId, Object billTypePkId) {
        IFormView parentView = this.getView().getParentView();
        MobileBillShowParameter billShowParameter = (MobileBillShowParameter)parentView.getFormShowParameter();
        List plugins = billShowParameter.getFormConfig().getPlugins();
        billShowParameter.setFormId(formId);
        billShowParameter.setBillTypeId(String.valueOf(billTypePkId));
        billShowParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        billShowParameter.setCustomParam("mainOrgId", (Object)this.getMainOrgId());
        billShowParameter.setFormConfig(FormMetadataCache.getFormConfig((String)formId));
        for (Plugin plugin : plugins) {
            if (!plugin.isDynamicPlugin()) continue;
            billShowParameter.addCustPlugin(plugin.getClassName());
        }
        billShowParameter.getCustomParams().put("bos_call_source_type", "billType_showLayoutForm");
        parentView.showForm((FormShowParameter)billShowParameter);
    }

    private Long getMainOrgId() {
        IDataModel parentModel = this.getView().getParentView().getModel();
        MainOrgProp mainOrgProperty = ((BillEntityType)parentModel.getDataEntityType()).getMainOrgProperty();
        if (mainOrgProperty == null) {
            return null;
        }
        DynamicObject mainOrg = (DynamicObject)parentModel.getValue(mainOrgProperty.getName());
        return mainOrg == null ? null : (Long)mainOrg.getPkValue();
    }

    private void changeSelectedEnable(String name) {
        IFormView interView = this.getInterView();
        if (!this.hasSelectedRows()) {
            interView.setEnable(Boolean.valueOf(false), new String[]{name});
        } else {
            interView.setEnable(Boolean.valueOf(true), new String[]{name});
        }
    }
}

