/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.list;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.QFilterDto;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.userconfig.UserFavorite;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.userfavorite.UserFavoriteDAO;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class StandardF7FormPlugin
extends AbstractFormPlugin
implements ListboxClickListener {
    private static final String ALL_BTN = "all_btn";
    private static final String USERFAVORITE_BTN = "userfavorite_btn";
    private static final String ADDFAVORITE_BTN = "addfavorite_btn";
    private static final String REMOVEFAVORITE_BTN = "removefavorite_btn";
    private static final String ISQUERYUSERFAVORITE = "isQueryUserFavorite";
    private static final String BILLLISTAP = "billlistap";
    private static final String ENABLE = "enable";
    private static final String ISSHOWDISABLED = "isshowdisabled";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final String BILL_STATUS = "billstatus";
    private static final String KEY_CALL_FROM_REF_BILL_EDIT = "callFromRefBillEdit";

    public void registerListener(EventObject e) {
        Listbox listbox = (Listbox)this.getView().getControl("listboxap");
        listbox.addListboxClickListener((ListboxClickListener)this);
        this.addClickListeners(new String[]{ADDFAVORITE_BTN, REMOVEFAVORITE_BTN});
    }

    public void afterCreateNewData(EventObject e) {
        FieldEdit control;
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        IDataEntityProperty prop = this.getModel().getDataEntityType().findProperty(ISSHOWDISABLED);
        if (prop != null && param.isF7ClickByFilter()) {
            this.getModel().setValue(ISSHOWDISABLED, (Object)false);
            this.getView().getPageCache().put(ISSHOWDISABLED, "false");
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{REMOVEFAVORITE_BTN});
        Listbox listbox = (Listbox)this.getView().getControl("listboxap");
        ArrayList<ListboxItem> listboxItems = new ArrayList<ListboxItem>();
        ListboxItem node = new ListboxItem();
        node.setId(ALL_BTN);
        node.setContent(ResManager.loadKDString((String)"\u5168\u90e8", (String)"StandardF7FormPlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        listboxItems.add(node);
        node = new ListboxItem();
        node.setId(USERFAVORITE_BTN);
        node.setContent(ResManager.loadKDString((String)"\u6211\u7684\u6536\u85cf", (String)"StandardF7FormPlugin_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        listboxItems.add(node);
        listbox.addItems(listboxItems);
        if (prop != null && (control = (FieldEdit)this.getControl(ISSHOWDISABLED)) != null) {
            if (this.isRefBillF7()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{ISSHOWDISABLED});
            } else {
                control.setCaption(new LocaleString(ResManager.loadKDString((String)"\u663e\u793a\u7981\u7528", (String)"StandardF7FormPlugin_8", (String)BOS_FORM_BUSINESS, (Object[])new Object[0])));
            }
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "addfavorite_btn": {
                this.addUserFavorites();
                break;
            }
            case "removefavorite_btn": {
                this.removeUserFavorites();
                break;
            }
        }
    }

    private void addUserFavorites() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection collection = billList.getSelectedRows();
        if (collection.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"StandardF7FormPlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        UserFavoriteDAO favoriteDAO = new UserFavoriteDAO();
        UserFavorite temp = this.buildUserFavorite(0, null);
        int total = favoriteDAO.countUserFavorite(temp);
        if (total >= 1000) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u7684\u6536\u85cf\u5df2\u8fbe\u4e0a\u9650\uff0c\u8bf7\u53d6\u6d88\u90e8\u5206\u6536\u85cf\u540e\u518d\u8bd5\u3002", (String)"StandardF7FormPlugin_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        ArrayList<UserFavorite> list = new ArrayList<UserFavorite>();
        HashSet<Object> idSets = new HashSet<Object>(collection.size());
        for (ListSelectedRow row : collection) {
            if (idSets.contains(row.getPrimaryKeyValue())) continue;
            UserFavorite userFavorite = this.buildUserFavorite(0, String.valueOf(row.getPrimaryKeyValue()));
            list.add(userFavorite);
            idSets.add(row.getPrimaryKeyValue());
        }
        int count = favoriteDAO.addUserFavorites(list, total);
        UserFavorite userFavorite = this.buildUserFavorite(0, null);
        List ids = favoriteDAO.getUserFavoriteData(userFavorite);
        this.getView().getPageCache().put("dataIds", SerializationUtils.toJsonString((Object)ids));
        if (count == list.size() || count == 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6536\u85cf\u6210\u529f\u3002", (String)"StandardF7FormPlugin_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        } else {
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6210\u529f\u6536\u85cf%s\u6761\u6570\u636e\u3002", (String)"StandardF7FormPlugin_5", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), count));
        }
    }

    private void removeUserFavorites() {
        List dataIds = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("dataIds"), String.class);
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection collection = billList.getSelectedRows();
        if (collection.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"StandardF7FormPlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        ArrayList<String> fids = new ArrayList<String>();
        int idCounts = 0;
        for (ListSelectedRow row : collection) {
            String id = row.getPrimaryKeyValue().toString();
            if (dataIds.contains(id)) {
                ++idCounts;
            }
            fids.add(id);
        }
        if (idCounts == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"StandardF7FormPlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        UserFavoriteDAO favoriteDAO = new UserFavoriteDAO();
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        List list = favoriteDAO.getUserFavorites(Long.parseLong(RequestContext.get().getUserId()), param.getBillFormId(), fids);
        favoriteDAO.removeUserFavorites(list);
        UserFavorite userFavorite = this.buildUserFavorite(0, null);
        List ids = favoriteDAO.getUserFavoriteData(userFavorite);
        this.getView().getPageCache().put(ISQUERYUSERFAVORITE, "true");
        this.getView().getPageCache().put("dataIds", SerializationUtils.toJsonString((Object)ids));
        billList.bindData(null);
        if (!param.isMultiSelect()) {
            // empty if block
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6536\u85cf\u5df2\u53d6\u6d88\u3002", (String)"StandardF7FormPlugin_7", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
    }

    private void loadAllDatas() {
        this.hideOrShow(1);
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        IDataEntityProperty prop = this.getModel().getDataEntityType().findProperty(ISSHOWDISABLED);
        if (prop != null && param.isF7ClickByFilter()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ISSHOWDISABLED});
            String value = this.getView().getPageCache().get(ISSHOWDISABLED);
            this.getModel().beginInit();
            if ("true".equals(value)) {
                this.getModel().setValue(ISSHOWDISABLED, (Object)true);
            } else {
                this.getModel().setValue(ISSHOWDISABLED, (Object)false);
            }
            this.getModel().endInit();
        }
        this.getView().getPageCache().put(ISQUERYUSERFAVORITE, "false");
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.bindData(null);
        if (!param.isMultiSelect()) {
            // empty if block
        }
    }

    private void loadUserFavoriteDatas() {
        this.hideOrShow(2);
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        UserFavoriteDAO favoriteDAO = new UserFavoriteDAO();
        UserFavorite userFavorite = this.buildUserFavorite(0, null);
        List ids = favoriteDAO.getUserFavoriteData(userFavorite);
        this.getView().getPageCache().put(ISQUERYUSERFAVORITE, "true");
        this.getView().getPageCache().put("dataIds", SerializationUtils.toJsonString((Object)ids));
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.bindData(null);
        if (!param.isMultiSelect()) {
            // empty if block
        }
    }

    private void hideOrShow(int flag) {
        if (flag == 1) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ADDFAVORITE_BTN});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{REMOVEFAVORITE_BTN});
            ListView listView = (ListView)this.getView();
            if (listView.getTreeListView() != null) {
                HashMap<String, String> prop2 = new HashMap<String, String>(1);
                prop2.put("splitPosition", "200px");
                this.getView().updateControlMetadata("splitcontainerap", prop2);
            }
        } else if (flag == 2) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ADDFAVORITE_BTN});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{REMOVEFAVORITE_BTN});
            ListView listView = (ListView)this.getView();
            if (listView.getTreeListView() != null) {
                HashMap<String, String> prop2 = new HashMap<String, String>(1);
                prop2.put("splitPosition", "0%");
                this.getView().updateControlMetadata("splitcontainerap", prop2);
            }
        }
    }

    private UserFavorite buildUserFavorite(int status, String dataId) {
        UserFavorite userFavorite = new UserFavorite();
        long userId = Long.parseLong(RequestContext.get().getUserId());
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        userFavorite.setUserId(userId);
        userFavorite.setBinddingNum(param.getBillFormId());
        userFavorite.setStatus(status);
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            userFavorite.setDataId(dataId);
        }
        return userFavorite;
    }

    public void listboxClick(ListboxEvent event) {
        switch (event.getItemId()) {
            case "all_btn": {
                this.loadAllDatas();
                break;
            }
            case "userfavorite_btn": {
                this.loadUserFavoriteDatas();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        BillList billList;
        IDataEntityProperty enableProp;
        ChangeData changeData = e.getChangeSet()[0];
        Object newdata = changeData.getNewValue();
        String field = e.getProperty().getName();
        if (ISSHOWDISABLED.equals(field) && (enableProp = (billList = (BillList)this.getView().getControl(BILLLISTAP)).getEntityType().findProperty(ENABLE)) instanceof BillStatusProp) {
            if (((Boolean)newdata).booleanValue()) {
                billList.setShowDisabledData(true);
            } else {
                billList.setShowDisabledData(false);
            }
            this.getView().getPageCache().put(ISSHOWDISABLED, newdata.toString());
            billList.bindData(null);
            this.refreshTree(newdata);
        }
    }

    private void refreshTree(Object newdata) {
        IListView listView = null;
        if (this.getView() instanceof IListView) {
            listView = (IListView)this.getView();
        }
        if (listView != null && listView.getTreeListView() != null) {
            ITreeListView treeListView = listView.getTreeListView();
            TreeListModel treeListModel = (TreeListModel)treeListView.getTreeModel();
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            String treeFilterStr = pageCache.get("treeFilter");
            List<Object> qFilters = new ArrayList<QFilter>(10);
            if (!StringUtils.isBlank((CharSequence)treeFilterStr)) {
                List qFilterDto = SerializationUtils.fromJsonStringToList((String)treeFilterStr, QFilterDto.class);
                for (QFilterDto filterDto : qFilterDto) {
                    qFilters.add(QFilter.fromSerializedString((String)filterDto.getFilter()));
                }
                qFilters = qFilters.stream().filter(f -> !ENABLE.equals(f.getProperty())).collect(Collectors.toList());
            }
            if (!((Boolean)newdata).booleanValue()) {
                QFilter qFilter = new QFilter(ENABLE, "=", (Object)"1");
                qFilters.add(qFilter);
            }
            treeListModel.setTreeFilter(qFilters);
            treeListView.refreshTreeView();
        }
    }

    private boolean isRefBillF7() {
        Object callFromObj = this.getView().getFormShowParameter().getCustomParam(KEY_CALL_FROM_REF_BILL_EDIT);
        return callFromObj != null && Boolean.parseBoolean(callFromObj.toString());
    }
}

