/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.logbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.RequestContextInfo;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.IQuery;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.list.SummaryResult;
import kd.bos.entity.list.option.ListUserOption;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.list.query.impl.CountQuery;
import kd.bos.list.query.impl.ESQuery;
import kd.bos.list.query.impl.SqlQuery;
import kd.bos.list.query.impl.SumQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.logorm.datasource.dc.MCApi;
import kd.bos.mvc.list.QueryBuilderFactory;
import kd.bos.orm.query.QFilter;
import org.apache.commons.lang3.time.DateUtils;

public class ESDataProvider
implements IListDataProvider {
    private static Log log = LogFactory.getLog(ESDataProvider.class);
    public static boolean enableES = true;
    private final IFormView formView;
    private Date startDate;
    private Date endDate;
    private List<QFilter> qFilters = new ArrayList<QFilter>();
    private List<SqlParameter> param = new ArrayList<SqlParameter>();
    private IQuery query;
    private List<IDataEntityType> dataEntityTypes;
    private ListUserOption listUserOption;
    private QueryBuilder queryBuilder;
    private boolean defaultOrder;
    private boolean isNeedResumFlag;
    private String orderByExpr;
    private List<ListField> listFields = new ArrayList<ListField>();
    private List<ListField> pkFields = new ArrayList<ListField>();
    private List<ListField> keyFields = new ArrayList<ListField>();
    private EntityType entityType;
    private List<ListField> visibleSelectFieldList = new ArrayList<ListField>();
    private boolean isCustomListDataProviderFlag;
    private int maxReturnData;
    private String search;

    public ESDataProvider(IFormView formView) {
        this.formView = formView;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    private IQuery getQuery() {
        if (enableES) {
            if (this.query == null || this.query != null && !(this.query instanceof ESQuery)) {
                this.query = new ESQuery();
            }
            return this.query;
        }
        if (this.query == null || this.query != null && !(this.query instanceof SqlQuery)) {
            this.query = new SqlQuery();
        }
        return this.query;
    }

    public void setDefaultOrder(boolean defaultOrder) {
        this.defaultOrder = defaultOrder;
    }

    public QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    public void setQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    public void setListUserOption(ListUserOption listUserOption) {
        this.listUserOption = listUserOption;
    }

    public List<IDataEntityType> getDataEntityTypes() {
        return this.dataEntityTypes;
    }

    public void setDataEntityTypes(List<IDataEntityType> dataEntityTypes) {
        this.dataEntityTypes = dataEntityTypes;
    }

    public void setParam(List<SqlParameter> param) {
        this.param = param;
    }

    public String getOrderByExpr() {
        return this.orderByExpr;
    }

    public void setOrderByExpr(String orderByExpr) {
        this.orderByExpr = orderByExpr;
    }

    public void addQFilters(QFilter qFilter) {
        this.qFilters.add(qFilter);
    }

    public List<QFilter> getQFilters() {
        return this.qFilters;
    }

    public void setQFilters(List<QFilter> qFilters) {
        this.qFilters = qFilters;
    }

    public List<ListField> getListFields() {
        return this.listFields;
    }

    public void setListFields(List<ListField> listFields) {
        this.listFields = listFields;
    }

    public List<ListField> getPKFields() {
        return this.pkFields;
    }

    public void setPKFields(List<ListField> pkFields) {
        this.pkFields = pkFields;
    }

    public List<ListField> getKeyFields() {
        return this.keyFields;
    }

    public void setKeyFields(List<ListField> keyFields) {
        this.keyFields = keyFields;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public QueryResult getQueryResult() {
        return this.getQuery().getQueryResult();
    }

    public List<ListField> getVisibleSelectFieldList() {
        return this.visibleSelectFieldList;
    }

    public void setVisibleSelectFieldList(List<ListField> visibleSelectFieldList) {
        this.visibleSelectFieldList = visibleSelectFieldList;
    }

    public ListUserOption getListUserOption() {
        return this.listUserOption;
    }

    public boolean isNeedResum() {
        return this.isNeedResumFlag;
    }

    public boolean isCustomListDataProvider() {
        return this.isCustomListDataProviderFlag;
    }

    public void setCustomListDataProvider(boolean isCustomListDataProvider) {
        this.isCustomListDataProviderFlag = isCustomListDataProvider;
    }

    public DynamicObjectCollection getData(int start, int limit) {
        this.queryBuilder = QueryBuilderFactory.createQueryBuilder((IListDataProvider)this, (int)start, (int)limit, (boolean)false, (boolean)true, (boolean)this.defaultOrder);
        List<QFilter> list = this.getLogFilter();
        QFilter[] filters = this.queryBuilder.getFilters();
        list.addAll(Arrays.asList(filters));
        this.queryBuilder.setFilters(list.toArray(new QFilter[0]));
        if (log.isInfoEnabled()) {
            log.info("ESDataProvider getData filter : " + Arrays.asList(this.queryBuilder.getFilters()));
        }
        try {
            return this.getQuery().getData(this.queryBuilder);
        }
        catch (KDException e) {
            log.error((Throwable)e);
            if (e.getErrorCode() == BosErrorCode.logormWarn) {
                this.formView.showTipNotification(e.getMessage());
            } else if (e.getErrorCode() == BosErrorCode.logorm) {
                this.formView.showErrMessage(e.getMessage(), "Elastic Error");
            } else {
                throw e;
            }
            return new DynamicObjectCollection();
        }
    }

    private List<QFilter> getLogFilter() {
        QFilter filterStart;
        ArrayList<QFilter> list = new ArrayList<QFilter>(16);
        if (this.startDate != null) {
            filterStart = new QFilter("opdate", ">=", (Object)this.startDate);
            list.add(filterStart);
        }
        if (this.endDate != null) {
            filterStart = new QFilter("opdate", "<", (Object)DateUtils.addSeconds((Date)this.endDate, (int)1));
            list.add(filterStart);
        }
        if (StringUtils.isNotBlank((CharSequence)this.search)) {
            List searchMapList = (List)SerializationUtils.fromJsonString((String)this.search, List.class);
            ArrayList<QFilter> searchFilter = new ArrayList<QFilter>(10);
            for (Map map : searchMapList) {
                QFilter filter = null;
                for (String fieldName : (List)map.get("fieldName")) {
                    for (String value : (List)map.get("value")) {
                        QFilter qFilter = new QFilter(fieldName, "like", (Object)("%" + value + "%"));
                        if (filter == null) {
                            filter = qFilter;
                            continue;
                        }
                        filter.or(qFilter);
                    }
                }
                searchFilter.add(filter);
            }
            list.addAll(searchFilter);
        }
        return list;
    }

    @Deprecated
    public int getDataCount() {
        return 0;
    }

    public int getMaxReturnData() {
        return this.maxReturnData;
    }

    public void setMaxReturnData(int maxReturnData) {
        this.maxReturnData = maxReturnData;
    }

    public int getMaxCount() {
        return this.getESDataCount();
    }

    public int getBillDataCount() {
        return this.getESDataCount();
    }

    public List<SummaryResult> getSummaryResults() {
        List<QFilter> list = this.getLogFilter();
        QFilter[] filters = this.queryBuilder.getFilters();
        list.addAll(Arrays.asList(filters));
        this.queryBuilder.setFilters(list.toArray(new QFilter[0]));
        RequestContextInfo rc = RequestContextInfo.get();
        String tenantId = rc.getTenantId();
        String accountId = rc.getAccountId();
        if (MCApi.create().enableElastic(tenantId, accountId)) {
            return Collections.emptyList();
        }
        return SumQuery.getSummaryResults((QueryBuilder)this.queryBuilder);
    }

    public int getRealCount() {
        return this.getESDataCount();
    }

    private int getESDataCount() {
        if (this.getQuery() instanceof SqlQuery) {
            return CountQuery.getCount((QueryBuilder)this.queryBuilder);
        }
        LogORM logORM = LogORM.create();
        List<QFilter> list = this.getLogFilter();
        list.addAll(this.getQFilters());
        try {
            long count = logORM.count(this.getEntityType().getName(), list.toArray(new QFilter[0]));
            return (int)count;
        }
        catch (KDException e) {
            log.error((Throwable)e);
            if (e.getErrorCode() != BosErrorCode.logormWarn && e.getErrorCode() != BosErrorCode.logorm) {
                throw e;
            }
            return 0;
        }
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public String getSearch() {
        return this.search;
    }
}

