/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.logbill;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.RequestContextInfo;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.logbill.ESDataProvider;
import kd.bos.id.ID;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.logorm.datasource.dc.MCApi;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.lang3.time.DateUtils;

@SdkPublic
public class LogBillListPlugin
extends AbstractListPlugin
implements SearchEnterListener {
    private static final Log log = LogFactory.getLog(LogBillListPlugin.class);
    public static final String DT_START = "dtstart";
    public static final String DT_END = "dtend";
    public static final String SEARCHFIELDS = "txtsearchfields";
    public static final String BT_NVIEW = "btnview";
    public static final String TODAY = "today";
    public static final String WEEK = "week";
    public static final String MONTH = "month";
    public static final String THREEMONTH = "threemonth";
    public static final String CMB_TIME = "cmbtime";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    public static final String TXT_INIT = "txtinit";
    public static final String NO_INIT = "0";
    private static Set<String> standardColumns = new HashSet<String>(8);
    private boolean canDoRefresh = false;

    public void registerListener(EventObject e) {
        Search searchap;
        super.registerListener(e);
        Control ctl = this.getView().getControl("searchap");
        if (ctl instanceof Search && (searchap = (Search)this.getView().getControl("searchap")) != null) {
            searchap.addEnterListener((SearchEnterListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        if (!"bos_loglist".equals(this.getView().getFormShowParameter().getFormId())) {
            return;
        }
        if (searchEnterEvent.getSearchFields() == null) {
            this.getModel().setValue(SEARCHFIELDS, (Object)"");
        } else {
            this.getModel().setValue(SEARCHFIELDS, (Object)SerializationUtils.toJsonString((Object)searchEnterEvent.getSearchFields()));
        }
        this.getView().invokeOperation("refresh");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object value;
        if (CMB_TIME.equals(e.getProperty().getName()) && (value = this.getModel().getValue(e.getProperty().getName())) != null && StringUtils.isNotBlank((Object)value)) {
            if ("custom".equals(value)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{DT_START, DT_END, "labelap"});
                return;
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{DT_START, DT_END, "labelap"});
            Date start = null;
            Date end = null;
            if (StringUtils.isNumeric((CharSequence)((String)value))) {
                int interval = Integer.parseInt((String)value);
                end = interval < 60 ? DateUtils.truncate((Date)new Date(), (int)12) : DateUtils.truncate((Date)new Date(), (int)10);
                start = KDDateUtils.addMinutes((Date)end, (int)(-1 * interval));
            } else {
                if (TODAY.equals(value)) {
                    end = start = KDDateUtils.today();
                }
                if (WEEK.equals(value)) {
                    start = KDDateUtils.getTheWeekStart((int)0);
                    end = DateUtils.addDays((Date)start, (int)6);
                }
                if (MONTH.equals(value)) {
                    start = KDDateUtils.getTheMonthStart((int)0);
                    end = DateUtils.addDays((Date)DateUtils.addMonths((Date)start, (int)1), (int)-1);
                }
                if (THREEMONTH.equals(value)) {
                    end = DateUtils.truncate((Date)new Date(), (int)5);
                    start = DateUtils.addMonths((Date)end, (int)-3);
                }
                if (start == null) {
                    throw new KDException(BosErrorCode.bOS, new Object[]{String.format("error:%s", value)});
                }
                end = this.getEndDays(end);
            }
            this.canDoRefresh = false;
            this.getModel().setValue(DT_START, (Object)start);
            this.getModel().setValue(DT_END, (Object)end);
            this.getView().invokeOperation("refresh");
            this.canDoRefresh = true;
        }
        if (DT_START.equals(e.getProperty().getName()) || DT_END.equals(e.getProperty().getName())) {
            Date start = (Date)this.getModel().getValue(DT_START);
            Date end = (Date)this.getModel().getValue(DT_END);
            if (end != null && start != null) {
                if (!this.isValidateDateRange(start, end, e.getProperty().getName())) {
                    return;
                }
                this.canDoRefresh = true;
            }
            if (this.canDoRefresh) {
                this.getView().invokeOperation("refresh");
            }
        }
    }

    private boolean isValidateDateRange(Date start, Date end, String propName) {
        if ("custom".equals(this.getModel().getValue(CMB_TIME))) {
            if (DT_START.equals(propName) && start.after(end)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d77\u59cb\u65f6\u95f4\u9700\u8981\u5c0f\u4e8e\u7ed3\u675f\u65f6\u95f4\u3002", (String)"LogBillListPlugin_5", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                return false;
            }
            if (DT_END.equals(propName) && end.before(start)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u9700\u8981\u5927\u4e8e\u8d77\u59cb\u65f6\u95f4\u3002", (String)"LogBillListPlugin_6", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                return false;
            }
            if (!this.isValidThreeMonth(start, end)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u65f6\u95f4\u67e5\u8be2\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc73\u4e2a\u6708\u3002", (String)"LogBillListPlugin_7", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate && "refresh".equals((operate = (FormOperate)args.getSource()).getOperateKey()) && this.getModel().getProperty(DT_START) != null) {
            Date start = (Date)this.getModel().getValue(DT_START);
            Date end = (Date)this.getModel().getValue(DT_END);
            if (start != null && end != null) {
                if (end.before(start)) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u9700\u8981\u5927\u4e8e\u8d77\u59cb\u65f6\u95f4\u3002", (String)"LogBillListPlugin_6", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                    return;
                }
                if ("custom".equals(this.getModel().getValue(CMB_TIME)) && !this.isValidThreeMonth(start, end)) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u65f6\u95f4\u67e5\u8be2\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc73\u4e2a\u6708\u3002", (String)"LogBillListPlugin_7", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                    return;
                }
            }
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d...", (String)"LogBillListPlugin_8", (String)BOS_FORM_BUSINESS, (Object[])new Object[0])));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        FormOperate operate;
        super.afterDoOperation(args);
        if (args.getSource() instanceof FormOperate && "refresh".equals((operate = (FormOperate)args.getSource()).getOperateKey())) {
            this.getView().hideLoading();
        }
    }

    private boolean isValidThreeMonth(Date start, Date end) {
        return !this.getEndDays(DateUtils.addMonths((Date)start, (int)3)).before(end);
    }

    private Date getEndDays(Date date) {
        date = DateUtils.truncate((Date)date, (int)5);
        date = KDDateUtils.addDays((Date)date, (int)1);
        date = KDDateUtils.addMilliseconds((Date)date, (int)-1);
        return date;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        ESDataProvider esDataProvider = new ESDataProvider(this.getView());
        Date dtstart = null;
        Date dtend = null;
        String search = "";
        if (this.getModel().getProperty(DT_START) != null) {
            dtstart = (Date)this.getModel().getValue(DT_START);
        }
        if (this.getModel().getProperty(DT_END) != null) {
            dtend = (Date)this.getModel().getValue(DT_END);
        }
        if (this.getModel().getProperty(SEARCHFIELDS) != null) {
            search = (String)this.getModel().getValue(SEARCHFIELDS);
        }
        if (this.getModel().getProperty(CMB_TIME) != null && TODAY.equals(this.getModel().getValue(CMB_TIME))) {
            dtstart = KDDateUtils.today();
            dtend = this.getEndDays(dtstart);
            this.getModel().setValue(DT_END, (Object)dtend);
            this.getModel().setValue(DT_START, (Object)dtstart);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{DT_START, DT_END, "labelap"});
        }
        esDataProvider.setStartDate(dtstart);
        esDataProvider.setEndDate(dtend);
        esDataProvider.setSearch(search);
        args.setListDataProvider((IListDataProvider)esDataProvider);
    }

    public void itemClick(ItemClickEvent evt) {
        Object billId;
        super.itemClick(evt);
        if (evt.getItemKey().equals(BT_NVIEW) && (billId = this.getFocusRowPkId()) != null) {
            this.actionShowBill(String.valueOf(billId));
        }
        if ("btnenable".equals(evt.getItemKey())) {
            ESDataProvider.enableES = !ESDataProvider.enableES;
            Button button = (Button)this.getView().getControl("btnenable");
            HashMap<String, String> args = new HashMap<String, String>();
            HashMap<String, HashMap<String, String>> map = new HashMap<String, HashMap<String, String>>();
            args.put("zh_CN", ESDataProvider.enableES ? "ES" : "DB");
            map.put("caption", args);
            this.getView().updateControlMetadata("btnenable", map);
        }
        if ("btntest".equals(evt.getItemKey()) && ESDataProvider.enableES) {
            LogORM logORM = LogORM.create();
            for (int i = 0; i < 1000; ++i) {
                DynamicObject data = new DynamicObject((DynamicObjectType)((ListView)this.getView()).getListModel().getDataEntityType());
                data.set("opname", (Object)String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u540d\u79f0%s", (String)"LogBillListPlugin_9", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), i));
                data.set("opdesc", (Object)String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u63cf\u8ff0%s", (String)"LogBillListPlugin_10", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), i));
                data.set("opdate", (Object)new Date());
                data.set("username", (Object)String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u4eba%s", (String)"LogBillListPlugin_11", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), i));
                ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
                list.add(data);
                data.set("id", (Object)ID.genLongId());
                logORM.insert(list);
            }
            this.getView().showMessage(ResManager.loadKDString((String)"\u751f\u6210\u6570\u636e\u5b8c\u6bd5.", (String)"LogBillListPlugin_12", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    private void actionShowBill(String billId) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(((IListView)this.getView()).getBillFormId());
        parameter.setPkId((Object)billId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setBillStatus(BillOperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        RequestContextInfo rc = RequestContextInfo.get();
        String tenantId = rc.getTenantId();
        String accountId = rc.getAccountId();
        List columns = args.getListColumns();
        for (IListColumn column : columns) {
            column.setColumnOrder(false);
            if (!MCApi.create().enableElastic(tenantId, accountId) || !(column instanceof DecimalListColumn)) continue;
            ((DecimalListColumn)column).setSummary(0);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
        dataMap.put("k", "filtercontainerap");
        dataMap.put("useOrReplaceBlank", false);
        proxy.addAction("u", dataMap);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        Object billId = this.getFocusRowPkId();
        if (billId != null) {
            this.actionShowBill(String.valueOf(billId));
            e.setCancel(true);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        Object billId = this.getFocusRowPkId();
        if (billId != null) {
            if (standardColumns.contains(args.getFieldName())) {
                this.actionShowBill(String.valueOf(billId));
            } else if (log.isDebugEnabled()) {
                log.debug("{} is not standardColumns. billListHyperLinkClick ", (Object)args.getFieldName());
            }
            args.setCancel(true);
        }
    }

    public void setFilter(SetFilterEvent e) {
        List qfilters = e.getQFilters();
        if (!this.check(qfilters)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u65f6\u95f4\u67e5\u8be2\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc7%d\u4e2a\u6708\u3002", (String)"LogBillListPlugin_13", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), 3));
        }
    }

    private boolean check(List<QFilter> qfilters) {
        int intervalMonth = 3;
        boolean checkResult = true;
        if (qfilters == null || qfilters.isEmpty()) {
            return true;
        }
        String operateTimeFieldName = "opdate";
        for (QFilter filter : qfilters) {
            if (!operateTimeFieldName.equals(filter.getProperty())) continue;
            String filterStr = filter.toString();
            List qfilterNests = filter.getNests(true);
            if (qfilterNests == null || qfilterNests.isEmpty()) continue;
            String startTime = null;
            String endTime = null;
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            startTime = filterStr.substring(0, filterStr.indexOf(39));
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            endTime = filterStr.substring(0, filterStr.indexOf(39));
            try {
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                LocalDateTime start = LocalDateTime.parse(startTime, dateTimeFormatter);
                LocalDateTime end = LocalDateTime.parse(endTime, dateTimeFormatter);
                long duration = ChronoUnit.DAYS.between(start, end);
                if (duration > (long)(intervalMonth * 31)) {
                    checkResult = false;
                    continue;
                }
                checkResult = true;
            }
            catch (Exception px) {
                return checkResult;
            }
        }
        return checkResult;
    }

    static {
        standardColumns.add("username");
        standardColumns.add("opname");
        standardColumns.add("opdesc");
        standardColumns.add("opdate");
    }
}

