/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.mulilang;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;

public class GLDataRepairPlugin
extends AbstractFormPlugin
implements IConfirmCallBack {
    private static final String KEY_FIELDKEY = "fieldkey";
    private static final String KEY_FIELDNAME = "fieldname";
    private static final String KEY_ISHEADFIELD = "isheadfield";
    private static final String KEY_ENTRYKEY = "entrykey";
    private static final String KEY_FIELDTYPE = "fieldType";
    private static final String KEY_GL = "isgl";
    private static final String KEY_FORMNUMBER = "formnumber";
    private static final String KEY_BIZOBJECT = "bizobject";
    private static final String ACTID_REPAIRCONFIRM = "repairconfirm";
    private static final String ENTRYENTITY = "entryentity";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"toolbarap"});
        this.addItemClickListeners(new String[]{"btn_repair"});
        this.addItemClickListeners(new String[]{"btn_scan"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldId = e.getProperty().getName();
        if (KEY_BIZOBJECT.equals(fieldId)) {
            this.listField();
        }
    }

    private void listField() {
        this.getModel().deleteEntryData(ENTRYENTITY);
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(KEY_BIZOBJECT);
        if (dynamicObject == null) {
            return;
        }
        String number = dynamicObject.getString("number");
        if (StringUtils.isBlank((CharSequence)number)) {
            return;
        }
        String fid = MetadataDao.getIdByNumber((String)number, (MetaCategory)MetaCategory.Entity);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)fid, (MetaCategory)MetaCategory.Entity);
        IDataModel model = this.getModel();
        for (EntityItem entityItem : entityMetadata.getRootEntity().getItems()) {
            if (entityItem instanceof EntryEntity) {
                EntryEntity entry = (EntryEntity)entityItem;
                for (EntityItem item : entry.getItems()) {
                    if (!(item instanceof MuliLangTextField)) continue;
                    int row = model.createNewEntryRow(ENTRYENTITY);
                    model.setValue(KEY_FIELDKEY, (Object)item.getKey(), row);
                    model.setValue(KEY_FIELDNAME, (Object)item.getName(), row);
                    model.setValue(KEY_ISHEADFIELD, (Object)false, row);
                    model.setValue(KEY_FIELDTYPE, (Object)item.getClass().getName().substring(item.getClass().getName().lastIndexOf(".") + 1), row);
                    model.setValue(KEY_ENTRYKEY, (Object)entry.getKey(), row);
                    model.setValue(KEY_GL, (Object)((MuliLangTextField)item).isGL(), row);
                }
                continue;
            }
            if (!(entityItem instanceof MuliLangTextField)) continue;
            int row = model.createNewEntryRow(ENTRYENTITY);
            model.setValue(KEY_FIELDKEY, (Object)entityItem.getKey(), row);
            model.setValue(KEY_FIELDNAME, (Object)entityItem.getName(), row);
            model.setValue(KEY_ISHEADFIELD, (Object)true, row);
            model.setValue(KEY_FIELDTYPE, (Object)entityItem.getClass().getName().substring(entityItem.getClass().getName().lastIndexOf(".") + 1), row);
            model.setValue(KEY_GL, (Object)((MuliLangTextField)entityItem).isGL(), row);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"close", (CharSequence)operate.getOperateKey())) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        int row = entryGrid.getEntryState().getFocusRow();
        String fieldKey = (String)this.getModel().getValue(KEY_FIELDKEY, row);
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(KEY_BIZOBJECT);
        String formNumber = dynamicObject.getString("number");
        HashMap<String, String> callbackValue = new HashMap<String, String>();
        callbackValue.put(KEY_FIELDKEY, fieldKey);
        callbackValue.put(KEY_FORMNUMBER, formNumber);
        boolean isGl = (Boolean)this.getModel().getValue(KEY_GL, row);
        if (isGl) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ACTID_REPAIRCONFIRM, (IConfirmCallBack)this);
            this.getView().showConfirm("ensure repair  data", null, MessageBoxOptions.OKCancel, null, confirmCallBacks, null, SerializationUtils.toJsonString(callbackValue));
        } else {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("showmessage", (IConfirmCallBack)this);
            this.getView().showConfirm("field disable gl property", MessageBoxOptions.OKCancel, confirmCallBacks);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (ACTID_REPAIRCONFIRM.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            Map value = (Map)SerializationUtils.fromJsonString((String)messageBoxClosedEvent.getCustomVaule(), Map.class);
            this.repairBlankData((String)value.get(KEY_FORMNUMBER), (String)value.get(KEY_FIELDKEY));
        }
    }

    private void repairBlankData(String entityNum, String fieldKey) {
        if (StringUtils.isBlank((CharSequence)entityNum) || StringUtils.isBlank((CharSequence)fieldKey)) {
            return;
        }
        String entityId = MetadataDao.getIdByNumber((String)entityNum, (MetaCategory)MetaCategory.Entity);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        List entitys = entityMetadata.getEntitys();
        String tableName = null;
        String fieldName = null;
        String pkField = null;
        for (Entity entity : entitys) {
            List items = entity.getItems();
            for (EntityItem item : items) {
                if (!(item instanceof MuliLangTextField) || !fieldKey.equalsIgnoreCase(item.getKey())) continue;
                tableName = entityMetadata.getFieldByKey(item.getKey()).getTableName(entity);
                fieldName = entityMetadata.getFieldByKey(item.getKey()).getFieldName();
                if (entity instanceof EntryEntity) {
                    pkField = ((EntryEntity)entity).getEntryPkFieldName();
                    continue;
                }
                if (!(entity instanceof BillEntity)) continue;
                pkField = ((BillEntity)entity).getPkFieldName();
            }
        }
        if (StringUtils.isBlank(tableName) || StringUtils.isBlank(fieldName) || StringUtils.isBlank(pkField)) {
            return;
        }
        String sql = String.format("select %s , %s from %s where flocaleid = ? ", pkField, fieldName, tableName + "_L");
        String updateSql = String.format(" update %s set %s = ? where %s= ? and ( %s is null or %s  = '' or %s = ' ' )", tableName, fieldName, pkField, fieldName, fieldName, fieldName);
        Object[] query = new Object[]{new SqlParameter(":flocaleid", 12, (Object)RequestContext.get().getLang().toString())};
        DBRoute dbroute = DBRoute.of((String)entityMetadata.getDBRouteKey());
        try (DataSet ds = (DataSet)DB.queryAlone(() -> DB.queryDataSet((String)"gldatarepairplugin", (DBRoute)dbroute, (String)sql, (Object[])query));){
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(10);
            while (ds.hasNext()) {
                Row row = ds.next();
                Object pkId = row.get(0);
                Object[] paras = new Object[]{row.get(1), pkId};
                paramsList.add(paras);
                if (paramsList.size() != 1000) continue;
                DB.executeBatch((DBRoute)dbroute, (String)updateSql, paramsList);
            }
            if (!paramsList.isEmpty()) {
                DB.executeBatch((DBRoute)dbroute, (String)updateSql, paramsList);
            }
        }
    }
}

