/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.nameversion;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.nameversion.NameVersionEntry;
import kd.bos.entity.nameversion.NameVersionService;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BaseDataNameVersionListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(BaseDataNameVersionListPlugin.class);
    protected String nameProperty = "";
    protected Date versionControlDate = null;
    protected boolean enableNameVersion = false;
    protected String billEntityTypeId = "";

    public void initialize() {
        super.initialize();
        String formId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        this.billEntityTypeId = FormMetadataCache.getFormConfig((String)formId).getEntityTypeId();
        this.enableNameVersion = NameVersionService.getInstance().enableNameVersionControl(this.billEntityTypeId);
        BasedataEntityType entityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)this.billEntityTypeId);
        this.nameProperty = entityType.getNameProperty();
        String date = (String)this.getView().getFormShowParameter().getCustomParam("versioncontrol");
        if (StringUtils.isNotBlank((CharSequence)date)) {
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                this.versionControlDate = sf.parse(date);
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (this.versionControlDate == null || StringUtils.isEmpty((CharSequence)this.nameProperty)) {
            this.enableNameVersion = false;
        }
    }

    public void listRowFilter(ListRowFilterEvent args) {
        super.listRowFilter(args);
        if (!this.enableNameVersion) {
            return;
        }
        CompareTypeEnum compareTypeEnum = args.getCurrentListColumnFilter().getCompareTypeEnum();
        if (compareTypeEnum == null) {
            return;
        }
        if (args.getCurrentListColumnFilter().getFieldName().equals(this.nameProperty)) {
            if (compareTypeEnum.equals((Object)CompareTypeEnum.ISNULL) || compareTypeEnum.equals((Object)CompareTypeEnum.ISNOTNULL)) {
                return;
            }
            if (compareTypeEnum.equals((Object)CompareTypeEnum.NOTLIKE) || compareTypeEnum.equals((Object)CompareTypeEnum.NOTEQUAL)) {
                return;
            }
            String value = args.getCurrentListColumnFilter().getValue();
            Map<Object, DynamicObject> data = this.getBaseData(compareTypeEnum, value);
            if (!data.isEmpty()) {
                data.forEach((k, v) -> args.addListColumnFilter(this.nameProperty, v.get(this.nameProperty).toString()));
            }
        }
    }

    protected Map<Object, DynamicObject> getBaseData(CompareTypeEnum compareTypeEnum, String nameVersionValue) {
        NameVersionEntry[] nameVersionEntries = NameVersionService.getInstance().getContainNameByDate(this.billEntityTypeId, this.versionControlDate, compareTypeEnum, nameVersionValue);
        if (nameVersionEntries == null) {
            return new HashMap<Object, DynamicObject>();
        }
        HashSet<String> selectFieldSet = new HashSet<String>();
        selectFieldSet.add(this.nameProperty);
        DynamicObjectType type = EntityMetadataCache.getSubDataEntityType((String)this.billEntityTypeId, selectFieldSet);
        Object[] pkList = new Object[nameVersionEntries.length];
        int i = 0;
        for (NameVersionEntry data : nameVersionEntries) {
            pkList[i++] = data.getId();
        }
        return BusinessDataReader.loadFromCache((Object[])pkList, (DynamicObjectType)type);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        if (!this.enableNameVersion) {
            return;
        }
        block0: for (Map fastFilterValue : args.getSearchClickEvent().getFastFilterValues()) {
            List nameList = (List)fastFilterValue.get("FieldName");
            if (nameList == null) continue;
            boolean existsName = false;
            for (Object o : nameList) {
                if (!o.equals(this.nameProperty)) continue;
                existsName = true;
                break;
            }
            if (!existsName) continue;
            List valueList = (List)fastFilterValue.get("Value");
            HashSet newList = new HashSet(16);
            for (Object o : valueList) {
                Map<Object, DynamicObject> mapData = this.getBaseData(CompareTypeEnum.LIKE, o.toString());
                mapData.forEach((k, v) -> {
                    String name = v.get(this.nameProperty).toString();
                    if (!name.contains(o.toString())) {
                        newList.add(v.get(this.nameProperty).toString());
                    }
                });
            }
            if (newList.isEmpty()) continue;
            int maxLikeLimits = Integer.getInteger("listQuery.maxLikeLimits", 5);
            maxLikeLimits = Math.min(maxLikeLimits, 100);
            for (String o : newList) {
                if (valueList.size() >= maxLikeLimits) {
                    logger.info("new value list can't be add to valuelist. listQuery.maxLikeLimits {},{},{}", new Object[]{maxLikeLimits, newList, valueList});
                    continue block0;
                }
                valueList.add(o);
            }
        }
    }

    public void packageData(PackageDataEvent e) {
        NameVersionEntry entry;
        AbstractColumnDesc source;
        super.packageData(e);
        if (this.enableNameVersion && this.versionControlDate != null && StringUtils.isNotBlank((CharSequence)this.nameProperty) && (source = (AbstractColumnDesc)e.getSource()).getKey().equals(this.nameProperty) && (entry = this.getNameVersionEntry(e.getRowData().getPkValue())) != null) {
            e.getRowData().set(this.nameProperty, (Object)entry.getName().getLocaleValue());
            e.setFormatValue((Object)entry.getName().getLocaleValue());
        }
    }

    protected NameVersionEntry getNameVersionEntry(Object pkValue) {
        return NameVersionService.getInstance().getNameByDate(this.billEntityTypeId, pkValue, this.versionControlDate);
    }
}

