/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.nameversion;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.nameversion.NameVersionEntry;
import kd.bos.entity.nameversion.NameVersionService;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;

public class BillNameVersionListPlugin
extends AbstractListPlugin {
    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        for (Map fastFilterValue : args.getFastFilterValues()) {
            List fieldName = (List)fastFilterValue.get("FieldName");
            List value = (List)fastFilterValue.get("Value");
            this.addNameVersionValue(fieldName, value);
        }
    }

    public void listRowFilter(ListRowFilterEvent args) {
        super.listRowFilter(args);
        CompareTypeEnum compareTypeEnum = args.getCurrentListColumnFilter().getCompareTypeEnum();
        if (compareTypeEnum == null) {
            return;
        }
        String[] split = args.getCurrentListColumnFilter().getFieldName().split("_");
        if (split.length != 2) {
            return;
        }
        if (compareTypeEnum.equals((Object)CompareTypeEnum.ISNULL) || compareTypeEnum.equals((Object)CompareTypeEnum.ISNOTNULL)) {
            return;
        }
        if (compareTypeEnum.equals((Object)CompareTypeEnum.NOTLIKE) || compareTypeEnum.equals((Object)CompareTypeEnum.NOTEQUAL)) {
            return;
        }
        String fieldName = split[0];
        String nameProperty = split[1];
        IDataEntityType baseDataType = this.getBaseDataTypeWithName(fieldName, nameProperty);
        if (baseDataType == null) {
            return;
        }
        String value = args.getCurrentListColumnFilter().getValue();
        Map<Object, DynamicObject> data = this.getBaseData(baseDataType.getName(), compareTypeEnum, value, nameProperty);
        if (!data.isEmpty()) {
            data.forEach((k, v) -> args.addListColumnFilter(fieldName + "." + nameProperty, v.get(nameProperty).toString()));
        }
    }

    private void addNameVersionValue(List<Object> fieldNameList, List<Object> valueList) {
        for (Object o : fieldNameList) {
            String nameProp;
            String baseFieldName;
            IDataEntityType baseDataType;
            String fieldName = (String)o;
            String[] split = fieldName.split("\\.");
            if (split.length != 2 || (baseDataType = this.getBaseDataTypeWithName(baseFieldName = split[0], nameProp = split[1])) == null) continue;
            ArrayList<String> newValueList = new ArrayList<String>();
            for (Object value : valueList) {
                Map<Object, DynamicObject> nameData = this.getBaseData(baseDataType.getName(), CompareTypeEnum.LIKE, value.toString(), nameProp);
                for (Map.Entry<Object, DynamicObject> keyValue : nameData.entrySet()) {
                    newValueList.add(keyValue.getValue().get(nameProp).toString());
                }
            }
            if (newValueList.isEmpty()) continue;
            valueList.addAll(newValueList);
        }
    }

    private IDataEntityType getBaseDataTypeWithName(String fieldName, String nameProp) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.getEntityTypeId());
        IDataEntityProperty property = dataEntityType.findProperty(fieldName);
        if (property != null) {
            String nameProperty;
            IDataEntityType basedataEntityType = null;
            if (property instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)property;
                basedataEntityType = basedataProp.getComplexType();
            } else if (property instanceof MulBasedataProp) {
                MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
                basedataEntityType = mulBasedataProp.getComplexType();
            } else {
                return null;
            }
            if (basedataEntityType instanceof BasedataEntityType && nameProp.equals(nameProperty = ((BasedataEntityType)basedataEntityType).getNameProperty())) {
                return basedataEntityType;
            }
        }
        return null;
    }

    private Map<Object, DynamicObject> getBaseData(String entityTypeId, CompareTypeEnum compareTypeEnum, String nameVersionValue, String nameProp) {
        NameVersionEntry[] nameVersionEntries = NameVersionService.getInstance().getAllContainName(entityTypeId, compareTypeEnum, nameVersionValue);
        if (nameVersionEntries == null) {
            return new HashMap<Object, DynamicObject>();
        }
        HashSet<String> fieldSet = new HashSet<String>();
        fieldSet.add(nameProp);
        DynamicObjectType type = EntityMetadataCache.getSubDataEntityType((String)entityTypeId, fieldSet);
        Object[] pkList = new Object[nameVersionEntries.length];
        int i = 0;
        for (NameVersionEntry data : nameVersionEntries) {
            pkList[i++] = data.getId();
        }
        return BusinessDataReader.loadFromCache((Object[])pkList, (DynamicObjectType)type);
    }

    private String getEntityTypeId() {
        String formId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        return FormMetadataCache.getFormConfig((String)formId).getEntityTypeId();
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
    }
}

