/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.report;

import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportException;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.schedule.api.TaskInfo;

public class ReportExportCallBack
implements ICloseCallBack {
    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getView() == null) {
            return;
        }
        if (e.getReturnData() == null) {
            return;
        }
        Map returnData = (Map)e.getReturnData();
        if (!returnData.containsKey("taskinfo")) {
            return;
        }
        String str = (String)returnData.get("taskinfo");
        if (StringUtils.isBlank((CharSequence)str)) {
            return;
        }
        TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)str, TaskInfo.class);
        this.downloadFile(e.getView(), taskInfo);
    }

    private void downloadFile(IFormView view, TaskInfo taskInfo) {
        String strData = taskInfo.getData();
        if (StringUtils.isBlank((CharSequence)strData)) {
            return;
        }
        Map data = (Map)SerializationUtils.fromJsonString((String)strData, Map.class);
        String url = (String)data.get("downloadurl");
        if (StringUtils.isNotBlank((CharSequence)url)) {
            view.download(url);
        }
        Object messageType = data.get("messageType");
        Object message = data.get("message");
        if (messageType != null && message != null) {
            if (Integer.parseInt(messageType.toString()) == ReportException.ShowType.SHOW_NOTIFICATION_MSG.getType()) {
                view.showErrorNotification(message.toString());
            } else if (Integer.parseInt(messageType.toString()) == ReportException.ShowType.SHOW_MESSAGE.getType()) {
                view.showMessage(message.toString());
            }
        }
    }
}

