/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.report;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.report.ReportException;
import kd.bos.entity.report.ReportTaskParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.report.ReportExportCallBack;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.report.ReportView;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;

public class ReportExportProgressFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    public static final String FORMID_EXPORTDATAPROGRESS = "bos_reportexportprogress";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    public static final String CUSTPARAM_CONTEXT = "requestcontext";
    public static final String CUSTPARAM_ENTITYNAME = "entityname";
    public static final String CUSTPARAM_ENTITYNUMBER = "entitynumber";
    private static final String BACKGROUND_ACTIONID = "background_actionid";
    public static final String CACHEKEY_TASKID = "export_taskid";
    public static final String CACHEKEY_JOBFORMINFO = "export_jobforminfo";
    private static final String KEY_BILLNAME = "listname";
    private static final String KEY_TOTAL = "total";
    private static final String KEY_COMPLETE = "complete";
    private static final String KEY_INITTIPS = "inittips";
    private static final String KEY_PROGRESSDATAS = "progressdatas";
    private static final String KEY_PROGRESSBAR = "progressbarap";
    private static final String CACHEKEY_ISSTART = "isstart";
    private static final String CACHEKEY_ISFINISHED = "isfinished";
    private boolean canClose = false;
    private IFormView parentView;
    private static final String EXPORTAPP = "report_exp";
    private static Log log = LogFactory.getLog(ReportExportProgressFormPlugin.class);

    public void registerListener(EventObject e) {
        ProgressBar progressbar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
        progressbar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{"btncancel", "btnok"});
    }

    public void click(EventObject evt) {
        String controlKey = ((Control)evt.getSource()).getKey();
        if ("btncancel".equals(controlKey)) {
            String msg = ResManager.loadKDString((String)"\u5bfc\u51fa\u6b63\u5728\u7ec8\u6b62\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"ReportExportProgressFormPlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
            this.getView().showLoading(new LocaleString(msg));
            this.getView().setVisible(Boolean.FALSE, new String[]{"exportpanel"});
            this.getCurrentAppCache().put(this.getCurrentAppCacheKey(), (Object)this.getCurrentAppCacheKey());
            this.setSuspending(true);
        } else if ("btnok".equals(controlKey)) {
            this.toBackground();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageboxclosedevent) {
        super.confirmCallBack(messageboxclosedevent);
        if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
            this.toBackground();
        } else {
            ProgressBar bar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
            bar.start();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (!this.isStart() || this.isSuspending()) {
            e.setCancel(true);
            return;
        }
        if (this.canClose || this.isFinished()) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getTaskId())) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u8981\u628a\u5bfc\u51fa\u8f6c\u4e3a\u540e\u53f0\u6267\u884c\uff1f", (String)"ReportExportProgressFormPlugin_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("CLOSE_CONFIRMED", (IFormPlugin)this));
            this.stopBar();
            e.setCancel(true);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Label title = (Label)this.getControl(KEY_BILLNAME);
        String text = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u51fa%s\uff0c\u5b8c\u6210\u540e\u5c06\u81ea\u52a8\u4e0b\u8f7d", (String)"ReportExportProgressFormPlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), this.getEntityName());
        title.setText(text);
        this.startBar();
        this.dispatchTask();
        String taskId = this.getTaskId();
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 99;
            }
            ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
            bar.setPercent(progress);
            this.showExportDetails(taskInfo);
        }
    }

    public void onProgress(ProgressEvent e) {
        String taskId = this.getTaskId();
        boolean start = this.isStart();
        this.setStart(true);
        if (!start && StringUtils.isBlank((CharSequence)taskId)) {
            this.dispatchTask();
            return;
        }
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (taskInfo.isTaskEnd()) {
            this.complete(taskInfo, e);
        } else {
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 99;
            }
            e.setProgress(progress);
            this.showExportDetails(taskInfo);
        }
    }

    private void toBackground() {
        this.closeForm();
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (!TaskClientProxy.isExistTask((String)taskId)) {
            ReportView parentView = (ReportView)this.getParentView();
            ReportTaskParam param = parentView.getReportCache().getReportTaskParam(parentView.getPageId(), "reportlistap");
            if (param != null) {
                param.setTaskId(taskId);
                param.setTaskType("backgroundExport");
            }
            parentView.getReportCache().setReportTaskParam(parentView.getPageId(), "reportlistap", param);
            JobFormInfo jobFormInfo = this.getJobFormInfo();
            TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)jobFormInfo, (TaskInfo)taskInfo);
            BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
            ThreadPools.executeOnce((String)"task-background-monitor", (Runnable)subscriber);
        }
    }

    private JobFormInfo getJobFormInfo() {
        String str = null;
        str = this.getView().getFormShowParameter().getCustomParams().containsKey(CACHEKEY_JOBFORMINFO) ? (String)this.getView().getFormShowParameter().getCustomParam(CACHEKEY_JOBFORMINFO) : this.getPageCache().get(CACHEKEY_JOBFORMINFO);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return (JobFormInfo)SerializationUtils.fromJsonString((String)str, JobFormInfo.class);
    }

    private void showExportDetails(TaskInfo taskInfo) {
        String strData = taskInfo.getData();
        if (StringUtils.isBlank((CharSequence)strData)) {
            return;
        }
        Map data = (Map)SerializationUtils.fromJsonString((String)strData, Map.class);
        String totalCount = data.containsKey(KEY_TOTAL) ? String.valueOf(data.get(KEY_TOTAL)) : ResManager.loadKDString((String)"\u672a\u77e5", (String)"ReportExportProgressFormPlugin_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
        String completeCount = data.containsKey(KEY_COMPLETE) ? String.valueOf(data.get(KEY_COMPLETE)) : ResManager.loadKDString((String)"\u672a\u77e5", (String)"ReportExportProgressFormPlugin_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
        boolean largeData = false;
        IFormView parentView = this.getParentView();
        if (parentView instanceof ReportView) {
            ReportView reportView = (ReportView)parentView;
            largeData = reportView.isLargeData();
        }
        if (largeData) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap1"});
        } else {
            Label totalLabel = (Label)this.getControl(KEY_TOTAL);
            totalLabel.setText(totalCount);
        }
        Label completeLabel = (Label)this.getControl(KEY_COMPLETE);
        completeLabel.setText(completeCount);
        if (data.containsKey(KEY_TOTAL)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_INITTIPS});
            HashMap<String, Integer> notHidden = new HashMap<String, Integer>();
            notHidden.put("gr", 1);
            this.getView().updateControlMetadata(KEY_PROGRESSDATAS, notHidden);
        }
    }

    private void complete(TaskInfo taskInfo, ProgressEvent e) {
        IFormView parentView = this.getParentView();
        boolean isFinished = this.isFinished();
        this.setFinished(true);
        Map<String, Object> taskData = this.getTaskCustData(taskInfo);
        if (StringUtils.equalsIgnoreCase((CharSequence)"FAILED", (CharSequence)taskInfo.getStatus())) {
            String errMsg = "";
            errMsg = StringUtils.isNotEmpty((CharSequence)parentView.getPageCache().get("cellDataSizeIsOver")) ? ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5355\u5143\u683c\u5b57\u7b26\u8d85\u51faExcel\u9650\u5236\uff0c\u5bfc\u51fa\u5931\u8d25\u3002", (String)"ReportExportProgressFormPlugin_7", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"ReportExportProgressFormPlugin_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnok"});
            this.getView().showErrorNotification(errMsg);
            this.stopBar();
            return;
        }
        if (!isFinished) {
            e.setProgress(99);
            this.showExportDetails(taskInfo);
            return;
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnok"});
        parentView = this.getParentView();
        this.downloadFile(parentView, taskData);
        this.getView().sendFormAction(parentView);
        e.setProgress(100);
        this.stopBar();
        this.closeForm();
        this.getCurrentAppCache().remove(this.getCurrentAppCacheKey());
    }

    private IAppCache getCurrentAppCache() {
        return AppCache.get((String)EntityMetadataCache.getDataEntityType((String)this.getEntityNumber()).getAppId());
    }

    private void closeForm() {
        this.canClose = true;
        TaskClientProxy.setProgressPageId((String)this.getTaskId(), (String)"");
        this.getView().close();
    }

    private Map<String, Object> getTaskCustData(TaskInfo taskInfo) {
        String strData = taskInfo.getData();
        if (StringUtils.isBlank((CharSequence)strData)) {
            return new HashMap<String, Object>();
        }
        return (Map)SerializationUtils.fromJsonString((String)strData, Map.class);
    }

    private void startBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.start();
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.stop();
    }

    private void downloadFile(IFormView view, Map<String, Object> taskData) {
        String url;
        if (!taskData.get(KEY_COMPLETE).equals(taskData.get(KEY_TOTAL))) {
            this.showTipNotification(view);
            return;
        }
        if (this.getCurrentAppCache().get(this.getCurrentAppCacheKey(), String.class) != null) {
            this.showTipNotification(view);
            this.getCurrentAppCache().remove(this.getCurrentAppCacheKey());
            return;
        }
        if (taskData.containsKey("downloadurl") && StringUtils.isNotBlank((CharSequence)(url = (String)taskData.get("downloadurl")))) {
            view.download(url);
        }
        Object messageType = taskData.get("messageType");
        Object message = taskData.get("message");
        if (messageType != null && message != null) {
            if (Integer.parseInt(messageType.toString()) == ReportException.ShowType.SHOW_NOTIFICATION_MSG.getType()) {
                view.showErrorNotification(message.toString());
            } else {
                view.showMessage(message.toString());
            }
        }
    }

    private void showTipNotification(IFormView view) {
        view.hideLoading();
        this.setSuspending(false);
        String msg = ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u5df2\u88ab\u4e2d\u6b62\u3002", (String)"ReportExportProgressFormPlugin_5", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
        view.showTipNotification(msg);
    }

    private boolean isSuspending() {
        String suspending = this.getPageCache().get(this.getCurrentAppCacheKey());
        if (StringUtils.isBlank((CharSequence)suspending)) {
            return false;
        }
        return Boolean.parseBoolean(suspending);
    }

    private void setSuspending(boolean suspending) {
        this.getPageCache().put(this.getCurrentAppCacheKey(), String.valueOf(suspending));
    }

    private String getCurrentAppCacheKey() {
        return "EXPT_SUSPEND_" + this.getEntityNumber();
    }

    private String getEntityNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_ENTITYNUMBER);
    }

    private String getEntityName() {
        return (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_ENTITYNAME);
    }

    private void dispatchTask() {
        JobFormInfo jobFormInfo = this.buildJobFormInfo();
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        this.putTaskId(taskId);
        this.putJobFormInfo(jobFormInfo);
        this.setStart(true);
    }

    private void putJobFormInfo(JobFormInfo jobFormInfo) {
        if (jobFormInfo == null) {
            this.getPageCache().remove(CACHEKEY_JOBFORMINFO);
        } else {
            String str = SerializationUtils.toJsonString((Object)jobFormInfo);
            this.getPageCache().put(CACHEKEY_JOBFORMINFO, str);
        }
    }

    private JobFormInfo buildJobFormInfo() {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setName(String.format(ResManager.loadKDString((String)"\u62a5\u8868\u5bfc\u51fa - %s", (String)"ReportExportProgressFormPlugin_6", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), this.getEntityName()));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setRunByLang(Lang.get());
        String routeAppId = this.getView().getFormShowParameter().getServiceAppId();
        if (StringUtils.isNotBlank((CharSequence)routeAppId)) {
            String subRouteAppId = routeAppId + ".export";
            if (subRouteAppId.equals(ServiceLookup.getServiceAppId((String)subRouteAppId))) {
                routeAppId = subRouteAppId;
            } else if (ServiceLookup.hasDeployedAppId((String)EXPORTAPP)) {
                routeAppId = EXPORTAPP;
            }
        }
        log.info("\u62a5\u8868\u5bfc\u51fa\u6784\u5efa\u4efb\u52a1\u5bf9\u8c61 buildJobFormInfo ---- routeAppId : " + routeAppId);
        jobInfo.setAppId(routeAppId);
        jobInfo.setTaskClassname("kd.bos.mvc.export.ReportExportDataTask");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(CUSTPARAM_CONTEXT, RequestContext.get());
        params.put(CUSTPARAM_ENTITYNUMBER, this.getEntityNumber());
        params.put(CUSTPARAM_ENTITYNAME, this.getEntityName());
        params.put("parentpageid", this.getView().getFormShowParameter().getParentPageId());
        params.put("appId", this.getView().getFormShowParameter().getServiceAppId());
        params.put("permissionItemId", this.getView().getFormShowParameter().getCustomParam("permissionItemId"));
        jobInfo.setParams(params);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setParentPageId(this.getView().getFormShowParameter().getParentPageId());
        jobFormInfo.setRootPageId(this.getView().getFormShowParameter().getRootPageId());
        jobFormInfo.getParams().putAll(this.getView().getFormShowParameter().getCustomParams());
        if (this.getView().getFormShowParameter().getCloseCallBack() != null) {
            jobFormInfo.setCloseCallBack(this.getView().getFormShowParameter().getCloseCallBack());
        } else {
            CloseCallBack closeCallBack = new CloseCallBack(ReportExportCallBack.class.getName(), BACKGROUND_ACTIONID);
            jobFormInfo.setCloseCallBack(closeCallBack);
        }
        jobFormInfo.setClickClassName("kd.bos.form.plugin.report.ReportExportTaskClick");
        jobFormInfo.setTimeout(7200);
        return jobFormInfo;
    }

    private String getTaskId() {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey(CACHEKEY_TASKID)) {
            return (String)this.getView().getFormShowParameter().getCustomParam(CACHEKEY_TASKID);
        }
        return this.getPageCache().get(CACHEKEY_TASKID);
    }

    private void putTaskId(String taskId) {
        this.getPageCache().put(CACHEKEY_TASKID, taskId);
    }

    private boolean isStart() {
        String start = this.getPageCache().get(CACHEKEY_ISSTART);
        if (StringUtils.isBlank((CharSequence)start)) {
            return false;
        }
        return Boolean.parseBoolean(start);
    }

    private void setStart(boolean start) {
        this.getPageCache().put(CACHEKEY_ISSTART, String.valueOf(start));
    }

    private boolean isFinished() {
        String finished = this.getPageCache().get(CACHEKEY_ISFINISHED);
        if (StringUtils.isBlank((CharSequence)finished)) {
            return false;
        }
        return Boolean.parseBoolean(finished);
    }

    private void setFinished(boolean finished) {
        this.getPageCache().put(CACHEKEY_ISFINISHED, String.valueOf(finished));
    }

    private IFormView getParentView() {
        if (this.parentView == null) {
            this.parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        }
        return this.parentView;
    }
}

