/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.test;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.threads.ThreadPools;
import kd.bos.web.DispatchServiceHelper;

public class WebApiTestPlugin
extends AbstractFormPlugin {
    private static int MAX_Threads = 10;
    private static ExecutorService es = ThreadPools.newExecutorService((String)"batchAppendRows", (int)MAX_Threads);
    private static final String ENTRYENTITY = "entryentity";
    private static final String TEST_WEBAPI = "test_webapi";
    private static final String OPERATIONWEBAPI = "OperationWebApi";
    private static int pageRows = 50000;

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void itemClick(ItemClickEvent evt) {
        if ("appendrows".equals(evt.getItemKey())) {
            this.creatlargeEntryBillByAppendRows();
        } else if ("createlargebill".equals(evt.getItemKey())) {
            this.creatlargeEntryBill();
        }
    }

    private void creatlargeEntryBill() {
        HashMap requestData = new HashMap(16);
        HashMap<String, Object> BillData = new HashMap<String, Object>(16);
        requestData.put("data", BillData);
        BillData.put("billno", String.valueOf(DB.genGlobalLongId()));
        ArrayList entry = new ArrayList(10);
        BillData.put(ENTRYENTITY, entry);
        for (int i = 0; i < 400000; ++i) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("text", "rowValue" + i);
            entry.add(row);
        }
        DispatchServiceHelper.invokeBOSServiceByFormId((String)TEST_WEBAPI, (String)OPERATIONWEBAPI, (String)"executeOperation", (Object[])new Object[]{TEST_WEBAPI, "save", requestData});
    }

    private void creatlargeEntryBillByAppendRows() {
        HashMap requestData = new HashMap(16);
        HashMap<String, Object> BillData = new HashMap<String, Object>(16);
        requestData.put("data", BillData);
        BillData.put("billno", String.valueOf(DB.genGlobalLongId()));
        ArrayList entry = new ArrayList(10);
        BillData.put(ENTRYENTITY, entry);
        for (int i = 0; i < pageRows; ++i) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("text", "rowValue" + (i + 1));
            entry.add(row);
        }
        Map ret = (Map)DispatchServiceHelper.invokeBOSServiceByFormId((String)TEST_WEBAPI, (String)OPERATIONWEBAPI, (String)"executeOperation", (Object[])new Object[]{TEST_WEBAPI, "save", requestData});
        OperationResult result = (OperationResult)ret.get("data");
        Object pk = result.getSuccessPkIds().get(0);
        ArrayList<AppendRows> tasks = new ArrayList<AppendRows>(8);
        for (int j = 0; j < 7; ++j) {
            AppendRows builder = new AppendRows(pk, j, RequestContext.get());
            tasks.add(builder);
        }
        try {
            List j = es.invokeAll(tasks);
        }
        catch (Exception e) {
            ErrorCode ec = new ErrorCode("BOS_META", e.getMessage());
            throw new KDException((Throwable)e, ec, new Object[0]);
        }
    }

    private class AppendRows
    implements Callable<Tuple<Boolean, String>> {
        private int pageIndex;
        private RequestContext requestContext;
        private Object pk;

        public AppendRows(Object pk, int pageIndex, RequestContext rc) {
            this.pageIndex = pageIndex;
            this.requestContext = rc;
            this.pk = pk;
        }

        private Map<String, Object> createAppendRows(Object pk, int startIndex) {
            HashMap<String, Object> requestData = new HashMap<String, Object>(16);
            HashMap<String, Object> BillData = new HashMap<String, Object>(16);
            requestData.put("data", BillData);
            requestData.put("starRowIndex", startIndex);
            requestData.put("entryName", WebApiTestPlugin.ENTRYENTITY);
            BillData.put("id", pk);
            ArrayList entry = new ArrayList(10);
            BillData.put(WebApiTestPlugin.ENTRYENTITY, entry);
            for (int i = 0; i < pageRows; ++i) {
                HashMap<String, String> row = new HashMap<String, String>();
                row.put("text", "append" + (i + startIndex + 1));
                entry.add(row);
            }
            return requestData;
        }

        @Override
        public Tuple<Boolean, String> call() throws Exception {
            RequestContext.copyAndSet((RequestContext)this.requestContext);
            boolean success = true;
            String message = "";
            try {
                DispatchServiceHelper.invokeBOSServiceByFormId((String)WebApiTestPlugin.TEST_WEBAPI, (String)WebApiTestPlugin.OPERATIONWEBAPI, (String)"appendEntryRows", (Object[])new Object[]{WebApiTestPlugin.TEST_WEBAPI, SerializationUtils.toJsonString(this.createAppendRows(this.pk, (this.pageIndex + 1) * pageRows))});
            }
            catch (Exception e) {
                success = false;
                message = String.format("error: BUILD FAILED, %s\u3002", e.getMessage());
            }
            return Tuple.create((Object)success, (Object)message);
        }
    }
}

