/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.plugin.tools.KSQLColumnUtil;
import kd.bos.ksql.exception.ParserException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;

public class DataBaseSystemTableInfo {
    private static Log log = LogFactory.getLog(DataBaseSystemTableInfo.class);
    private static final String DATA_BASE_TYPE_ORACLE = "0";
    private static final String DATA_BASE_TYPE_POST_GRE_SQL = "1";
    private static final String DATA_BASE_TYPE_MYSQL = "2";
    private static final String DATA_BASE_TYPE_MD = "3";
    private static final String DATA_BASE_TYPE_GS = "4";
    private static final String DATA_BASE_TYPE_GS100 = "5";
    private static final String DATA_BASE_TYPE_SQLSERVER = "6";
    private static final String ORACLE_SYSTEM_TABLE_FILE = "/oracle_system_tables.txt";
    private static final String POST_GRE_SQL_SYSTEM_TABLE_FILE = "/postgresql_system_tables.txt";
    private static final String MYSQL_SYSTEM_TABLE_FILE = "/mysql_system_tables.txt";
    private static final String DM_SYSTEM_TABLE_FILE = "/dm_system_tables.txt";
    private static final String GS100_SYSTEM_TABLE_FILE = "/gs100_system_tables.txt";
    private static final String SQLSERVER_SYSTEM_TABLE_FILE = "/sqlserver_system_tables.txt";
    private static final String TABLE_SENSITIVE_COLUMN_FILE = "/table_sensitive_column.txt";
    private static final Map<String, List<String>> DATA_BASE_SYSTEM_TABLE_MAP = new HashMap<String, List<String>>(5);
    private static final Map<String, String[]> TABLE_COLUMN_MAP = new HashMap<String, String[]>(5);
    private static final String BOS_FORM_BUSINESS = "bos-form-business";

    private static String getIsSensitiveField() {
        return ResManager.loadKDString((String)"\u4e3a\u654f\u611f\u5b57\u6bb5\uff1b", (String)"DataBaseSystemTableInfo_8", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
    }

    private static String getQueryCriteria() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u6761\u4ef6\u90e8\u5206", (String)"DataBaseSystemTableInfo_7", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
    }

    private static String getMedium() {
        return ResManager.loadKDString((String)"\u4e2d\u7684", (String)"DataBaseSystemTableInfo_5", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
    }

    private static String getTable() {
        return ResManager.loadKDString((String)"\u8868", (String)"DataBaseSystemTableInfo_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
    }

    private static String getQueryReturnPart() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u8fd4\u56de\u90e8\u5206", (String)"DataBaseSystemTableInfo_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
    }

    private static String getColumn() {
        return ResManager.loadKDString((String)"\u5217", (String)"DataBaseSystemTableInfo_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
    }

    private static String getThe() {
        return ResManager.loadKDString((String)"\u7b2c", (String)"DataBaseSystemTableInfo_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
    }

    private DataBaseSystemTableInfo() {
    }

    private static void initTableMapping(String type, String filePath) {
        try (InputStream in = DataBaseSystemTableInfo.class.getResourceAsStream(filePath);
             BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line;
            ArrayList<String> tableNames = new ArrayList<String>(10);
            while ((line = reader.readLine()) != null) {
                tableNames.add(line);
            }
            DATA_BASE_SYSTEM_TABLE_MAP.put(type, tableNames);
        }
        catch (Exception e) {
            log.error(String.format("\u521d\u59cb\u5316\u6570\u636e\u5e93\u7c7b\u578b\u4e3a:%s,\u6587\u4ef6\u540d\u4e3a:%s\u7684\u6570\u636e\u5e93\u7cfb\u7edf\u8868\u4fe1\u606f\u5931\u8d25...", type, filePath), (Throwable)e);
        }
    }

    public static boolean isSystemTable(String tableName, String type) {
        Map<String, List<String>> systemTableMap;
        List<String> tables;
        boolean isGs100Db;
        boolean bl = isGs100Db = (DATA_BASE_TYPE_GS.equals(type) || DATA_BASE_TYPE_POST_GRE_SQL.equals(type)) && Boolean.getBoolean("pg_as_gs100");
        if (isGs100Db) {
            type = DATA_BASE_TYPE_GS100;
        }
        if (CollectionUtils.isEmpty(tables = (systemTableMap = DataBaseSystemTableInfo.getDataBaseSystemTableMap()).get(type))) {
            return false;
        }
        for (String table : tables) {
            if (StringUtils.isBlank((CharSequence)table)) continue;
            if (DATA_BASE_TYPE_MD.equals(type) && tableName.startsWith(table)) {
                return true;
            }
            if (!tableName.equals(table) && !table.startsWith(tableName)) continue;
            return true;
        }
        return false;
    }

    private static Map<String, List<String>> getDataBaseSystemTableMap() {
        return Collections.unmodifiableMap(DATA_BASE_SYSTEM_TABLE_MAP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initTableCloumnMapping(String filePath) {
        InputStream e = DataBaseSystemTableInfo.class.getResourceAsStream(filePath);
        if (e == null) {
            return;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(e));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                TABLE_COLUMN_MAP.put(line.split(":")[0].trim(), line.split(":")[1].trim().split(","));
            }
        }
        catch (IOException e1) {
            log.warn(e1.getMessage(), (Throwable)e1);
        }
        finally {
            try {
                if (e != null) {
                    e.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                log.warn(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public static Map<String, String> useSensitiveColumnList(String sql) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        ArrayList<KSQLColumnUtil.Column> r = new ArrayList<KSQLColumnUtil.Column>(10);
        for (Map.Entry<String, String[]> entry : TABLE_COLUMN_MAP.entrySet()) {
            String[] columns;
            String table = entry.getKey();
            for (String column : columns = entry.getValue()) {
                r.add(new KSQLColumnUtil.Column(table, column));
            }
        }
        try {
            List<KSQLColumnUtil.FindColumnResult> check = KSQLColumnUtil.findColumnsInSelect(sql, r);
            StringBuilder message = new StringBuilder();
            StringBuilder temp = new StringBuilder();
            List<Set<KSQLColumnUtil.Column>> columnInSelect = check.get(0).getColumnInSelect();
            int columnInSelectlength = columnInSelect.size();
            for (int i = 0; i < columnInSelectlength; ++i) {
                Set<KSQLColumnUtil.Column> set = columnInSelect.get(i);
                if (set.size() == 0) continue;
                temp.append(DataBaseSystemTableInfo.getThe() + (i + 1) + DataBaseSystemTableInfo.getColumn());
                HashMap<String, String> selectDistincTableMap = new HashMap<String, String>();
                for (KSQLColumnUtil.Column column : set) {
                    selectDistincTableMap.put(column.getTable(), (selectDistincTableMap.get(column.getTable()) == null ? "" : (String)selectDistincTableMap.get(column.getTable())) + column.getColumn() + "\uff0c");
                }
                temp.append("\uff08");
                for (Map.Entry entry : selectDistincTableMap.entrySet()) {
                    temp.append(DataBaseSystemTableInfo.getTable() + (String)entry.getKey() + DataBaseSystemTableInfo.getMedium() + ((String)entry.getValue()).substring(0, ((String)entry.getValue()).length() - 1) + "\uff0c");
                }
                temp.delete(temp.length() - 1, temp.length());
                temp.append("\uff09\uff0c");
            }
            if (temp.length() > 0) {
                message.append(DataBaseSystemTableInfo.getQueryReturnPart()).append(":").append(temp.subSequence(0, temp.length() - 1)).append(DataBaseSystemTableInfo.getIsSensitiveField()).append("\n");
            }
            Set<KSQLColumnUtil.Column> columnInCondition = check.get(0).getColumnInCondition();
            Iterator<KSQLColumnUtil.Column> it = columnInCondition.iterator();
            temp = new StringBuilder();
            HashMap<String, String> whereDistincTableMap = new HashMap<String, String>();
            while (it.hasNext()) {
                KSQLColumnUtil.Column column = it.next();
                whereDistincTableMap.put(column.getTable(), (whereDistincTableMap.get(column.getTable()) == null ? "" : (String)whereDistincTableMap.get(column.getTable())) + column.getColumn() + "\uff0c");
            }
            for (Map.Entry entry : whereDistincTableMap.entrySet()) {
                temp.append(DataBaseSystemTableInfo.getTable() + (String)entry.getKey() + DataBaseSystemTableInfo.getMedium() + ((String)entry.getValue()).substring(0, ((String)entry.getValue()).length() - 1) + "\uff1b");
            }
            if (temp.length() > 0) {
                message.append(DataBaseSystemTableInfo.getQueryCriteria()).append(":").append(temp.subSequence(0, temp.length() - 1)).append(DataBaseSystemTableInfo.getIsSensitiveField());
            }
            if (message.length() > 0) {
                returnMap.put("haveSensitiveOrError", message.toString());
            }
            return returnMap;
        }
        catch (ParserException e) {
            e.printStackTrace();
            returnMap.put("haveSensitiveOrError", e.getMessage());
            return returnMap;
        }
    }

    static {
        DataBaseSystemTableInfo.initTableMapping(DATA_BASE_TYPE_ORACLE, ORACLE_SYSTEM_TABLE_FILE);
        DataBaseSystemTableInfo.initTableMapping(DATA_BASE_TYPE_POST_GRE_SQL, POST_GRE_SQL_SYSTEM_TABLE_FILE);
        DataBaseSystemTableInfo.initTableMapping(DATA_BASE_TYPE_MYSQL, MYSQL_SYSTEM_TABLE_FILE);
        DataBaseSystemTableInfo.initTableMapping(DATA_BASE_TYPE_MD, DM_SYSTEM_TABLE_FILE);
        DataBaseSystemTableInfo.initTableMapping(DATA_BASE_TYPE_GS, POST_GRE_SQL_SYSTEM_TABLE_FILE);
        DataBaseSystemTableInfo.initTableMapping(DATA_BASE_TYPE_GS100, GS100_SYSTEM_TABLE_FILE);
        DataBaseSystemTableInfo.initTableMapping(DATA_BASE_TYPE_SQLSERVER, SQLSERVER_SYSTEM_TABLE_FILE);
        DataBaseSystemTableInfo.initTableCloumnMapping(TABLE_SENSITIVE_COLUMN_FILE);
    }
}

