/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.tools;

import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.ksql.TransUtil;
import kd.bos.ksql.exception.SqlTranslateException;
import kd.bos.ksql.formater.FormatOptions;

public class KSQLTransToolPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String EDIT_KSQL = "codeedit_ksql";
    private static final String SHOW_SQL = "codeshow_sql";
    private static final String BT_TRANS = "bt_trans";
    private static final String COMBO_DB_TYPE = "dbtype";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{BT_TRANS});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String controlKey = control.getKey();
        if (controlKey.equals(BT_TRANS)) {
            this.transKSQL();
        }
    }

    public void transKSQL() {
        IDataModel dataModel = this.getModel();
        IFormView formView = this.getView();
        boolean isCheck = false;
        CodeEdit codeKSQLEdit = (CodeEdit)this.getView().getControl(EDIT_KSQL);
        String ksqlStrs = codeKSQLEdit.getText();
        if (null == ksqlStrs || "".equals(ksqlStrs)) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165ksql\u8bed\u53e5\u3002", (String)"KSQLTransToolPlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        String DBType = (String)this.getModel().getValue(COMBO_DB_TYPE);
        String sql_show = "";
        String retSql = "";
        switch (DBType) {
            case "Oracle": {
                retSql = this.execTransKSQL(ksqlStrs, 2);
                sql_show = sql_show + "\u00b7TO Oracle:\r\n" + retSql + "\r\n";
                break;
            }
            case "SQLServer": {
                retSql = this.execTransKSQL(ksqlStrs, 3);
                sql_show = sql_show + "\u00b7TO SQLServer:\r\n" + retSql + "\r\n";
                break;
            }
            case "PostgreSQL": {
                retSql = this.execTransKSQL(ksqlStrs, 5);
                sql_show = sql_show + "\u00b7TO PostgreSQL:\r\n" + retSql + "\r\n";
                break;
            }
            case "MySQL": {
                retSql = this.execTransKSQL(ksqlStrs, 6);
                sql_show = sql_show + "\u00b7TO MySQL:\r\n" + retSql + "\r\n";
                break;
            }
            case "DM": {
                retSql = this.execTransKSQL(ksqlStrs, 11);
                sql_show = sql_show + "\u00b7TO DM:\r\n" + retSql + "\r\n";
                break;
            }
            case "GaussDB": {
                retSql = this.execTransKSQL(ksqlStrs, 14);
                sql_show = sql_show + "\u00b7TO GaussDB:\r\n" + retSql + "\r\n";
                break;
            }
            case "KingBase": {
                retSql = this.execTransKSQL(ksqlStrs, 15);
                sql_show = sql_show + "\u00b7TO KingBase:\r\n" + retSql + "\r\n";
                break;
            }
            case "Vastbase": {
                retSql = this.execTransKSQL(ksqlStrs, 16);
                sql_show = sql_show + "\u00b7TO Vastbase:\r\n" + retSql + "\r\n";
                break;
            }
            case "TDSQL": {
                retSql = this.execTransKSQL(ksqlStrs, 17);
                sql_show = sql_show + "\u00b7TO TDSQL:\r\n" + retSql + "\r\n";
                break;
            }
            case "Gbase": {
                retSql = this.execTransKSQL(ksqlStrs, 18);
                sql_show = sql_show + "\u00b7TO Gbase:\r\n" + retSql + "\r\n";
                break;
            }
            case "TiDB": {
                retSql = this.execTransKSQL(ksqlStrs, 19);
                sql_show = sql_show + "\u00b7TO TiDB:\r\n" + retSql + "\r\n";
                break;
            }
            case "YasDB": {
                retSql = this.execTransKSQL(ksqlStrs, 20);
                sql_show = sql_show + "\u00b7TO YasDB:\r\n" + retSql + "\r\n";
                break;
            }
            case "OceanBase_Oracle": {
                retSql = this.execTransKSQL(ksqlStrs, 21);
                sql_show = sql_show + "\u00b7TO OceanBase_Oracle:\r\n" + retSql + "\r\n";
                break;
            }
        }
        CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl(SHOW_SQL);
        codeSQLshow.setText(sql_show);
    }

    public String execTransKSQL(String ksql, int SQLType2) {
        String retSql = null;
        try {
            retSql = TransUtil.translate((String)ksql, (int)SQLType2, (FormatOptions)new FormatOptions());
        }
        catch (RuntimeException | SqlTranslateException e) {
            return String.format(ResManager.loadKDString((String)"\u7ffb\u8bd1\u5931\u8d25\u3002%s", (String)"KSQLTransToolPlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), e.getMessage());
        }
        return retSql;
    }
}

