/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.tools.ast;

import java.util.ArrayList;
import java.util.List;
import kd.bos.form.plugin.tools.ast.Column;
import kd.bos.form.plugin.tools.ast.JoinTable;
import kd.bos.form.plugin.tools.ast.NestColumn;
import kd.bos.form.plugin.tools.ast.Query;
import kd.bos.form.plugin.tools.ast.SimpleColumn;
import kd.bos.form.plugin.tools.ast.SimpleTable;
import kd.bos.form.plugin.tools.ast.SubTable;
import kd.bos.form.plugin.tools.ast.Table;
import kd.bos.ksql.dom.SqlJoinedTableSource;
import kd.bos.ksql.dom.SqlObject;
import kd.bos.ksql.dom.SqlSelect;
import kd.bos.ksql.dom.SqlSelectItem;
import kd.bos.ksql.dom.SqlSubQueryTableSource;
import kd.bos.ksql.dom.SqlTableSource;
import kd.bos.ksql.dom.expr.QueryExpr;
import kd.bos.ksql.dom.expr.SqlAggregateExpr;
import kd.bos.ksql.dom.expr.SqlBinaryOpExpr;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.dom.expr.SqlIdentifierExpr;
import kd.bos.ksql.dom.expr.SqlInListExpr;
import kd.bos.ksql.dom.expr.SqlInSubQueryExpr;
import kd.bos.ksql.dom.expr.SqlMethodInvokeExpr;
import kd.bos.ksql.visitor.ASTVisitor;
import kd.bos.ksql.visitor.ASTVisitorBase;
import kd.bos.ksql.visitor.TreeNode;

public class TableColumnVisitor
extends ASTVisitorBase<Object> {
    public Object visitSqlSelect(SqlSelect stmt) {
        Query query = new Query();
        Table table = (Table)this.visit((TreeNode)stmt.tableSource);
        query.initTable(table);
        for (Object o : stmt.selectList) {
            SqlSelectItem sqlObject = (SqlSelectItem)o;
            String alias = sqlObject.alias;
            if (alias == null) {
                alias = sqlObject.expr.toString();
            }
            Column column = sqlObject.expr instanceof QueryExpr ? this.parseSubInSelect(sqlObject, alias) : this.parseSelect(sqlObject, alias, query);
            query.putSelectColumn(column);
        }
        if (stmt.condition != null) {
            query.putConditionColumn(this.parseCondition(stmt.condition, query));
        }
        return query;
    }

    private List<SimpleColumn> relevanceTable(SimpleColumn column, Table table) {
        ArrayList<SimpleColumn> scs = new ArrayList<SimpleColumn>();
        if (column.isReplaceTable()) {
            scs.add(column);
            return scs;
        }
        if (table instanceof SimpleTable) {
            column.setTable(((SimpleTable)table).getName());
            column.setReplaceTable(true);
            scs.add(column);
            return scs;
        }
        if (((SubTable)table).getQuery().getSelect().size() == 1) {
            return ((SubTable)table).getQuery().getSelect().get(0).getSimpleColumn();
        }
        Column subColumn = ((SubTable)table).getQuery().getColumnName(column.getAlias());
        return subColumn.getSimpleColumn();
    }

    private Column parseSubInSelect(SqlSelectItem sqlObject, String alias) {
        Query q = (Query)this.visit((TreeNode)sqlObject.expr);
        NestColumn nestColumn = new NestColumn(alias);
        if (q.getSelect().size() == 1) {
            nestColumn.addColumn(q.getSelect().get(0));
        } else {
            List<SimpleColumn> scs = q.getColumnName(alias).getSimpleColumn();
            for (SimpleColumn sc : scs) {
                nestColumn.addColumn(sc);
            }
        }
        return nestColumn;
    }

    public Object visitSqlMethodInvokeExpr(SqlMethodInvokeExpr expr) {
        NestColumn nestColumn = new NestColumn(null);
        for (Object parameter : expr.parameters) {
            if (!(parameter instanceof SqlObject)) continue;
            Object obj = ((SqlObject)parameter).accept((ASTVisitor)this);
            nestColumn.addColumn((Column)obj);
        }
        return nestColumn;
    }

    private Column parseSelect(SqlSelectItem sqlObject, String alias, Query query) {
        Column column = (Column)this.visit((TreeNode)sqlObject.expr);
        if (column == null) {
            return new NestColumn(alias);
        }
        List<SimpleColumn> scs = column.getSimpleColumn();
        ArrayList<SimpleColumn> dist = new ArrayList<SimpleColumn>();
        for (SimpleColumn sc : scs) {
            if (sc.getTable() == null) {
                dist.addAll(this.relevanceTable(sc, query.getMainTable()));
                continue;
            }
            Table relevanceTable = query.getTableByAlias(sc.getTable());
            if (relevanceTable == null) {
                throw new RuntimeException(String.format("Unknown table alias:%s on column: %s .", sc.getTable(), sqlObject.expr.toString()));
            }
            dist.addAll(this.relevanceTable(sc, relevanceTable));
        }
        if (dist.size() == 1) {
            SimpleColumn c = (SimpleColumn)dist.get(0);
            c.setAlias(alias);
            return c;
        }
        NestColumn nestColumn = new NestColumn(alias);
        for (SimpleColumn simpleColumn : dist) {
            nestColumn.addColumn(simpleColumn);
        }
        return nestColumn;
    }

    private List<SimpleColumn> parseCondition(SqlExpr condition, Query query) {
        Column column = (Column)this.visit((TreeNode)condition);
        List<SimpleColumn> simpleColumns = column.getSimpleColumn();
        ArrayList<SimpleColumn> dist = new ArrayList<SimpleColumn>(simpleColumns.size());
        for (SimpleColumn simpleColumn : simpleColumns) {
            if (simpleColumn.getTable() == null) {
                dist.addAll(this.relevanceTable(simpleColumn, query.getMainTable()));
                continue;
            }
            Table relevanceTable = query.getTableByAlias(simpleColumn.getTable());
            dist.addAll(this.relevanceTable(simpleColumn, relevanceTable));
        }
        return dist;
    }

    public Object visitSqlAggregateExpr(SqlAggregateExpr expr) {
        NestColumn nestColumn = new NestColumn(null);
        for (Object o : expr.paramList) {
            if (!(o instanceof SqlObject)) continue;
            nestColumn.addColumn((Column)this.visit((TreeNode)((SqlObject)o)));
        }
        return nestColumn;
    }

    public Object visitSqlInListExpr(SqlInListExpr expr) {
        NestColumn nestColumn = new NestColumn(null);
        nestColumn.addColumn((Column)this.visit((TreeNode)expr.expr));
        for (Object param : expr.targetList) {
            if (!(param instanceof SqlObject)) continue;
            nestColumn.addColumn((Column)this.visit((TreeNode)((SqlObject)param)));
        }
        return nestColumn;
    }

    public Object visitSqlIdentifierExpr(SqlIdentifierExpr expr) {
        return new SimpleColumn(null, expr.value, null);
    }

    public Object visitSqlBinaryOpExpr(SqlBinaryOpExpr expr) {
        if (expr.operator == 20) {
            return new SimpleColumn(expr.left.getOrgValue(), expr.right.getOrgValue(), null);
        }
        NestColumn nestColumn = new NestColumn(null);
        nestColumn.addColumn((Column)this.visit((TreeNode)expr.left));
        nestColumn.addColumn((Column)this.visit((TreeNode)expr.right));
        return nestColumn;
    }

    public Object visitSqlInSubQueryExpr(SqlInSubQueryExpr expr) {
        NestColumn nestColumn = new NestColumn(null);
        Column column = (Column)this.visit((TreeNode)expr.expr);
        nestColumn.addColumn(column);
        Query query = (Query)this.visit((TreeNode)expr.subQuery);
        for (Column column1 : query.getSelect()) {
            nestColumn.addColumn(column1);
        }
        for (Column column1 : query.getCondition()) {
            nestColumn.addColumn(column1);
        }
        return nestColumn;
    }

    public Object visitSqlJoinedTableSource(SqlJoinedTableSource stmt) {
        ArrayList<Column> conditionColumns = new ArrayList<Column>();
        if (stmt.condition != null) {
            NestColumn nestColumn = (NestColumn)this.visit((TreeNode)stmt.condition);
            conditionColumns.addAll(nestColumn.getSimpleColumn());
        }
        return new JoinTable((Table)this.visit((TreeNode)stmt.left), (Table)this.visit((TreeNode)stmt.right), conditionColumns);
    }

    public Object visitSqlTableSource(SqlTableSource stmt) {
        String alias = stmt.alias;
        if (alias == null) {
            alias = stmt.name;
        }
        return new SimpleTable(stmt.name, alias);
    }

    public Object visitSqlSubQueryTableSource(SqlSubQueryTableSource stmt) {
        Query query = (Query)this.visit((TreeNode)stmt.subQuery);
        return new SubTable(stmt.alias, query);
    }
}

