/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.voice;

import java.util.EventObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Html;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.TimerElapsedArgs;
import kd.bos.form.plugin.AbstractFormPlugin;

public class VisibleVoiceTextPlugin
extends AbstractFormPlugin {
    private static final String CURRENTTIMEMILLIS = "currentTimeMillis";

    public void initialize() {
        super.initialize();
        long start = System.currentTimeMillis();
        String cacheStr = this.getPageCache().get(CURRENTTIMEMILLIS);
        if (StringUtils.isBlank((CharSequence)cacheStr)) {
            this.getPageCache().put(CURRENTTIMEMILLIS, Long.toString(start));
        }
    }

    public void afterCreateNewData(EventObject e) {
        String msg = (String)this.getView().getFormShowParameter().getCustomParam("showVoiceMsg");
        if (msg != null) {
            Html html = (Html)this.getControl("htmlap");
            StringBuilder sb = new StringBuilder(500);
            sb.append("<div style='overflow:auto;word-wrap:break-word;word-break:break-all;width:100%'>");
            sb.append(msg).append("<br/></div>");
            html.setConent(sb.toString());
        }
    }

    public void TimerElapsed(TimerElapsedArgs e) {
        long start;
        long end = System.currentTimeMillis();
        if (end - (start = Long.parseLong(this.getPageCache().get(CURRENTTIMEMILLIS))) > 9000L) {
            this.getView().close();
        }
    }

    public void customEvent(CustomEventArgs e) {
        long start = System.currentTimeMillis();
        this.getPageCache().put(CURRENTTIMEMILLIS, Long.toString(start));
        String msg = e.getEventArgs();
        if (msg != null) {
            Html html = (Html)this.getControl("htmlap");
            html.setConent(msg);
        }
    }
}

