/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.product;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.license.api.ICoreLicenseService;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.product.ProductSettingService;
import kd.bos.service.ServiceFactory;

public class ProductControlPlugin
extends AbstractFormPlugin {
    private static boolean applyModelSetting = Boolean.parseBoolean(System.getProperty("sys.productmodelsetting.enable", "true"));

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        try (EntityTraceSpan span = EntityTracer.create((String)"plugin", (String)"loadCustomControlMetas");){
            String proEnable = System.getProperty("sys.productmodelsetting.enable", "true");
            int proMode = this.getProductModel();
            if (span.isRealtime()) {
                span.addLocaleTag("sys.productmodelsetting.enable", (Object)proEnable);
                span.addLocaleTag("productMode", (Object)proMode);
            }
            if (!applyModelSetting || !this.isUltimateMode()) {
                return;
            }
            ProductSettingService service = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
            if (e.getSource() instanceof ListShowParameter) {
                ListShowParameter paramer = (ListShowParameter)e.getSource();
                String formId = paramer.getBillFormId();
                if (formId == null) {
                    return;
                }
                List items = service.getListHideInstructions(formId);
                for (Map row : items) {
                    e.getInvisibleInstructions().add(row);
                }
            } else if (!(e.getSource() instanceof MobileFormShowParameter || e.getSource() instanceof MobileBillShowParameter || e.getSource() instanceof MobileListShowParameter)) {
                FormShowParameter paramer = (FormShowParameter)e.getSource();
                String formId = paramer.getFormId();
                List items = service.getFormHideInstructions(formId);
                for (Map row : items) {
                    e.getInvisibleInstructions().add(row);
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        if (!applyModelSetting || !this.isUltimateMode()) {
            return;
        }
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (!(parameter instanceof MobileFormShowParameter || parameter instanceof MobileBillShowParameter || parameter instanceof MobileListShowParameter || parameter instanceof ListShowParameter)) {
            String formId = parameter.getFormId();
            ProductSettingService service = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
            List keys = service.getFormDisVistCtl(formId);
            if (keys == null || keys.isEmpty()) {
                return;
            }
            this.getView().setVisible(Boolean.valueOf(false), keys.toArray(new String[keys.size()]));
        }
    }

    private boolean isUltimateMode() {
        return this.getProductModel() == 2 || this.getProductModel() == 4;
    }

    private int getProductModel() {
        ICoreLicenseService licService = (ICoreLicenseService)ServiceFactory.getService(ICoreLicenseService.class);
        return licService.getModeType();
    }
}

