/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mutex.formplugin;

import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.filter.events.CloseQueryByOrEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.mutex.DataMutex;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class DatalockListPlugin
extends AbstractListPlugin
implements PagerClickListener {
    private static final Log log = LogFactory.getLog(DatalockListPlugin.class);
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final String KEY_BTN_DELETE = "btn_delete";
    private static final String KEY_BTN_REFLESH = "btn_reflesh";
    private static final String KEY_BILLLISTAP = "billlistap";
    private static final String BTN_DELETEREDISDATA = "btn_deleteredisdata";
    private static final String KEY_OPERATION = "operationkey";
    private static final String KEY_ENTITY_KEY = "entitykey";
    private static final String KEY_ENTITYKEY_NUMBER = "entitykey.number";
    private static final String KEY_ENTITY_KEY_ID = "entitykey.id";
    private static final String KEY_OBJECTID = "objectid";
    private static final String KEY_BIZOBJECT_NAME = "objectname";
    private static final String KEY_CLIENT = "client";
    private static final String CREATE_TIME = "createtime";
    private static final String FORMID_BOS_MYDATALOCK = "bos_mydatalock";
    private static final String FORMID_BOS_DATALOCK = "bos_datalock";
    private static final String LOADREDISMUTEX = "loadredismutex";
    private static final String RELEASEDIRTYDATA = "releaseDirtyData";
    private static final String IDDATAMAPPING = "idDataMapping";
    private static final String FILTER = "filter";
    private static final String DATACOUNT = "dataCount";
    private static final String ISREDISDATA = "isRedisData";
    static final String MUTEX_DATA_OBJID = "dataObjId";
    static final String MUTEX_GROUP_ID = "groupId";
    static final String MUTEX_ENTITY_KEY = "entityKey";
    static final String MUTEX_OPERATION_KEY = "operationKey";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        if (operate.getOperateKey().equals("delete")) {
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            ArrayList<Long> idList = new ArrayList<Long>(listSelectedData.size());
            for (int i = 0; i < listSelectedData.size(); ++i) {
                ListSelectedRow row = listSelectedData.get(i);
                idList.add(Long.valueOf(String.valueOf(row.getPrimaryKeyValue())));
            }
            List<Map<String, Object>> lockInfo = DatalockListPlugin.getAbnormalDataLock(idList);
            List<String> notDeleteData = DatalockListPlugin.releaseDataMutex(lockInfo);
            if (CollectionUtils.isEmpty(notDeleteData)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"DatalockListPlugin_11", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            } else {
                log.warn("failed to delete mutex data from redis, dataids:{}", (Object)Arrays.toString(notDeleteData.toArray()));
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5171\u6709%s\u6761\u6570\u636e\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"DatalockListPlugin_16", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), notDeleteData.size()));
            }
            args.setCancel(true);
            BillList billList = (BillList)this.getView().getControl(KEY_BILLLISTAP);
            billList.clearSelection();
            billList.refresh();
        }
    }

    private void throwException(Exception e) throws KDException {
        ErrorCode ec = new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u91ca\u653e\u6570\u636e\u5bf9\u8c61\u4e92\u65a5\u9501\u51fa\u9519.%s", (String)"DatalockListPlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), e.getMessage()));
        throw new KDException((Throwable)e, ec, new Object[0]);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemkey = evt.getItemKey();
        BillList billList = (BillList)this.getView().getControl(KEY_BILLLISTAP);
        if (KEY_BTN_REFLESH.equalsIgnoreCase(itemkey)) {
            try (DataMutex dataMutex = DataMutex.create();){
                dataMutex.refreshLocks();
            }
            catch (IOException e) {
                this.throwException(e);
            }
            this.getPageCache().put(RELEASEDIRTYDATA, "true");
            billList.clearSelection();
            billList.refresh();
        } else if (BTN_DELETEREDISDATA.equals(itemkey)) {
            ListSelectedRowCollection rows = billList.getSelectedRows();
            if (rows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u6570\u636e.", (String)"DatalockListPlugin_12", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                return;
            }
            DataMutex mutex = DataMutex.create();
            String idDatas = this.getPageCache().get(IDDATAMAPPING);
            Map idData = idDatas == null ? new HashMap(0) : (Map)SerializationUtils.fromJsonString((String)idDatas, Map.class);
            boolean needReflesh = false;
            for (ListSelectedRow row : rows) {
                String id = row.getPrimaryKeyValue().toString();
                if (idData.get(id) == null) continue;
                String[] info = ((String)idData.get(id)).split("@@");
                if (info.length == 4) {
                    mutex.forcerelease(info[2], info[0], info[3]);
                    needReflesh = true;
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25,\u6570\u636e\u4e0d\u5b58\u5728.", (String)"DatalockListPlugin_13", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                }
                if (!needReflesh) continue;
                this.reLoadRedisData();
            }
        } else if ("btn_loadredisdata".equals(itemkey)) {
            this.reLoadRedisData();
        }
    }

    private void reLoadRedisData() {
        BillList billList = (BillList)this.getView().getControl(KEY_BILLLISTAP);
        this.getModel().putContextVariable(LOADREDISMUTEX, (Object)true);
        this.getPageCache().put(RELEASEDIRTYDATA, "true");
        billList.clearSelection();
        billList.refresh();
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Object objectId = args.getFilterValue(KEY_OBJECTID);
        if (objectId == null || StringUtils.isBlank((CharSequence)objectId.toString())) {
            return;
        }
        Object entityNumber = args.getFilterValue(KEY_ENTITYKEY_NUMBER);
        if (entityNumber == null || StringUtils.isBlank((CharSequence)entityNumber.toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5bf9\u8c61\u7c7b\u578b.\u7f16\u7801\u201d\u3002", (String)"DatalockListPlugin_17", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        }
        List schemeFilters = (List)args.getFilterValues().get("schemefilter");
        Map<String, List<Object>> objectNameQFilter = new HashMap<String, List<Object>>(6);
        Map entityNumberQFilter = new HashMap(6);
        for (Map schemeFilter : schemeFilters) {
            if (KEY_OBJECTID.equals(((List)schemeFilter.get("FieldName")).get(0))) {
                objectNameQFilter = schemeFilter;
                continue;
            }
            if (!KEY_ENTITYKEY_NUMBER.equals(((List)schemeFilter.get("FieldName")).get(0))) continue;
            entityNumberQFilter = schemeFilter;
        }
        if (!CollectionUtils.isEmpty(entityNumberQFilter) && !"67".equals(((List)entityNumberQFilter.get("Compare")).get(0))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u5bf9\u8c61\u7c7b\u578b.\u7f16\u7801\u201d\u53ea\u652f\u6301\u201c\u7b49\u4e8e\u201d\u6bd4\u8f83\u7b26\u3002", (String)"DatalockListPlugin_18", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        }
        this.parseSchemeQFilter(entityNumber, objectId, objectNameQFilter);
    }

    private void parseSchemeQFilter(Object entityNumber, Object objectId, Map<String, List<Object>> objectNameQFilter) {
        String id = MetadataDao.getIdByNumber((String)String.valueOf(entityNumber), (MetaCategory)MetaCategory.Entity);
        if (StringUtils.isBlank((CharSequence)id)) {
            return;
        }
        MainEntityType dataEntity = EntityMetadataCache.getDataEntityType((String)String.valueOf(entityNumber));
        if (dataEntity instanceof BillEntityType) {
            BillEntityType entityType = (BillEntityType)dataEntity;
            if (StringUtils.isBlank((CharSequence)entityType.getBillNo())) {
                return;
            }
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)dataEntity.getName(), (String)("id," + entityType.getBillNo()), (QFilter[])new QFilter[]{new QFilter(entityType.getBillNo(), "=", objectId)});
            ArrayList<String> data = new ArrayList<String>(dynamicObjects.length);
            for (DynamicObject obj : dynamicObjects) {
                data.add(obj.getPkValue().toString());
            }
            objectNameQFilter.put("Value", data);
        }
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerAfterSearchClick(args);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new DatalockListDataProviderImpl());
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (Boolean.parseBoolean(this.getPageCache().get(ISREDISDATA))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_BTN_DELETE});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_DELETEREDISDATA});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_BTN_DELETE});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_DELETEREDISDATA});
        }
    }

    private String getOperationName(String formId, String opKey) {
        try {
            Map opMap = EntityMetadataCache.getDataEntityOperate((String)formId, (String)opKey);
            Map map = (Map)opMap.get("name");
            return (String)map.get(Lang.get().getLocale().toString());
        }
        catch (Exception e) {
            return String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u9501---%s", (String)"DatalockListPlugin_9", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), opKey);
        }
    }

    private QFilter[] getQfilter() {
        ListShowParameter listShowParameter;
        String billFormId;
        String filterJson = this.getPageCache().get(FILTER);
        ArrayList<QFilter> filter = new ArrayList<QFilter>();
        if (filterJson != null) {
            Map map = (Map)SerializationUtils.fromJsonString((String)filterJson, HashMap.class);
            for (Map.Entry entry : map.entrySet()) {
                filter.add(new QFilter((String)entry.getKey(), "like", (Object)("%" + (String)entry.getValue() + "%")));
            }
        }
        if (FORMID_BOS_MYDATALOCK.equals(billFormId = (listShowParameter = (ListShowParameter)this.getView().getFormShowParameter()).getBillFormId())) {
            String currUserId = RequestContext.get().getUserId();
            filter.add(new QFilter("user.id", "=", (Object)currUserId));
        }
        return filter.toArray(new QFilter[filter.size()]);
    }

    public static List<Map<String, Object>> getAbnormalDataLock(List<Long> idList) {
        SqlBuilder sbBuilder = new SqlBuilder();
        sbBuilder.append("select fentitykey,foperationkey,fobjectid,fgroupid from t_mutex_datalock where", new Object[0]).appendIn("fid", (Object[])idList.toArray(new Long[idList.size()]));
        List lockList = (List)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sbBuilder, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
                while (rs.next()) {
                    HashMap<String, String> requireParam = new HashMap<String, String>();
                    requireParam.put(DatalockListPlugin.MUTEX_ENTITY_KEY, rs.getString(1));
                    requireParam.put(DatalockListPlugin.MUTEX_OPERATION_KEY, rs.getString(2));
                    requireParam.put(DatalockListPlugin.MUTEX_DATA_OBJID, rs.getString(3));
                    requireParam.put(DatalockListPlugin.MUTEX_GROUP_ID, rs.getString(4));
                    list.add(requireParam);
                }
                return list;
            }
        });
        return lockList;
    }

    private List<Map<String, Object>> getMutexDataNew() {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
        String prefixKey = RequestContext.get().getAccountId() + "_datalock_";
        ArrayList keys = new ArrayList();
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        Map<String, String[]> mapping = this.getEntityGroupMaping();
        for (String key : keys) {
            if (key == null || key.contains("_datalock_all_netgroup")) continue;
            Map map = cache.getAll(key);
            for (Map.Entry row : map.entrySet()) {
                Map detail = (Map)SerializationUtils.fromJsonString((String)((String)row.getValue()), Map.class);
                detail.put(MUTEX_DATA_OBJID, row.getKey());
                if (detail.get(MUTEX_GROUP_ID) == null) {
                    if (mapping.containsKey(key.replace(prefixKey, ""))) {
                        String[] info = mapping.get(key.replace(prefixKey, ""));
                        detail.put(MUTEX_ENTITY_KEY, info[0]);
                        detail.put(MUTEX_GROUP_ID, info[1]);
                    } else {
                        detail.put("isDirtyData", "true");
                        detail.put("redis_cacheKey", key);
                    }
                }
                data.add(detail);
            }
        }
        return data;
    }

    private Map<String, String[]> getEntityGroupMaping() {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
        String cacheType = RequestContext.get().getAccountId() + "_datalock_all_netgroup";
        Map cacheValues = cache.getAll(cacheType);
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        for (Map.Entry entry : cacheValues.entrySet()) {
            if (StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
            String entityKey = (String)entry.getKey();
            Map ops = (Map)SerializationUtils.fromJsonString((String)((String)entry.getValue()), Map.class);
            for (Map.Entry op : ops.entrySet()) {
                if (!StringUtils.isNotBlank((CharSequence)((CharSequence)op.getValue()))) continue;
                result.put(entityKey + "_" + (String)op.getValue(), new String[]{entityKey, (String)op.getValue()});
            }
        }
        return result;
    }

    private boolean isRedisDataProvider() {
        return this.getModel().getContextVariable(LOADREDISMUTEX) != null && Boolean.parseBoolean(this.getModel().getContextVariable(LOADREDISMUTEX).toString());
    }

    private DynamicObjectCollection queryRedisPageData() {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)FORMID_BOS_DATALOCK);
        DynamicObjectCollection collection = new DynamicObjectCollection((DynamicObjectType)dt, null);
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
        List<Map<String, Object>> allData = this.getMutexDataNew();
        long i = 1L;
        ArrayList<Long> userList = new ArrayList<Long>();
        ArrayList<Object> entityList = new ArrayList<Object>();
        for (Map<String, Object> row : allData) {
            if (row.get(MUTEX_ENTITY_KEY) != null) {
                entityList.add(row.get(MUTEX_ENTITY_KEY));
            }
            if (row.get("userid") == null) continue;
            userList.add(Long.parseLong(row.get("userid").toString()));
        }
        HashMap userObjs = new HashMap();
        HashMap entityObjs = new HashMap();
        if (!userList.isEmpty()) {
            userObjs.putAll(BusinessDataReader.loadFromCache((Object[])userList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_user")));
        }
        if (!entityList.isEmpty()) {
            entityObjs.putAll(BusinessDataReader.loadFromCache((Object[])entityList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_objecttype")));
        }
        boolean releseDirthData = Boolean.parseBoolean(this.getPageCache().get(RELEASEDIRTYDATA));
        this.getPageCache().remove(IDDATAMAPPING);
        HashMap<String, String> idDatas = new HashMap<String, String>(allData.size());
        for (Map<String, Object> row : allData) {
            String objId = String.valueOf(row.get(MUTEX_DATA_OBJID));
            if (releseDirthData && row.containsKey("isDirtyData")) {
                String cacheKey = row.get("redis_cacheKey").toString();
                cache.remove(cacheKey, objId);
                continue;
            }
            DynamicObject obj = collection.addNew();
            String entityKey = String.valueOf(row.get(MUTEX_ENTITY_KEY));
            String opKey = String.valueOf(row.get("opkey"));
            String groupId = MUTEX_GROUP_ID;
            idDatas.put(String.valueOf(i), String.format("%s@@%s@@%s@@%s", entityKey, groupId, objId, opKey));
            obj.set("id", (Object)i++);
            obj.set(KEY_OBJECTID, row.get(MUTEX_DATA_OBJID));
            if (row.get(MUTEX_ENTITY_KEY) != null) {
                obj.set(KEY_ENTITY_KEY, entityObjs.get(entityKey));
            }
            obj.set("user", userObjs.get(Long.parseLong(row.get("userid").toString())));
            obj.set(KEY_OPERATION, (Object)opKey);
            obj.set(CREATE_TIME, (Object)Long.parseLong(row.get("lockedTime").toString()));
            obj.set(KEY_CLIENT, row.get(KEY_CLIENT));
        }
        this.getPageCache().put(IDDATAMAPPING, SerializationUtils.toJsonString(idDatas));
        this.setLoadRedisDataFlag();
        this.getPageCache().remove(RELEASEDIRTYDATA);
        return collection;
    }

    private void setLoadRedisDataFlag() {
        this.getPageCache().put(ISREDISDATA, "true");
    }

    private void cleatLoadRedisDataFlag() {
        this.getPageCache().put(ISREDISDATA, "false");
    }

    public void pagerClick(PagerClickEvent arg0) {
    }

    public static List<String> releaseDataMutex(List<Map<String, Object>> lockInfo) {
        ArrayList<String> notDeleteData = new ArrayList<String>();
        try (DataMutex dataMutex = DataMutex.create();){
            Map releaseResult = dataMutex.batchRelease(lockInfo);
            for (Map.Entry releaseItem : releaseResult.entrySet()) {
                boolean releaseRet = (Boolean)releaseItem.getValue();
                String objId = (String)releaseItem.getKey();
                if (releaseRet) continue;
                notDeleteData.add(objId);
            }
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u91ca\u653e\u6570\u636e\u5bf9\u8c61\u4e92\u65a5\u9501\u51fa\u9519.%s", (String)"DatalockListPlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), e.getMessage())), new Object[0]);
        }
        return notDeleteData;
    }

    public void closeQueryByOr(CloseQueryByOrEvent args) {
        args.setQueryByOr(false);
    }

    class DatalockListDataProviderImpl
    extends ListDataProvider {
        DatalockListDataProviderImpl() {
        }

        private Map<String, Map<String, Object>> getBillNoData(DynamicObjectCollection lockinfos) {
            HashMap billNames = new HashMap();
            HashMap<String, Map<String, Object>> returnData = new HashMap<String, Map<String, Object>>(lockinfos.size());
            for (DynamicObject row : lockinfos) {
                String entityNumber;
                if (StringUtils.isNotBlank((CharSequence)row.getString(DatalockListPlugin.KEY_BIZOBJECT_NAME)) || StringUtils.isBlank((CharSequence)(entityNumber = row.getString(DatalockListPlugin.KEY_ENTITYKEY_NUMBER)))) continue;
                Object lockObjectPkId = row.get(DatalockListPlugin.KEY_OBJECTID);
                try {
                    BillEntityType lockBillDT;
                    MainEntityType lockEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                    if (!(lockEntityType instanceof BillEntityType) || StringUtils.isBlank((CharSequence)(lockBillDT = (BillEntityType)lockEntityType).getBillNo())) continue;
                    if (lockEntityType.getPrimaryKey().getDbType() == -5) {
                        lockObjectPkId = Long.parseLong(String.valueOf(lockObjectPkId));
                    }
                    billNames.putIfAbsent(entityNumber, new ArrayList());
                    ((List)billNames.get(entityNumber)).add(lockObjectPkId);
                }
                catch (Exception e) {}
            }
            for (Map.Entry it : billNames.entrySet()) {
                BillEntityType lockBillDT = (BillEntityType)EntityMetadataCache.getDataEntityType((String)((String)it.getKey()));
                DynamicObject[] objs = BusinessDataServiceHelper.load((String)((String)it.getKey()), (String)("id," + lockBillDT.getBillNo()), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)((List)it.getValue()).toArray())});
                HashMap<String, Object> data = new HashMap<String, Object>(objs.length);
                for (DynamicObject obj : objs) {
                    Object billNo = obj.get(lockBillDT.getBillNo());
                    if (billNo == null || !StringUtils.isNotBlank((CharSequence)String.valueOf(billNo))) continue;
                    data.put(obj.getPkValue().toString(), billNo);
                }
                returnData.put((String)it.getKey(), (Map<String, Object>)data);
            }
            return returnData;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection lockInFos = DatalockListPlugin.this.isRedisDataProvider() ? DatalockListPlugin.this.queryRedisPageData() : super.getData(start, limit);
            Map<String, Map<String, Object>> billNumMaping = this.getBillNoData(lockInFos);
            for (int i = 0; i < lockInFos.size(); ++i) {
                DynamicObject lockInfo = (DynamicObject)lockInFos.get(i);
                String entityNumber = lockInfo.getString(DatalockListPlugin.KEY_ENTITYKEY_NUMBER);
                String lockObjectPkId = lockInfo.getString(DatalockListPlugin.KEY_OBJECTID);
                if (StringUtils.isBlank((CharSequence)lockInfo.getString(DatalockListPlugin.KEY_BIZOBJECT_NAME))) {
                    Map<String, Object> dataMap = billNumMaping.get(entityNumber);
                    if (dataMap == null) {
                        lockInfo.set(DatalockListPlugin.KEY_BIZOBJECT_NAME, (Object)lockObjectPkId);
                    } else {
                        lockInfo.set(DatalockListPlugin.KEY_BIZOBJECT_NAME, (Object)String.valueOf(dataMap.getOrDefault(lockObjectPkId, lockObjectPkId)));
                    }
                }
                String lockOperation = lockInfo.getString(DatalockListPlugin.KEY_OPERATION);
                try {
                    lockOperation = DatalockListPlugin.this.getOperationName(entityNumber, lockOperation);
                }
                catch (Exception e) {
                    lockOperation = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u9501---%s", (String)"DatalockListPlugin_9", (String)DatalockListPlugin.BOS_FORM_BUSINESS, (Object[])new Object[0]), lockOperation);
                }
                lockInfo.set(DatalockListPlugin.KEY_OPERATION, (Object)lockOperation);
            }
            this.getQueryResult().setDataCount(lockInFos.size());
            this.getQueryResult().setCollection(lockInFos);
            return lockInFos;
        }

        public int getRealCount() {
            String dataCount = DatalockListPlugin.this.getPageCache().get(DatalockListPlugin.DATACOUNT);
            if (StringUtils.isNotBlank((CharSequence)dataCount)) {
                return Integer.parseInt(dataCount);
            }
            return super.getRealCount();
        }
    }
}

