/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.sample.bill.billconvert.bizcase;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterCreateLinkEventArgs;
import kd.bos.entity.botp.plugin.args.InitVariableEventArgs;

public class InitVariableSample
extends AbstractConvertPlugIn {
    private String targetEntityNumber;
    private String key_entryentity;
    private boolean isOtherBill = false;
    private String key_AllAmountOri;
    private String key_AllAmountOri_D;
    private String key_AllAmount;
    private String key_AmountOri;
    private String key_AmountOri_D;
    private String key_Amount;
    private String key_TaxAmountOri;
    private String key_TaxAmountOri_D;
    private String key_TaxAmount;

    public void initVariable(InitVariableEventArgs e) {
        this.targetEntityNumber = this.getTgtMainType().getName();
        this.setAmountKey();
    }

    public void afterCreateLink(AfterCreateLinkEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        if (this.isOtherBill) {
            return;
        }
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(this.targetEntityNumber)) {
            this.calcAmount(billDataEntity);
        }
    }

    private void setAmountKey() {
        if (StringUtils.equals((CharSequence)this.targetEntityNumber, (CharSequence)"iv_purexpinv")) {
            this.key_entryentity = "entryentity";
            this.key_AllAmountOri = "amountori";
            this.key_AllAmountOri_D = "amountori";
            this.key_AllAmount = "amount";
            this.key_AmountOri = "headauxpriceori";
            this.key_AmountOri_D = "headauxpriceori";
            this.key_Amount = "headauxprice";
            this.key_TaxAmountOri = "deductibletaxori";
            this.key_TaxAmountOri_D = "deductibletaxori";
            this.key_TaxAmount = "deductibletax";
        } else if (StringUtils.equals((CharSequence)this.targetEntityNumber, (CharSequence)"iv_saleexpinv")) {
            this.key_entryentity = "entryentity";
            this.key_AllAmountOri = "aftertotaltaxfor";
            this.key_AllAmountOri_D = "allamountori";
            this.key_AllAmount = "aftertotaltax";
            this.key_AmountOri = "headauxpriceori";
            this.key_AmountOri_D = "amountori";
            this.key_Amount = "headauxprice";
            this.key_TaxAmountOri = "taxamount";
            this.key_TaxAmountOri_D = "detailtaxamountori";
            this.key_TaxAmount = "taxamountori";
        } else {
            this.isOtherBill = true;
        }
    }

    private void calcAmount(ExtendedDataEntity billDataEntity) {
        long currencyID = (Long)billDataEntity.getValue("currencyid_id");
        long mainCurrencyID = (Long)billDataEntity.getValue("mainbookstdcurrid_id");
        long exchangeTypeID = (Long)billDataEntity.getValue("exchangetype_id");
        Date date = (Date)billDataEntity.getValue("date");
        BigDecimal rate = new BigDecimal("0");
        if (currencyID > 0L && mainCurrencyID > 0L) {
            rate = this.getExchangeBusRate(currencyID, mainCurrencyID, exchangeTypeID, date);
        }
        billDataEntity.setValue("exchangerate", (Object)rate);
        BigDecimal taxAmountOriH = new BigDecimal("0");
        BigDecimal noTaxAmountOriH = new BigDecimal("0");
        BigDecimal totalTaxAmountOriH = new BigDecimal("0");
        DynamicObjectCollection entryRows = (DynamicObjectCollection)billDataEntity.getValue(this.key_entryentity);
        for (DynamicObject entryRow : entryRows) {
            taxAmountOriH = taxAmountOriH.add(entryRow.getBigDecimal(this.key_TaxAmountOri_D));
            noTaxAmountOriH = noTaxAmountOriH.add(entryRow.getBigDecimal(this.key_AmountOri_D));
            totalTaxAmountOriH = totalTaxAmountOriH.add(entryRow.getBigDecimal(this.key_AllAmountOri_D));
        }
        billDataEntity.setValue(this.key_TaxAmountOri, (Object)taxAmountOriH);
        billDataEntity.setValue(this.key_AmountOri, (Object)noTaxAmountOriH);
        billDataEntity.setValue(this.key_AllAmountOri, (Object)totalTaxAmountOriH);
        MathContext mc = new MathContext(10, RoundingMode.HALF_UP);
        billDataEntity.setValue(this.key_TaxAmount, (Object)taxAmountOriH.multiply(rate, mc));
        billDataEntity.setValue(this.key_Amount, (Object)noTaxAmountOriH.multiply(rate, mc));
        billDataEntity.setValue(this.key_AllAmount, (Object)totalTaxAmountOriH.multiply(rate, mc));
    }

    private BigDecimal getExchangeBusRate(long currencyId1, long currencyId2, long exchangeType, Date date) {
        return new BigDecimal("1");
    }
}

