/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.sample.bill.bizoperation.bizcase;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;

public class BeforeExecuteOperationTransactionSample
extends AbstractOperationServicePlugIn {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_SUBENTRYENTITY = "subentryentity";
    private static final String KEY_DELIVERYDATE = "deliverydate";
    private static final String KEY_LASTDATE = "lastdate";
    private SimpleDateFormat timesdf = new SimpleDateFormat("yyyy-MM-dd");

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add(KEY_DELIVERYDATE);
        e.getFieldKeys().add(KEY_LASTDATE);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        ArrayList<ExtendedDataEntity> passDataEntitys = new ArrayList<ExtendedDataEntity>();
        for (ExtendedDataEntity dataEntity : e.getValidExtDataEntities()) {
            if (!this.delivaryDateValidate(dataEntity)) continue;
            passDataEntitys.add(dataEntity);
        }
        e.getValidExtDataEntities().clear();
        if (passDataEntitys.isEmpty()) {
            e.cancel = true;
        } else {
            e.getValidExtDataEntities().addAll(passDataEntitys);
        }
    }

    private boolean delivaryDateValidate(ExtendedDataEntity dataEntity) {
        MainEntityType mainType = (MainEntityType)dataEntity.getDataEntity().getDataEntityType();
        RowDataModel rowDataModel = new RowDataModel(KEY_SUBENTRYENTITY, mainType);
        DynamicObjectCollection entryRows = dataEntity.getDataEntity().getDynamicObjectCollection(KEY_ENTRYENTITY);
        for (DynamicObject entryRow : entryRows) {
            DynamicObjectCollection subEntryRows = entryRow.getDynamicObjectCollection(KEY_SUBENTRYENTITY);
            for (DynamicObject subEntryRow : subEntryRows) {
                Date lastDate;
                rowDataModel.setRowContext(subEntryRow);
                Date deliveryDate = (Date)rowDataModel.getValue(KEY_DELIVERYDATE);
                if (deliveryDate.compareTo(lastDate = (Date)rowDataModel.getValue(KEY_LASTDATE)) <= 0) continue;
                this.addErrMessage(dataEntity, String.format("\u9884\u8ba1\u9001\u8d27\u65e5\u671f(%s)\uff0c\u4e0d\u80fd\u665a\u4e8e\u6700\u8fdf\u9001\u8d27\u65e5\u671f(%s)\uff01", this.timesdf.format(deliveryDate), this.timesdf.format(lastDate)));
                return false;
            }
        }
        return true;
    }

    private void addErrMessage(ExtendedDataEntity dataEntity, String errMsg) {
        Object pkId = dataEntity.getDataEntity().getPkValue();
        int dataIndex = dataEntity.getDataEntityIndex();
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        ValidationErrorInfo errInfo = new ValidationErrorInfo("", pkId, dataIndex, rowIndex, "BeforeExecuteOperationTransactionSample", "\u9001\u8d27\u65e5\u671f\u68c0\u67e5", errMsg, errorLevel);
        this.operationResult.addErrorInfo((OperateErrorInfo)errInfo);
    }
}

