/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.sample.bill.bizoperation.bizcase;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.validate.AbstractValidator;

class DelivaryDateValidator
extends AbstractValidator {
    public static final String KEY_DELIVERYDATE = "deliverydate";
    public static final String KEY_LASTDATE = "lastdate";

    DelivaryDateValidator() {
    }

    public String getEntityKey() {
        return this.entityKey;
    }

    public void initializeConfiguration() {
        super.initializeConfiguration();
        this.entityKey = "subentryentity";
    }

    public void initialize() {
        super.initialize();
    }

    public void validate() {
        RowDataModel rowDataModel = new RowDataModel(this.entityKey, this.getValidateContext().getSubEntityType());
        SimpleDateFormat timesdf = new SimpleDateFormat("yyyy-MM-dd");
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            rowDataModel.setRowContext(rowDataEntity.getDataEntity());
            Date deliveryDate = (Date)rowDataModel.getValue(KEY_DELIVERYDATE);
            Date lastDate = (Date)rowDataModel.getValue(KEY_LASTDATE);
            if (deliveryDate.compareTo(lastDate) <= 0) continue;
            this.addErrorMessage(rowDataEntity, String.format("\u9884\u8ba1\u9001\u8d27\u65e5\u671f(%s)\uff0c\u4e0d\u80fd\u665a\u4e8e\u6700\u8fdf\u9001\u8d27\u65e5\u671f(%s)\uff01", timesdf.format(deliveryDate), timesdf.format(lastDate)));
        }
    }
}

