/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.sample.bill.bizoperation.bizcase;

import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.InitOperationArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.plugin.sample.bill.bizoperation.bizcase.SwitchAsynValidatorSample;

public class SwitchAsynSampleOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(SwitchAsynSampleOpPlugin.class);

    public void initialize(InitOperationArgs e) {
        log.debug("initialize");
        this.sleep(2);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        log.debug("onPreparePropertys");
        this.sleep(2);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        log.debug("onAddValidators");
        e.addValidator((AbstractValidator)new SwitchAsynValidatorSample());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        log.debug("beforeExecuteOperationTransaction");
        log.debug("swithToAsyn");
        this.getOperateProgress().swithToAsyn();
        this.sleep(10);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        log.debug("beginOperationTransaction");
        this.sleep(2);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        log.debug("endOperationTransaction");
        this.sleep(2);
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        log.debug("rollbackOperation");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        log.debug("afterExecuteOperationTransaction");
        this.sleep(2);
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        log.debug("onReturnOperation");
    }

    private void sleep(int cycleTime) {
        log.debug("sleep: " + String.valueOf(cycleTime * 500) + "ms");
        int count = 0;
        if (cycleTime < 1 || cycleTime > 10) {
            cycleTime = 10;
        }
        try {
            while (count < cycleTime) {
                String desc = String.format(" \u5faa\u73af\u7b2c  %s / %s \u6b21", count, cycleTime);
                this.getOperateProgress().feedbackProgress(desc);
                Thread.sleep(500L);
                ++count;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

