/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.sample.bill.bizoperation.bizcase;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.interaction.InteractionConfirmResult;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.interaction.KDInteractionException;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.MessageBoxResult;

public class ThrowInteractionExceptionOp
extends AbstractOperationServicePlugIn {
    private static final String Interaction_Sponore = "kd.bos.plugin.sample.bill.bizoperation.bizcase.ThrowInteractionExceptionOp";
    private static final String KEY_IntegerField = "integerfield1";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add(KEY_IntegerField);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        int maxFieldValue = 0;
        for (ExtendedDataEntity dataEntity : e.getValidExtDataEntities()) {
            int fieldValue = (Integer)dataEntity.getValue(KEY_IntegerField);
            if (maxFieldValue >= fieldValue) continue;
            maxFieldValue = fieldValue;
        }
        if (maxFieldValue >= 100 && maxFieldValue < 500) {
            e.cancel = !this.showInteractionMessage();
        } else if (maxFieldValue >= 500) {
            e.cancel = !this.showInteractionForm(e, maxFieldValue);
        }
    }

    private boolean showInteractionMessage() {
        String confirmResultString = this.getOption().getVariableValue("interactionconfirmresult", "");
        InteractionConfirmResult confirmResult = InteractionConfirmResult.fromJsonString((String)confirmResultString);
        if (confirmResult.getResults().containsKey(Interaction_Sponore)) {
            MessageBoxResult result = MessageBoxResult.valueOf((String)((String)confirmResult.getResults().get(Interaction_Sponore)));
            return result == MessageBoxResult.Yes;
        }
        InteractionContext interactionContext = new InteractionContext();
        interactionContext.setSimpleMessage("\u6574\u6570\u5b57\u6bb5\u503c\u8d85\u8fc7\u4e86100\uff0c\u9700\u8981\u7528\u6237\u786e\u8ba4\u624d\u80fd\u4fdd\u5b58");
        OperateErrorInfo errorInfo = new OperateErrorInfo();
        errorInfo.setMessage("\u6574\u65701\u8d85\u8fc7\u4e86100");
        errorInfo.setLevel(ErrorLevel.Warning);
        interactionContext.addOperateInfo(errorInfo);
        throw new KDInteractionException(Interaction_Sponore, interactionContext);
    }

    private boolean showInteractionForm(BeforeOperationArgs e, int maxFieldValue) {
        String confirmResultString = this.getOption().getVariableValue("interactionconfirmresult", "");
        InteractionConfirmResult confirmResult = InteractionConfirmResult.fromJsonString((String)confirmResultString);
        if (confirmResult.getResults().containsKey(Interaction_Sponore)) {
            String newFieldValue = (String)confirmResult.getResults().get(Interaction_Sponore);
            if (StringUtils.isBlank((CharSequence)newFieldValue)) {
                return false;
            }
            for (ExtendedDataEntity dataEntity : e.getValidExtDataEntities()) {
                int fieldValue = (Integer)dataEntity.getValue(KEY_IntegerField);
                if (fieldValue < 500) continue;
                dataEntity.setValue(KEY_IntegerField, (Object)Integer.valueOf(newFieldValue));
            }
            return true;
        }
        InteractionContext interactionContext = new InteractionContext();
        interactionContext.setSimpleMessage("\u6574\u6570\u5b57\u6bb5\u503c\u8d85\u8fc7\u4e86100\uff0c\u9700\u8981\u7528\u6237\u786e\u8ba4\u624d\u80fd\u4fdd\u5b58");
        interactionContext.setCustShowFormId("demo_showinteger");
        interactionContext.getCustShowParameter().put(KEY_IntegerField, String.valueOf(maxFieldValue));
        throw new KDInteractionException(Interaction_Sponore, interactionContext);
    }
}

