/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.sample.dynamicform.pcform.control.bizcase;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.ConfigServiceHelper;
import kd.bos.upload.UploadOption;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ButtonSample
extends AbstractFormPlugin
implements UploadListener {
    private static final String KEY_BUTTON1 = "buttonap1";
    private static final String KEY_BUTTON2 = "buttonap2";
    private static final String KEY_BUTTON3 = "buttonap3";
    private static final String KEY_BUTTONITEM1 = "buttonap1_item1";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button button1 = (Button)this.getView().getControl(KEY_BUTTON1);
        button1.addItemClickListener((ItemClickListener)this);
        Button button2 = (Button)this.getView().getControl(KEY_BUTTON2);
        button2.addClickListener((ClickListener)this);
        Button button3 = (Button)this.getView().getControl(KEY_BUTTON3);
        button3.addClickListener((ClickListener)this);
        button3.addUploadListener((UploadListener)this);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (StringUtils.equals((CharSequence)evt.getItemKey(), (CharSequence)KEY_BUTTONITEM1)) {
            this.getView().showTipNotification(String.format("\u4f60\u70b9\u51fb\u4e86\u5b50\u6309\u94ae %s ", evt.getItemKey()));
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_BUTTON2) && !this.checkBizLogic()) {
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_BUTTON3)) {
            UploadOption option = new UploadOption();
            option.setTitle("\u4e0a\u4f20\u6587\u4ef6");
            option.setMultiple(true);
            option.setSuffix(".xlsx");
            option.setLimitSize(20000L);
            this.getView().showUpload(option, KEY_BUTTON3);
        }
    }

    public void upload(UploadEvent evt) {
    }

    public void afterUpload(UploadEvent evt) {
        ArrayList<String> fileUrls = new ArrayList<String>();
        for (Object url : evt.getUrls()) {
            fileUrls.add((String)((Map)url).get("url"));
        }
        for (String fileUrl : fileUrls) {
            this.loadXLSXFile(fileUrl);
        }
    }

    public void remove(UploadEvent evt) {
    }

    public void afterRemove(UploadEvent evt) {
    }

    private boolean checkBizLogic() {
        return true;
    }

    private void loadXLSXFile(String fileUrl) {
        String ipconfig = ConfigServiceHelper.getGlobalConfiguration((String)"attachment.fileserver").toString();
        String url = ipconfig + fileUrl;
        HttpGet httpUrl = new HttpGet(url);
        InputStream inStream = null;
        XSSFSheet sheet = null;
        try {
            CloseableHttpClient httpClient = HttpClients.createSystem();
            inStream = httpClient.execute((HttpUriRequest)httpUrl).getEntity().getContent();
            XSSFWorkbook book = new XSSFWorkbook(inStream);
            sheet = book.getSheetAt(0);
        }
        catch (Exception e) {
            this.getView().showErrMessage("\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef", e.getMessage());
        }
        String[] cellValues = null;
        if (sheet != null && sheet.getLastRowNum() > 0) {
            XSSFRow row = sheet.getRow(0);
            cellValues = new String[row.getLastCellNum()];
            for (int i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
                cellValues[i] = row.getCell(i).getStringCellValue();
            }
        }
    }
}

