/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.sample.dynamicform.pcform.control.bizcase;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeDragEvent;
import kd.bos.form.control.events.TreeNodeDragListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.plugin.AbstractFormPlugin;

public class TreeViewSample
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeCheckListener,
TreeNodeQueryListener,
TreeNodeDragListener {
    private static final String KEY_TREEVIEW1 = "treeviewap1";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW1);
        treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        treeView.addTreeNodeDragListener((TreeNodeDragListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW1);
        treeView.setMulti(true);
        TreeNode root = new TreeNode("", "node1", "root node");
        root.setChildren(new ArrayList());
        treeView.addNode(root);
        treeView.setRootVisible(true);
        treeView.expand("node1");
        treeView.setDraggable(true);
        treeView.setDroppable(true);
    }

    public void queryTreeNodeChildren(TreeNodeEvent arg0) {
        String nodeId = (String)arg0.getNodeId();
        List<TreeNode> childNodes = this.loadChildNode(nodeId);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW1);
        treeView.addNodes(childNodes);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        this.getView().showTipNotification(String.format("\u60a8\u70b9\u51fb\u4e86\u8282\u70b9%s", evt.getNodeId()));
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
        this.getView().showTipNotification(String.format("\u60a8\u53cc\u51fb\u4e86\u8282\u70b9%s", evt.getNodeId()));
    }

    public void treeNodeCheck(TreeNodeCheckEvent arg0) {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW1);
        TreeView.TreeState treeState = treeView.getTreeState();
        List selectNodeIds = treeState.getCheckedNodeIds();
        if (selectNodeIds.isEmpty()) {
            this.getView().showTipNotification("\u60a8\u6ca1\u6709\u52fe\u9009\u4efb\u4f55\u8282\u70b9");
        } else {
            this.getView().showTipNotification(String.format("\u60a8\u52fe\u9009\u4e86\u8282\u70b9%s", StringUtils.join((Object[])selectNodeIds.toArray(), (String)",")));
        }
    }

    public void treeNodeDragged(TreeNodeDragEvent arg0) {
        String nodeId = (String)arg0.getNodeId();
        String fromParentId = (String)arg0.getFromParentId();
        String toParentId = (String)arg0.getToParentId();
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW1);
        treeView.deleteNode(nodeId);
        TreeNode node = new TreeNode(toParentId, nodeId, nodeId);
        treeView.addNode(node);
    }

    private List<TreeNode> loadChildNode(String parentId) {
        ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>();
        String id1 = parentId + ".1";
        TreeNode node1 = new TreeNode(parentId, id1, id1);
        node1.setChildren(new ArrayList());
        childNodes.add(node1);
        String id2 = parentId + ".2";
        TreeNode node2 = new TreeNode(parentId, id2, id2);
        node2.setChildren(new ArrayList());
        childNodes.add(node2);
        return childNodes;
    }
}

