/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.sample.dynamicform.pcform.entrygrid.bizcase;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.plugin.sample.dynamicform.pcform.entrygrid.bizcase.MyEntryGrid4000DataControl;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BatchLoadEntryRows4000DataSample
extends AbstractFormPlugin {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_TEXTFIELD = "textfield1";
    private static final String KEY_AMOUNTFIELD = "kdtest_amountfield";
    private static final String KEY_INTEGERFIELD = "kdtest_integerfield";
    private static final String KEY_CURRENCYFIELD = "kdtest_currencyfield";
    private static final String KEY_DECIMALFIELD = "kdtest_decimalfield";

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{KEY_ENTRYENTITY});
    }

    public void afterCreateNewData(EventObject e) {
        int rowCount = 4000;
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        int pageRow = grid.getPageRow();
        DynamicObject billObj = this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection(KEY_ENTRYENTITY);
        rows.clear();
        QFilter enableFilter = new QFilter("enable", "=", (Object)true);
        QFilter nameFilter = new QFilter("number", "=", (Object)"CNY");
        QFilter[] filters = new QFilter[]{enableFilter, nameFilter};
        DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (QFilter[])filters);
        for (int i = 0; i < pageRow; ++i) {
            DynamicObject row = rows.addNew();
            row.set("seq", (Object)i);
            row.set(KEY_TEXTFIELD, (Object)String.format("\u8fd9\u662f\u7b2c%s\u884c\u7684\u6587\u672c\u5b57\u6bb5\u503c", i + 1));
            row.set(KEY_AMOUNTFIELD, (Object)1);
            row.set(KEY_INTEGERFIELD, (Object)1);
            row.set(KEY_DECIMALFIELD, (Object)1);
            if (currency == null) continue;
            row.set(KEY_CURRENCYFIELD, (Object)currency);
        }
        billObj.getDataEntityState().setEntryRowCount(KEY_ENTRYENTITY, rowCount);
        billObj.getDataEntityState().setEntryPageSize(KEY_ENTRYENTITY, pageRow);
        billObj.getDataEntityState().setEntryStartRowIndex(KEY_ENTRYENTITY, 0);
    }

    public void onGetControl(OnGetControlArgs e) {
        if (StringUtils.equals((CharSequence)e.getKey(), (CharSequence)KEY_ENTRYENTITY)) {
            MyEntryGrid4000DataControl entryGrid = null;
            if (!(e.getControl() instanceof MyEntryGrid4000DataControl)) {
                entryGrid = new MyEntryGrid4000DataControl();
                entryGrid.setView(this.getView());
                entryGrid.setKey(KEY_ENTRYENTITY);
                entryGrid.setEntryKey(KEY_ENTRYENTITY);
                entryGrid.setSplitPage(true);
                entryGrid.setSumWithFilter(true);
                Control oldGrid = e.getControl();
                if (oldGrid == null) {
                    this.findControl(KEY_ENTRYENTITY);
                }
                if (oldGrid instanceof EntryGrid) {
                    entryGrid.getItems().addAll(((EntryGrid)oldGrid).getItems());
                    entryGrid.setPageRow(((EntryGrid)oldGrid).getPageRow());
                }
            } else {
                entryGrid = (MyEntryGrid4000DataControl)e.getControl();
            }
            e.setControl((Control)entryGrid);
        }
    }

    private Control findControl(String key) {
        FormRoot root = (FormRoot)this.getView().getRootControl();
        return this.findControl(key, root.getItems());
    }

    private Control findControl(String key, List<Control> items) {
        for (Control ctl : items) {
            Control subCtl;
            if (StringUtils.equals((CharSequence)key, (CharSequence)ctl.getKey())) {
                return ctl;
            }
            if (!(ctl instanceof Container) || (subCtl = this.findControl(key, ((Container)ctl).getItems())) == null) continue;
            return subCtl;
        }
        return null;
    }
}

