/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.sample.dynamicform.pcform.entrygrid.bizcase;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.TimeServiceHelper;

public class CreateGridColumnsSample
extends AbstractFormPlugin
implements EntryGridBindDataListener {
    private static final String KEY_GRIDCOLS = "gridcols";
    private static final String KEY_ENTRYENTITY = "entryentity";

    public void registerListener(EventObject e) {
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        grid.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.rebuildGridCols();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)KEY_GRIDCOLS)) {
            this.rebuildGridCols();
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        int pageIndex = grid.getEntryState().getCurrentPageIndex();
        String gridcolsFldValue = (String)this.getModel().getValue(KEY_GRIDCOLS);
        int colCount = StringUtils.isBlank((CharSequence)gridcolsFldValue) ? 1 : Integer.parseInt(gridcolsFldValue);
        Map<String, Object> data = this.createGridPageData(pageIndex, colCount);
        e.getData().putAll(data);
    }

    private void rebuildGridCols() {
        String cols = (String)this.getModel().getValue(KEY_GRIDCOLS);
        int colCount = StringUtils.isBlank((CharSequence)cols) ? 1 : Integer.parseInt(cols);
        Map<String, Object> gridMeta = this.createGridColumns(colCount);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.preInvokeControlMethod(KEY_ENTRYENTITY, "createGridColumns", new Object[]{gridMeta});
        int pageIndex = 1;
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        grid.getEntryState().setCurrentPageIndex(Integer.valueOf(pageIndex));
        Map<String, Object> data = this.createGridPageData(pageIndex, colCount);
        clientViewProxy.setEntryProperty(KEY_ENTRYENTITY, "data", data);
    }

    private Map<String, Object> createGridColumns(int colCount) {
        ArrayList columns = new ArrayList();
        HashMap<String, Object> seqColumn = new HashMap<String, Object>();
        seqColumn.put("entity", KEY_ENTRYENTITY);
        seqColumn.put("dataIndex", "seq");
        seqColumn.put("coltype", 1);
        seqColumn.put("header", new LocaleString("\u5e8f\u53f7"));
        seqColumn.put("vi", 1);
        seqColumn.put("w", new LocaleString("30px"));
        seqColumn.put("text-align", "default");
        HashMap<String, String> seqEditor = new HashMap<String, String>();
        seqEditor.put("type", "long");
        seqColumn.put("editor", seqEditor);
        columns.add(seqColumn);
        HashMap<String, Object> txtColumn = new HashMap<String, Object>();
        txtColumn.put("entity", KEY_ENTRYENTITY);
        txtColumn.put("dataIndex", "textfield1");
        txtColumn.put("coltype", 1);
        txtColumn.put("header", new LocaleString("\u6587\u672c\u5b57\u6bb51"));
        txtColumn.put("vi", 1);
        txtColumn.put("w", new LocaleString("120px"));
        txtColumn.put("text-align", "default");
        HashMap<String, String> txtEditor = new HashMap<String, String>();
        txtEditor.put("type", "text");
        txtColumn.put("editor", txtEditor);
        columns.add(txtColumn);
        if (colCount > 1) {
            HashMap<String, Object> decimalColumn = new HashMap<String, Object>();
            decimalColumn.put("entity", KEY_ENTRYENTITY);
            decimalColumn.put("dataIndex", "decimalfield1");
            decimalColumn.put("coltype", 2);
            decimalColumn.put("header", new LocaleString("\u6570\u503c\u5b57\u6bb51"));
            decimalColumn.put("vi", 1);
            decimalColumn.put("w", new LocaleString("80px"));
            decimalColumn.put("text-align", "right");
            HashMap<String, String> decimalEditor = new HashMap<String, String>();
            decimalEditor.put("type", "number");
            decimalColumn.put("editor", decimalEditor);
            columns.add(decimalColumn);
        }
        if (colCount > 2) {
            HashMap<String, Object> dateColumn = new HashMap<String, Object>();
            dateColumn.put("entity", KEY_ENTRYENTITY);
            dateColumn.put("dataIndex", "datefield1");
            dateColumn.put("coltype", 3);
            dateColumn.put("header", new LocaleString("\u65e5\u671f\u5b57\u6bb51"));
            dateColumn.put("vi", 1);
            dateColumn.put("w", new LocaleString("120px"));
            dateColumn.put("text-align", "default");
            HashMap<String, String> dateEditor = new HashMap<String, String>();
            dateEditor.put("type", "text");
            dateColumn.put("editor", dateEditor);
            columns.add(dateColumn);
        }
        HashMap<String, Object> gridMeta = new HashMap<String, Object>();
        gridMeta.put("rk", "rk");
        gridMeta.put("seq", "seq");
        gridMeta.put("columns", columns);
        gridMeta.put("vi", 1);
        gridMeta.put("type", "grid");
        return gridMeta;
    }

    private Map<String, Object> createGridPageData(int pageIndex, int colCount) {
        List<Object> rows = this.createRowsData(pageIndex, colCount);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("rowcount", 20);
        data.put("rows", rows);
        data.put("pagerows", 10);
        data.put("pageindex", pageIndex);
        data.put("isSplitPage", true);
        data.put("pagecount", 2);
        data.put("datacount", 20);
        HashMap<String, Integer> dataIndex = new HashMap<String, Integer>();
        dataIndex.put("rk", 0);
        dataIndex.put("seq", 1);
        dataIndex.put("id", 2);
        dataIndex.put("pid", 3);
        dataIndex.put("textfield1", 4);
        if (colCount > 1) {
            dataIndex.put("decimalfield1", 5);
        }
        if (colCount > 2) {
            dataIndex.put("datefield1", 6);
        }
        int i = data.size();
        dataIndex.put("l", i);
        dataIndex.put("s", i + 1);
        dataIndex.put("vi", i + 2);
        dataIndex.put("cprop", i + 3);
        data.put("dataindex", dataIndex);
        return data;
    }

    private List<Object> createRowsData(int pageIndex, int colCount) {
        ArrayList<Object> rows = new ArrayList<Object>(10);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < 10; ++i) {
            int seq = (pageIndex - 1) * 10 + i + 1;
            ArrayList<Object> row = new ArrayList<Object>(10);
            row.add(seq - 1);
            row.add(seq);
            row.add(null);
            row.add(null);
            row.add(String.format("\u7b2c %s \u884c\u6587\u672c\u5b57\u6bb5\u503c", seq));
            if (colCount > 1) {
                row.add(seq);
            }
            if (colCount > 2) {
                row.add(dateFormat.format(TimeServiceHelper.now()));
            }
            row.add(new HashMap(0));
            row.add(new HashMap(0));
            row.add(new HashMap(0));
            row.add(new HashMap(0));
            rows.add(row);
        }
        return rows;
    }
}

