/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.test.mutex;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.IDService;

public class AddMutexDataPlugin
extends AbstractFormPlugin {
    DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("dataMutex-pagecache", new DistributeCacheHAPolicy(true, true));
    static final int CACHE_KEEP_TIME_S = Integer.parseInt(System.getProperty("mutex.cachetimeout_h", "24")) * 60 * 60;
    private static final String MODIFY = "modify";
    private static final String BTN_ADD = "adddata";
    public static final String KEY_SESSION = "GLOBALSESSION";
    public static final String KEY_USERID = "userid";
    public static final String KEY_LOCKEDTIME = "lockedTime";
    public static final String KEY_CLIENT = "client";
    public static final String KEY_OPKEY = "opkey";
    public static final String PARAMNAME_DATAOBJID = "dataObjId";
    public static final String PARAMNAME_GROUPID = "groupId";
    public static final String PARAMNAME_ENTITYKEY = "entityKey";
    private static final String DEFAULT_NETCTRL = "default_netctrl";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{BTN_ADD});
        this.addClickListeners(new String[]{BTN_ADD});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void itemClick(ItemClickEvent evt) {
        if (!BTN_ADD.equals(evt.getItemKey())) {
            return;
        }
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(1000);
        HashMap<String, String> cacheLockInfo = new HashMap<String, String>();
        String entityKey = this.getView().getEntityId();
        RequestContext rc = RequestContext.get();
        long currUserId = rc.getCurrUserId();
        String accountId = rc.getAccountId();
        String globalSessionId = rc.getGlobalSessionId();
        String client = rc.getClient();
        for (int i = 1; i <= 100000; ++i) {
            String dataObjId = String.valueOf(i);
            sqlParams.add(this.buildSQLParameter(dataObjId, DEFAULT_NETCTRL, entityKey, MODIFY, currUserId, globalSessionId, accountId, client, null));
            if (i % 1000 == 0) {
                this.batchWriteDb(sqlParams);
                sqlParams.clear();
            }
            this.addRedisMutex(cacheLockInfo, entityKey, dataObjId, MODIFY, currUserId, globalSessionId, accountId);
        }
        if (!cacheLockInfo.isEmpty()) {
            String lockCacheType = this.buildLockCacheTypeName(entityKey, DEFAULT_NETCTRL);
            this.cache.put(lockCacheType, cacheLockInfo, CACHE_KEEP_TIME_S);
            this.cache.put(lockCacheType, entityKey, JSON.toJSONString((Object)DEFAULT_NETCTRL), CACHE_KEEP_TIME_S);
        }
        this.getView().showMessage("\u5b8c\u6210");
    }

    private Object[] buildSQLParameter(String dataObjId, String groupId, String entityKey, String operationKey, Long userId, String gSessionId, String accountId, String client, Date lockTime) {
        Object[] params = new SqlParameter[9];
        if (lockTime == null) {
            lockTime = new Date();
        }
        long id = IDService.get().genLongId(accountId, "t_mutex_datalock");
        params[0] = new SqlParameter(":FID", -5, (Object)id);
        params[1] = new SqlParameter(":FUserID", -5, (Object)userId);
        params[2] = new SqlParameter(":FSessionID", 12, (Object)(StringUtils.isBlank((CharSequence)gSessionId) ? "" : gSessionId));
        params[3] = new SqlParameter(":FEntityKey", 12, (Object)entityKey);
        params[4] = new SqlParameter(":FOperationKey", 12, (Object)operationKey);
        params[5] = new SqlParameter(":FGroupID", 12, (Object)groupId);
        params[6] = new SqlParameter(":FObjectID", 12, (Object)dataObjId);
        params[7] = new SqlParameter(":fclienttype", 12, (Object)client);
        params[8] = new SqlParameter(":FCreateTime", 93, (Object)lockTime);
        return params;
    }

    private void batchWriteDb(List<Object[]> sqlParams) {
        if (sqlParams.isEmpty()) {
            return;
        }
        String strInsertSQL = "INSERT INTO t_mutex_datalock (FID,FUserID,FSessionID,FEntityKey,FOperationKey,FGroupID,FObjectID,fclienttype,FCreateTime)  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?) ";
        try (TXHandle handle = TX.requiresNew();){
            try {
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)strInsertSQL, sqlParams);
            }
            catch (Exception e) {
                handle.markRollback();
            }
        }
    }

    private void addRedisMutex(Map<String, String> cacheLockInfo, String entityKey, String dataObjId, String operationKey, Long userId, String gSessionId, String accountId) {
        HashMap<String, String> lockInfo = new HashMap<String, String>();
        lockInfo.put(KEY_USERID, String.valueOf(userId));
        lockInfo.put(KEY_LOCKEDTIME, String.valueOf(System.currentTimeMillis()));
        lockInfo.put(KEY_CLIENT, accountId);
        lockInfo.put(KEY_SESSION, gSessionId);
        lockInfo.put(PARAMNAME_GROUPID, DEFAULT_NETCTRL);
        lockInfo.put(PARAMNAME_ENTITYKEY, entityKey);
        lockInfo.put(PARAMNAME_DATAOBJID, dataObjId);
        lockInfo.put(KEY_OPKEY, operationKey);
        cacheLockInfo.put(dataObjId, JSON.toJSONString(lockInfo));
    }

    private String buildLockCacheTypeName(String entityKey, String groupId) {
        String accountId = RequestContext.get().getAccountId();
        String type = accountId + "_datalock_" + entityKey + "_" + groupId;
        return type;
    }
}

