/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.test.report.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.IReportBatchQueryInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;

public class DemoBigDataReportTreeListDataPlugin
extends AbstractReportListDataPlugin {
    private String TAG_NAME = "kdtest_reporttree_ds";

    public DataSet query(ReportQueryParam queryParam, Object selectedObj) throws Throwable {
        return this.querybatch(queryParam);
    }

    private DataSet querybatch(ReportQueryParam queryParam) {
        boolean isBatchQuery;
        ArrayList<QFilter> searchFilterList = new ArrayList<QFilter>();
        if (!CollectionUtils.isEmpty((Collection)queryParam.getFilter().getHeadFilters())) {
            searchFilterList.addAll(queryParam.getFilter().getHeadFilters());
        }
        if (isBatchQuery = queryParam.getFilter().getBoolean("kdtest_isbatchquery")) {
            IReportBatchQueryInfo byBatchInfo = queryParam.byBatchInfo();
            List currentBatchRows = byBatchInfo.getCurrentBatchRows();
            HashSet<String> billNos = new HashSet<String>(200);
            for (Object currentBatchRow : currentBatchRows) {
                billNos.add(currentBatchRow.getString("number"));
            }
            QFilter filter = new QFilter("number", "in", (Object)billNos.toArray());
            for (Object e : billNos) {
                filter.or(new QFilter("longnumber", "like", (Object)(e + ".%")));
            }
            searchFilterList.add(filter);
        }
        String queryEntity = this.getQueryEntity(queryParam);
        ORM orm = ORM.create();
        String selectedField = "number,name as textfield,longnumber,parent as pid,isleaf,id as rowid";
        DataSet ds = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), queryEntity, selectedField, searchFilterList.toArray(new QFilter[0]), "longnumber");
        RowMeta seqRowMeta = this.rowMetaAddField(ds.getRowMeta(), "isgroupnode", (DataType)DataType.BooleanType);
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        for (Row row : ds) {
            Row perRow = RowUtil.persist((Row)row);
            Object[] newRows = this.rowAddField(perRow, row.getBoolean("isleaf") == false);
            arrayList.add(newRows);
        }
        DataSet dataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(arrayList.iterator(), seqRowMeta);
        return dataSet.orderBy(new String[]{"longnumber"});
    }

    public DataSet queryBatchBy(ReportQueryParam queryParam) {
        int maxRowCountCached;
        int maxExcelRowCountPerSheet;
        boolean isBatchQuery = queryParam.getFilter().getBoolean("kdtest_isbatchquery");
        if (!isBatchQuery) {
            return null;
        }
        String queryEntity = this.getQueryEntity(queryParam);
        int countPerBatch = queryParam.getFilter().getInt("kdtest_countperbatch");
        if (countPerBatch == 0) {
            countPerBatch = 100;
        }
        if ((maxExcelRowCountPerSheet = queryParam.getFilter().getInt("kdtest_maxexcelrow")) == 0) {
            maxExcelRowCountPerSheet = 1000000;
        }
        if ((maxRowCountCached = queryParam.getFilter().getInt("kdtest_maxrowcountcached")) == 0) {
            maxRowCountCached = 100000;
        }
        IReportBatchQueryInfo byBatchInfo = queryParam.byBatchInfo();
        byBatchInfo.setCountPerBatch(countPerBatch);
        byBatchInfo.setMaxRowCountCached(maxRowCountCached);
        byBatchInfo.setMaxExcelRowCountPerSheet(maxExcelRowCountPerSheet);
        QFilter[] filters = new QFilter[]{new QFilter("parent", "=", (Object)0)};
        ORM orm = ORM.create();
        String selectedField = "number";
        return orm.queryDataSet(((Object)((Object)this)).getClass().getName(), queryEntity, selectedField, filters, "number");
    }

    private RowMeta rowMetaAddField(RowMeta rowMeta, String fieldName, DataType fieldType) {
        int count = rowMeta.getFieldCount();
        String[] fieldNames = new String[count + 1];
        DataType[] dataTypes = new DataType[count + 1];
        List dsDataType = rowMeta.getTypes();
        for (int i = 0; i < count; ++i) {
            fieldNames[i] = rowMeta.getFieldName(i);
            dataTypes[i] = (DataType)dsDataType.get(i);
        }
        fieldNames[count] = fieldName;
        dataTypes[count] = fieldType;
        return RowMetaFactory.createRowMeta((String[])fieldNames, (DataType[])dataTypes);
    }

    private Object[] rowAddField(Row row, Object fieldValue) {
        Object[] rowValues = RowUtil.toArray((Row)row);
        int len = rowValues.length;
        Object[] newValues = new Object[len + 1];
        System.arraycopy(rowValues, 0, newValues, 0, len);
        newValues[len] = fieldValue;
        return newValues;
    }

    private String getQueryEntity(ReportQueryParam queryParam) {
        String queryEntity = queryParam.getFilter().getString("kdtest_queryentity");
        if (StringUtils.isBlank((CharSequence)queryEntity)) {
            queryEntity = this.TAG_NAME;
        }
        return queryEntity;
    }
}

